/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.base.ui.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.JComboBox;
import org.weasis.core.api.service.BundleTools;

public class JLocaleCombo
extends JComboBox
implements ItemListener {
    private static final long serialVersionUID = -5355456986860584918L;

    public JLocaleCombo() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale l1, Locale l2) {
                return l1.getDisplayName().compareTo(l2.getDisplayName());
            }
        });
        Locale defaultLocale = Locale.getDefault();
        JLocale dloc = null;
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i].getCountry().length() <= 0) continue;
            JLocale val = new JLocale(locales[i]);
            if (val.getLocale().equals(defaultLocale)) {
                dloc = val;
            }
            this.addItem(val);
        }
        if (dloc != null) {
            this.setSelectedItem(dloc);
        }
        this.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent iEvt) {
        Object item;
        if (iEvt.getStateChange() == 1 && (item = this.getSelectedItem()) instanceof JLocale) {
            Locale locale = ((JLocale)item).getLocale();
            Locale.setDefault(locale);
            this.firePropertyChange("locale", null, locale);
            BundleTools.SYSTEM_PREFERENCES.put((Object)"locale.language", (Object)locale.getLanguage());
            BundleTools.SYSTEM_PREFERENCES.put((Object)"locale.country", (Object)locale.getCountry());
            BundleTools.SYSTEM_PREFERENCES.put((Object)"locale.variant", (Object)locale.getVariant());
        }
    }

    static class JLocale {
        private final Locale locale;

        JLocale(Locale l) {
            if (l == null) {
                throw new IllegalArgumentException("locale cannot be null");
            }
            this.locale = l;
        }

        public String toString() {
            return this.locale.getDisplayName();
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

