/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.StreamImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.ImagingListener;

public class FileLoadRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
        try {
            Object object;
            SeekableStream seekableStream;
            block9: {
                String string = (String)parameterBlock.getObjectParameter(0);
                seekableStream = null;
                try {
                    seekableStream = new FileSeekableStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    object = this.getClass().getClassLoader().getResourceAsStream(string);
                    if (object == null) break block9;
                    seekableStream = SeekableStream.wrapInputStream((InputStream)object, true);
                }
            }
            ImageDecodeParam imageDecodeParam = null;
            if (parameterBlock.getNumParameters() > 1) {
                imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
            }
            object = new ParameterBlock();
            ((ParameterBlock)object).add(seekableStream);
            ((ParameterBlock)object).add(imageDecodeParam);
            RenderingHints.Key key = JAI.KEY_OPERATION_BOUND;
            int n = 2;
            if (renderingHints == null) {
                renderingHints = new RenderingHints(key, new Integer(n));
            } else if (!renderingHints.containsKey(key)) {
                renderingHints = (RenderingHints)renderingHints.clone();
                renderingHints.put(key, new Integer(n));
            }
            OperationRegistry operationRegistry = (OperationRegistry)renderingHints.get(JAI.KEY_OPERATION_REGISTRY);
            RenderedImage renderedImage = RIFRegistry.create(operationRegistry, "stream", (ParameterBlock)object, renderingHints);
            return renderedImage == null ? null : new StreamImage(renderedImage, seekableStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = JaiI18N.getString("FileLoadRIF0") + parameterBlock.getObjectParameter(0);
            imagingListener.errorOccurred(string, fileNotFoundException, this, false);
            return null;
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("FileLoadRIF1");
            imagingListener.errorOccurred(string, exception, this, false);
            return null;
        }
    }
}

