/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal.slf4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.log.internal.slf4j.FileRotator;
import org.apache.sling.commons.log.internal.slf4j.ScheduledFileRotator;
import org.apache.sling.commons.log.internal.slf4j.SizeLimitedFileRotator;

class SlingLoggerWriter
extends Writer {
    private static final long FACTOR_KB = 1024L;
    private static final long FACTOR_MB = 0x100000L;
    private static final long FACTOR_GB = 0x40000000L;
    private static final Pattern SIZE_SPEC = Pattern.compile("([\\d]+)([kmg]b?)?", 2);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String configurationPID;
    private Writer delegatee;
    protected final Object lock = new Object();
    private File file;
    private String path;
    private FileRotator fileRotator;

    SlingLoggerWriter(String configurationPID) {
        this.configurationPID = configurationPID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configure(String logFileName, int fileNum, String fileSize) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (logFileName == null || !logFileName.equals(this.path)) {
                this.close();
                if (logFileName == null) {
                    this.path = null;
                    this.file = null;
                } else {
                    File file = new File(logFileName);
                    if (!file.isAbsolute()) {
                        file = file.getAbsoluteFile();
                    }
                    this.path = file.getAbsolutePath();
                    this.file = file;
                }
                this.setDelegatee(this.createWriter());
            } else {
                this.flush();
            }
            this.fileRotator = this.file != null ? SlingLoggerWriter.createFileRotator(fileNum, fileSize) : FileRotator.DEFAULT;
            this.checkRotate();
        }
    }

    String getConfigurationPID() {
        return this.configurationPID;
    }

    void setConfigurationPID(String configurationPID) {
        this.configurationPID = configurationPID;
    }

    String getPath() {
        return this.path;
    }

    FileRotator getFileRotator() {
        return this.fileRotator;
    }

    File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.flush();
                this.delegatee.close();
                this.delegatee = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.write(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.write(cbuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.write(cbuf, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.write(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegatee != null) {
                this.delegatee.write(str, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(LINE_SEPARATOR);
            this.flush();
        }
    }

    static FileRotator createFileRotator(int fileNum, String maxSizeSpec) {
        Matcher sizeMatcher;
        if (maxSizeSpec != null && maxSizeSpec.length() > 0 && (sizeMatcher = SIZE_SPEC.matcher(maxSizeSpec)).matches()) {
            long maxSize;
            long baseSize = Long.parseLong(sizeMatcher.group(1));
            String factorString = sizeMatcher.group(2);
            if (factorString == null) {
                maxSize = baseSize;
            } else {
                switch (factorString.charAt(0)) {
                    case 'K': 
                    case 'k': {
                        maxSize = baseSize * 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        maxSize = baseSize * 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        maxSize = baseSize * 0x40000000L;
                        break;
                    }
                    default: {
                        maxSize = baseSize;
                    }
                }
            }
            return new SizeLimitedFileRotator(fileNum, maxSize);
        }
        try {
            return new ScheduledFileRotator(maxSizeSpec);
        }
        catch (IllegalArgumentException iae) {
            return FileRotator.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDelegatee(Writer delegatee) {
        Object object = this.lock;
        synchronized (object) {
            this.delegatee = delegatee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Writer getDelegatee() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegatee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRotate() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileRotator.isRotationDue(this.file)) {
                this.getDelegatee().close();
                this.fileRotator.rotate(this.file);
                this.setDelegatee(this.createWriter());
            }
        }
    }

    private Writer createWriter() throws IOException {
        if (this.file == null) {
            return new OutputStreamWriter(System.out){

                public void close() {
                }
            };
        }
        this.file.getParentFile().mkdirs();
        return new OutputStreamWriter(new FileOutputStream(this.file, true));
    }
}

