/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UriListFlavor {
    public static DataFlavor uriListFlavor;
    public static DataFlavor[] FLAVORS;

    public static List<File> getFileList(Reader reader) {
        if (reader == null) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        BufferedReader br = new BufferedReader(reader);
        try {
            String uriStr;
            while ((uriStr = br.readLine()) != null) {
                if (uriStr.startsWith("#")) continue;
                try {
                    list.add(new File(new URI(uriStr)));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<File> textURIListToFileList(String uriList) {
        ArrayList<File> list = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(uriList, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                list.add(new File(new URI(s)));
            }
            catch (Exception e) {}
        }
        return list;
    }

    public static DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    public static boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!flavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FLAVORS = new DataFlavor[]{DataFlavor.javaFileListFlavor, uriListFlavor};
    }
}

