/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.weasis.core.ui.util.ToolBarFactory;
import org.weasis.core.ui.util.WrapLayout;
import org.weasis.core.ui.util.WtoolBar;

public class ToolBarContainer
extends JPanel {
    public static final WtoolBar EMPTY = ToolBarFactory.buildEmptyToolBar("empty");
    private Map<String, WtoolBar> toolBarsByName = new HashMap<String, WtoolBar>();

    public ToolBarContainer() {
        this.setOpaque(false);
        this.setLayout(new WrapLayout(3, 2, 2));
    }

    public void registerToolBar(WtoolBar toolbar) {
        if (toolbar == null) {
            return;
        }
        WtoolBar.TYPE type = toolbar.getType();
        String name = WtoolBar.TYPE.tool.equals((Object)type) ? toolbar.toString() : type.name();
        WtoolBar oldBar = this.toolBarsByName.get(name);
        this.toolBarsByName.put(name, toolbar);
        if (oldBar == null) {
            this.add(toolbar);
        } else {
            int index = this.getComponentIndex(oldBar);
            if (index >= 0) {
                super.remove(index);
            } else {
                index = this.getComponentCount();
            }
            this.add((Component)toolbar, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getComponentIndex(JComponent bar) {
        ToolBarContainer toolBarContainer = this;
        synchronized (toolBarContainer) {
            int size = this.getComponentCount();
            for (int i = 0; i < size; ++i) {
                if (bar != this.getComponent(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public void unregisterToolBar(WtoolBar toolbar) {
        if (toolbar == null) {
            return;
        }
        WtoolBar.TYPE type = toolbar.getType();
        String name = WtoolBar.TYPE.tool.equals((Object)type) ? toolbar.toString() : type.name();
        this.toolBarsByName.remove(name);
        this.remove(toolbar);
    }

    public void unregisterAll() {
        this.toolBarsByName.clear();
        this.removeAll();
    }

    public WtoolBar getToolBarByName(String name) {
        return this.toolBarsByName.get(name);
    }

    public List getRegisteredToolBars() {
        return new ArrayList<WtoolBar>(this.toolBarsByName.values());
    }
}

