/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.internal;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewerFactory;

public class Activator
implements BundleActivator,
ServiceListener {
    private BundleContext bundleContext = null;
    private static final String pluginViewerFilter = String.format("(%s=%s)", "objectClass", SeriesViewerFactory.class.getName());

    public void start(final BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        bundleContext.addServiceListener((ServiceListener)this, pluginViewerFilter);
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ServiceTracker m_tracker = new ServiceTracker(bundleContext, SeriesViewerFactory.class.getName(), null);
                m_tracker.open();
                Object[] services = m_tracker.getServices();
                for (int i = 0; services != null && i < services.length; ++i) {
                    if (UIManager.SERIES_VIEWER_FACTORIES.contains(services[i]) || !(services[i] instanceof SeriesViewerFactory)) continue;
                    UIManager.SERIES_VIEWER_FACTORIES.add((SeriesViewerFactory)services[i]);
                }
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public synchronized void serviceChanged(final ServiceEvent event) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ServiceReference m_ref = event.getServiceReference();
                SeriesViewerFactory viewerFactory = (SeriesViewerFactory)Activator.this.bundleContext.getService(m_ref);
                if (viewerFactory == null) {
                    return;
                }
                if (event.getType() == 1) {
                    if (!UIManager.SERIES_VIEWER_FACTORIES.contains(viewerFactory)) {
                        UIManager.SERIES_VIEWER_FACTORIES.add(viewerFactory);
                    }
                } else if (event.getType() == 4 && UIManager.SERIES_VIEWER_FACTORIES.contains(viewerFactory)) {
                    UIManager.SERIES_VIEWER_FACTORIES.remove(viewerFactory);
                    Activator.this.bundleContext.ungetService(m_ref);
                }
            }
        });
    }
}

