/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.weasis.core.api.image.OperationsManager;
import org.weasis.core.api.image.util.ImageLayer;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.ImageLayerChangeListener;
import org.weasis.core.ui.graphic.model.Layer;

public class RenderedImageLayer<E extends ImageElement>
implements Layer,
ImageLayer<E> {
    private final OperationsManager operations;
    private E sourceImage;
    private RandomIter readIterator;
    private ArrayList<ImageLayerChangeListener<E>> listenerList;
    private boolean buildIterator = false;
    private RenderedImage displayImage;
    private boolean visible = true;

    public RenderedImageLayer(OperationsManager manager, boolean buildIterator) {
        this(manager, null, buildIterator);
    }

    public RenderedImageLayer(OperationsManager manager, E image, boolean buildIterator) {
        if (manager == null) {
            throw new IllegalArgumentException("OperationsManager argument cannot be null");
        }
        this.operations = manager;
        this.sourceImage = image;
        this.buildIterator = buildIterator;
        this.listenerList = new ArrayList();
        if (image != null) {
            this.displayImage = this.operations.updateAllOperations();
            this.fireImageChanged();
        }
    }

    public RandomIter getReadIterator() {
        return this.readIterator;
    }

    public E getSourceImage() {
        return this.sourceImage;
    }

    public RenderedImage getDisplayImage() {
        return this.displayImage;
    }

    public void setImage(E image) {
        boolean init = image != null && !image.equals(this.sourceImage);
        this.sourceImage = image;
        if (init) {
            this.displayImage = this.operations.updateAllOperations();
            this.fireImageChanged();
        } else if (image == null) {
            this.displayImage = null;
            this.fireImageChanged();
        }
    }

    public void drawImage(Graphics2D g2d) {
        Shape clip;
        if (!this.visible || this.displayImage == null) {
            return;
        }
        Rectangle clipBounds = g2d.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(this.displayImage.getMinX(), this.displayImage.getMinY(), this.displayImage.getWidth(), this.displayImage.getHeight());
        }
        if ((clip = g2d.getClip()) instanceof Rectangle2D) {
            Rectangle2D rect = new Rectangle2D.Double(this.displayImage.getMinX(), this.displayImage.getMinY(), this.displayImage.getWidth() - 1, this.displayImage.getHeight() - 1);
            if ((rect = rect.createIntersection((Rectangle2D)clip)).isEmpty()) {
                return;
            }
            g2d.setClip(rect);
        }
        int txmin = this.XtoTileX(clipBounds.x);
        txmin = Math.max(txmin, this.displayImage.getMinTileX());
        txmin = Math.min(txmin, this.displayImage.getMinTileX() + this.displayImage.getNumXTiles() - 1);
        int txmax = this.XtoTileX(clipBounds.x + clipBounds.width - 1);
        txmax = Math.max(txmax, this.displayImage.getMinTileX());
        txmax = Math.min(txmax, this.displayImage.getMinTileX() + this.displayImage.getNumXTiles() - 1);
        int tymin = this.YtoTileY(clipBounds.y);
        tymin = Math.max(tymin, this.displayImage.getMinTileY());
        tymin = Math.min(tymin, this.displayImage.getMinTileY() + this.displayImage.getNumYTiles() - 1);
        int tymax = this.YtoTileY(clipBounds.y + clipBounds.height - 1);
        tymax = Math.max(tymax, this.displayImage.getMinTileY());
        tymax = Math.min(tymax, this.displayImage.getMinTileY() + this.displayImage.getNumYTiles() - 1);
        ColorModel cm = this.displayImage.getColorModel();
        SampleModel sm = this.displayImage.getSampleModel();
        if (sm != null && cm != null) {
            for (int tj = tymin; tj <= tymax; ++tj) {
                for (int ti = txmin; ti <= txmax; ++ti) {
                    int tx = this.TileXtoX(ti);
                    int ty = this.TileYtoY(tj);
                    Raster tile = null;
                    try {
                        tile = this.displayImage.getTile(ti, tj);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (tile == null) continue;
                    WritableRaster wr = Raster.createWritableRaster(sm, tile.getDataBuffer(), null);
                    BufferedImage bi = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
                    g2d.drawImage((Image)bi, tx, ty, null);
                }
            }
        }
        g2d.setClip(clip);
    }

    private int XtoTileX(int x) {
        if (this.displayImage == null) {
            return 0;
        }
        return PlanarImage.XToTileX((int)x, (int)this.displayImage.getTileGridXOffset(), (int)this.displayImage.getTileWidth());
    }

    private int YtoTileY(int y) {
        if (this.displayImage == null) {
            return 0;
        }
        return PlanarImage.YToTileY((int)y, (int)this.displayImage.getTileGridYOffset(), (int)this.displayImage.getTileHeight());
    }

    private int TileXtoX(int tx) {
        if (this.displayImage == null) {
            return 0;
        }
        return tx * this.displayImage.getTileWidth() + this.displayImage.getTileGridXOffset();
    }

    private int TileYtoY(int ty) {
        if (this.displayImage == null) {
            return 0;
        }
        return ty * this.displayImage.getTileHeight() + this.displayImage.getTileGridYOffset();
    }

    public void dispose() {
        this.sourceImage = null;
        this.listenerList.clear();
        this.listenerList = null;
    }

    public void addLayerChangeListener(ImageLayerChangeListener listener) {
        if (listener != null && !this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void fireImageChanged() {
        if (this.displayImage == null) {
            this.operations.clearCacheNodes();
        }
        this.readIterator = this.buildIterator && this.sourceImage != null && this.sourceImage.getImage() != null ? RandomIterFactory.create((RenderedImage)this.sourceImage.getImage(), null) : null;
        this.fireLayerChanged();
    }

    public void fireLayerChanged() {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).handleLayerChanged(this);
        }
    }

    public void removeLayerChangeListener(ImageLayerChangeListener listener) {
        if (listener != null) {
            this.listenerList.remove(listener);
        }
    }

    public void updateImageOperation(String operation) {
        this.displayImage = this.operations.updateOperation(operation);
        this.fireImageChanged();
    }

    public void updateAllImageOperations() {
        this.displayImage = this.operations.updateAllOperations();
        this.fireImageChanged();
    }

    public OperationsManager getOperationsManager() {
        return this.operations;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public void setLevel(int i) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform transform) {
    }
}

