/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class PolygonGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(PolygonGraphic.class.getResource("/icon/22x22/draw-polyline.png"));
    public static final Measurement AREA = new Measurement("Area", true, true, true);
    public static final Measurement PERIMETER = new Measurement("Perimeter", true, true, false);
    public static final Measurement WIDTH = new Measurement("Width", true, true, false);
    public static final Measurement HEIGHT = new Measurement("Height", true, true, false);
    public static final Measurement TOP_LEFT_POINT_X = new Measurement("Top Left X", true, true, false);
    public static final Measurement TOP_LEFT_POINT_Y = new Measurement("Top Left Y", true, true, false);
    public static final Measurement CENTROID_X = new Measurement("Centroid X", true, true, false);
    public static final Measurement CENTROID_Y = new Measurement("Centroid X", true, true, false);

    public PolygonGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(-1, paintColor, lineThickness, labelVisible);
    }

    public PolygonGraphic(List<Point2D> handlePointList, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        super(handlePointList, -1, paintColor, lineThickness, labelVisible, filled);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.polygon");
    }

    @Override
    protected boolean isResizingOrMoving() {
        return false;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        Path2D.Double newShape;
        block3: {
            Point2D firstHandlePoint;
            newShape = null;
            Point2D point2D = firstHandlePoint = this.handlePointList.size() > 1 ? this.getHandlePoint(0) : null;
            if (firstHandlePoint != null) {
                Path2D.Double polygonPath = new Path2D.Double(1, this.handlePointList.size());
                ((Path2D)polygonPath).moveTo(firstHandlePoint.getX(), firstHandlePoint.getY());
                for (int i = 1; i < this.handlePointList.size(); ++i) {
                    Point2D pt = this.getHandlePoint(i);
                    if (pt != null) {
                        ((Path2D)polygonPath).lineTo(pt.getX(), pt.getY());
                        continue;
                    }
                    break block3;
                }
                polygonPath.closePath();
                newShape = polygonPath;
            }
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            Double val2;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(12);
            double ratio = adapter.getCalibRatio();
            String unitStr = adapter.getUnit();
            Area pathArea = null;
            List<Line2D> lineSegmentList = null;
            if (TOP_LEFT_POINT_X.isComputed() && (!drawOnLabel || TOP_LEFT_POINT_X.isGraphicLabel())) {
                val2 = null;
                if (releaseEvent || TOP_LEFT_POINT_X.isQuickComputing()) {
                    pathArea = pathArea == null ? this.getPathArea() : pathArea;
                    val2 = pathArea != null ? Double.valueOf(adapter.getXCalibratedValue(pathArea.getBounds2D().getX())) : null;
                }
                measVal.add(new MeasureItem(TOP_LEFT_POINT_X, val2, unitStr));
            }
            if (TOP_LEFT_POINT_Y.isComputed() && (!drawOnLabel || TOP_LEFT_POINT_Y.isGraphicLabel())) {
                val2 = null;
                if (releaseEvent || TOP_LEFT_POINT_Y.isQuickComputing()) {
                    pathArea = pathArea == null ? this.getPathArea() : pathArea;
                    val2 = pathArea != null ? Double.valueOf(adapter.getXCalibratedValue(pathArea.getBounds2D().getY())) : null;
                }
                measVal.add(new MeasureItem(TOP_LEFT_POINT_Y, val2, unitStr));
            }
            if (WIDTH.isComputed() && (!drawOnLabel || WIDTH.isGraphicLabel())) {
                val2 = null;
                if (releaseEvent || WIDTH.isQuickComputing()) {
                    pathArea = pathArea == null ? this.getPathArea() : pathArea;
                    val2 = pathArea != null ? Double.valueOf(ratio * pathArea.getBounds2D().getWidth()) : null;
                }
                measVal.add(new MeasureItem(WIDTH, val2, unitStr));
            }
            if (HEIGHT.isComputed() && (!drawOnLabel || HEIGHT.isGraphicLabel())) {
                val2 = null;
                if (releaseEvent || HEIGHT.isQuickComputing()) {
                    pathArea = pathArea == null ? this.getPathArea() : pathArea;
                    val2 = pathArea != null ? Double.valueOf(ratio * pathArea.getBounds2D().getHeight()) : null;
                }
                measVal.add(new MeasureItem(HEIGHT, val2, unitStr));
            }
            Point2D centroid = null;
            if (CENTROID_X.isComputed() && (!drawOnLabel || CENTROID_X.isGraphicLabel())) {
                val = null;
                if (releaseEvent || CENTROID_X.isQuickComputing()) {
                    if (lineSegmentList == null) {
                        pathArea = pathArea == null ? this.getPathArea() : pathArea;
                        lineSegmentList = this.getClosedPathSegments(pathArea);
                    }
                    centroid = centroid == null ? this.getCentroid(lineSegmentList) : centroid;
                    val = centroid != null ? Double.valueOf(centroid.getX() * ratio) : null;
                }
                measVal.add(new MeasureItem(CENTROID_X, val, unitStr));
            }
            if (CENTROID_Y.isComputed() && (!drawOnLabel || CENTROID_Y.isGraphicLabel())) {
                val = null;
                if (releaseEvent || CENTROID_Y.isQuickComputing()) {
                    if (lineSegmentList == null) {
                        pathArea = pathArea == null ? this.getPathArea() : pathArea;
                        lineSegmentList = this.getClosedPathSegments(pathArea);
                    }
                    centroid = centroid == null ? this.getCentroid(lineSegmentList) : centroid;
                    val = centroid != null ? Double.valueOf(centroid.getY() * ratio) : null;
                }
                measVal.add(new MeasureItem(CENTROID_Y, val, unitStr));
            }
            if (AREA.isComputed() && (!drawOnLabel || AREA.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AREA.isQuickComputing()) {
                    if (lineSegmentList == null) {
                        pathArea = pathArea == null ? this.getPathArea() : pathArea;
                        lineSegmentList = this.getClosedPathSegments(pathArea);
                    }
                    val = lineSegmentList != null ? Double.valueOf(this.getAreaValue(lineSegmentList) * ratio * ratio) : null;
                }
                String unit = "pix".equals(unitStr) ? unitStr : unitStr + "2";
                measVal.add(new MeasureItem(AREA, val, unit));
            }
            if (PERIMETER.isComputed() && (!drawOnLabel || PERIMETER.isGraphicLabel())) {
                val = null;
                if (releaseEvent || PERIMETER.isQuickComputing()) {
                    if (lineSegmentList == null) {
                        pathArea = pathArea == null ? this.getPathArea() : pathArea;
                        lineSegmentList = this.getClosedPathSegments(pathArea);
                    }
                    val = lineSegmentList != null ? Double.valueOf(this.getPerimeter(lineSegmentList) * ratio) : null;
                }
                measVal.add(new MeasureItem(PERIMETER, val, unitStr));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }

    protected final Area getPathArea() {
        Point2D firstHandlePoint;
        Point2D point2D = firstHandlePoint = this.handlePointList.size() > 1 ? this.getHandlePoint(0) : null;
        if (firstHandlePoint != null) {
            Path2D.Double polygonPath = new Path2D.Double(1, this.handlePointList.size());
            ((Path2D)polygonPath).moveTo(firstHandlePoint.getX(), firstHandlePoint.getY());
            for (int i = 1; i < this.handlePointList.size(); ++i) {
                Point2D pt = this.getHandlePoint(i);
                if (pt == null) {
                    return null;
                }
                ((Path2D)polygonPath).lineTo(pt.getX(), pt.getY());
            }
            return new Area(polygonPath);
        }
        return null;
    }

    public final List<Line2D> getClosedPathSegments() {
        return this.getClosedPathSegments(this.getPathArea());
    }

    protected final List<Line2D> getClosedPathSegments(Area pathArea) {
        ArrayList<Line2D.Double> lineSegmentList = null;
        if (pathArea != null) {
            lineSegmentList = new ArrayList<Line2D.Double>(this.handlePointList.size());
            PathIterator pathIt = pathArea.getPathIterator(null);
            double[] coords = new double[6];
            double startX = Double.NaN;
            double startY = Double.NaN;
            double curX = Double.NaN;
            double curY = Double.NaN;
            HashSet<Point2D> ptSet = new HashSet<Point2D>(lineSegmentList.size() * 2);
            while (!pathIt.isDone()) {
                int segType = pathIt.currentSegment(coords);
                double lastX = coords[0];
                double lastY = coords[1];
                switch (segType) {
                    case 4: {
                        lastX = startX;
                        lastY = startY;
                    }
                    case 1: {
                        Point2D.Double ptP1 = new Point2D.Double(curX, curY);
                        Point2D.Double ptP2 = new Point2D.Double(lastX, lastY);
                        BigDecimal dist = new BigDecimal(ptP1.distance(ptP2)).setScale(10, RoundingMode.DOWN);
                        if (dist.compareTo(BigDecimal.ZERO) != 0) {
                            for (Point2D pt : new Point2D[]{ptP1, ptP2}) {
                                boolean newPt = true;
                                for (Point2D p : ptSet) {
                                    dist = new BigDecimal(p.distance(pt)).setScale(10, RoundingMode.DOWN);
                                    if (dist.compareTo(BigDecimal.ZERO) != 0) continue;
                                    pt.setLocation(p);
                                    newPt = false;
                                    break;
                                }
                                if (!newPt) continue;
                                ptSet.add(pt);
                            }
                            lineSegmentList.add(new Line2D.Double(ptP1, ptP2));
                        }
                        curX = lastX;
                        curY = lastY;
                        break;
                    }
                    case 0: {
                        startX = curX = lastX;
                        startY = curY = lastY;
                    }
                }
                pathIt.next();
            }
        }
        return lineSegmentList;
    }

    public Double getPerimeter() {
        return this.getPerimeter(this.getClosedPathSegments());
    }

    protected Double getPerimeter(List<Line2D> lineSegmentList) {
        if (lineSegmentList != null) {
            double perimeter = 0.0;
            for (Line2D line : lineSegmentList) {
                Point2D P1 = line.getP1();
                Point2D P2 = line.getP2();
                double dx = P1.getX() - P2.getX();
                double dy = P1.getY() - P2.getY();
                perimeter += Math.sqrt(Math.abs(dx * dx - dy * dy));
            }
            return perimeter;
        }
        return null;
    }

    public Point2D getCentroid() {
        return this.getCentroid(this.getClosedPathSegments());
    }

    protected Point2D getCentroid(List<Line2D> lineSegmentList) {
        if (lineSegmentList != null) {
            double area = 0.0;
            double cx = 0.0;
            double cy = 0.0;
            for (Line2D line : lineSegmentList) {
                Point2D P1 = line.getP1();
                Point2D P2 = line.getP2();
                double tmp = P1.getX() * P2.getY() - P2.getX() * P1.getY();
                area += tmp;
                cx += (P1.getX() + P2.getX()) * tmp;
                cy += (P1.getY() + P2.getY()) * tmp;
            }
            return new Point2D.Double(cx /= 6.0 * (area /= 2.0), cy /= 6.0 * area);
        }
        return null;
    }

    public Double getAreaValue() {
        return this.getAreaValue(this.getClosedPathSegments());
    }

    protected Double getAreaValue(List<Line2D> lineSegmentList) {
        if (lineSegmentList != null) {
            double area = 0.0;
            for (Line2D line : lineSegmentList) {
                Point2D P1 = line.getP1();
                Point2D P2 = line.getP2();
                area += P1.getX() * P2.getY() - P2.getX() * P1.getY();
            }
            return Math.abs(area) / 2.0;
        }
        return null;
    }
}

