/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class ParallelLineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(ParallelLineGraphic.class.getResource("/icon/22x22/draw-parallel.png"));
    public static final Measurement DISTANCE = new Measurement("Distance", true, true, true);
    public static final Measurement ORIENTATION = new Measurement("Orientation", true, true, false);
    public static final Measurement AZIMUTH = new Measurement("Azimuth", true, true, false);
    protected Point2D ptA;
    protected Point2D ptB;
    protected Point2D ptC;
    protected Point2D ptD;
    protected Point2D ptE;
    protected Point2D ptF;
    protected boolean lineABvalid;
    protected boolean lineCDvalid;

    public ParallelLineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(6, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Parallel";
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if ((handlePointIndex = super.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent)) >= 0 && handlePointIndex < this.getHandlePointListSize()) {
            this.updateTool();
            if (this.lineABvalid && this.lineCDvalid) {
                if (handlePointIndex == 0 || handlePointIndex == 1) {
                    double theta;
                    Point2D anchor;
                    if (handlePointIndex == 0) {
                        anchor = this.ptB;
                        theta = GeomUtil.getAngleRad((Point2D)this.ptC, (Point2D)this.ptD) - GeomUtil.getAngleRad((Point2D)this.ptA, (Point2D)this.ptB);
                    } else {
                        anchor = this.ptA;
                        theta = GeomUtil.getAngleRad((Point2D)this.ptD, (Point2D)this.ptC) - GeomUtil.getAngleRad((Point2D)this.ptB, (Point2D)this.ptA);
                    }
                    AffineTransform rotate = AffineTransform.getRotateInstance(theta, anchor.getX(), anchor.getY());
                    rotate.transform(this.ptC, this.ptC);
                    rotate.transform(this.ptD, this.ptD);
                    this.setHandlePoint(2, this.ptC);
                    this.setHandlePoint(3, this.ptD);
                } else if (handlePointIndex == 2 || handlePointIndex == 3) {
                    Point2D pt1 = handlePointIndex == 2 ? this.ptC : this.ptD;
                    Point2D pt2 = handlePointIndex == 2 ? this.ptD : this.ptC;
                    int hIndex = handlePointIndex == 2 ? 3 : 2;
                    Point2D ptI = GeomUtil.getPerpendicularPointToLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)pt1);
                    Point2D ptJ = GeomUtil.getPerpendicularPointToLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)pt2);
                    double transX = pt1.getX() - ptI.getX() - (pt2.getX() - ptJ.getX());
                    double transY = pt1.getY() - ptI.getY() - (pt2.getY() - ptJ.getY());
                    AffineTransform translate = AffineTransform.getTranslateInstance(transX, transY);
                    translate.transform(pt2, pt2);
                    this.setHandlePoint(hIndex, pt2);
                } else if (handlePointIndex == 4 || handlePointIndex == 5) {
                    int hIndex2;
                    Point2D pt0 = handlePointIndex == 4 ? this.ptE : this.ptF;
                    Point2D pt1 = handlePointIndex == 4 ? this.ptA : this.ptC;
                    Point2D pt2 = handlePointIndex == 4 ? this.ptB : this.ptD;
                    int hIndex1 = handlePointIndex == 4 ? 0 : 2;
                    int n = hIndex2 = handlePointIndex == 4 ? 1 : 3;
                    if (pt0 != null) {
                        Point2D ptI = GeomUtil.getPerpendicularPointToLine((Point2D)pt1, (Point2D)pt2, (Point2D)pt0);
                        AffineTransform translate = AffineTransform.getTranslateInstance(pt0.getX() - ptI.getX(), pt0.getY() - ptI.getY());
                        translate.transform(pt1, pt1);
                        translate.transform(pt2, pt2);
                        this.setHandlePoint(hIndex1, pt1);
                        this.setHandlePoint(hIndex2, pt2);
                    }
                }
                this.setHandlePoint(4, GeomUtil.getMidPoint((Point2D)this.ptA, (Point2D)this.ptB));
                this.setHandlePoint(5, GeomUtil.getMidPoint((Point2D)this.ptC, (Point2D)this.ptD));
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Path2D.Double newShape = null;
        Path2D.Double path = new Path2D.Double(1, 2);
        if (this.lineABvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptB), false);
        }
        if (this.lineCDvalid) {
            path.append(new Line2D.Double(this.ptC, this.ptD), false);
        }
        if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(3);
            if (DISTANCE.isComputed() && (!drawOnLabel || DISTANCE.isGraphicLabel())) {
                val = null;
                if (releaseEvent || DISTANCE.isQuickComputing()) {
                    val = this.ptC.distance(GeomUtil.getPerpendicularPointToLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)this.ptC)) * adapter.getCalibRatio();
                }
                measVal.add(new MeasureItem(DISTANCE, val, adapter.getUnit()));
            }
            if (ORIENTATION.isComputed() && (!drawOnLabel || ORIENTATION.isGraphicLabel())) {
                val = null;
                if (releaseEvent || ORIENTATION.isQuickComputing()) {
                    val = MathUtil.getOrientation((Point2D)this.ptA, (Point2D)this.ptB);
                }
                measVal.add(new MeasureItem(ORIENTATION, val, "deg"));
            }
            if (AZIMUTH.isComputed() && (!drawOnLabel || AZIMUTH.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AZIMUTH.isQuickComputing()) {
                    val = MathUtil.getAzimuth((Point2D)this.ptA, (Point2D)this.ptB);
                }
                measVal.add(new MeasureItem(AZIMUTH, val, "deg"));
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return this.lineABvalid && this.lineCDvalid;
    }

    protected void updateTool() {
        this.ptA = this.getHandlePoint(0);
        this.ptB = this.getHandlePoint(1);
        this.ptC = this.getHandlePoint(2);
        this.ptD = this.getHandlePoint(3);
        this.ptE = this.getHandlePoint(4);
        this.ptF = this.getHandlePoint(5);
        this.lineABvalid = this.ptA != null && this.ptB != null && !this.ptB.equals(this.ptA);
        this.lineCDvalid = this.ptC != null && this.ptD != null && !this.ptC.equals(this.ptD);
    }
}

