/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class OpenAngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(OpenAngleToolGraphic.class.getResource("/icon/22x22/draw-open-angle.png"));
    public static final Measurement ANGLE = new Measurement("Angle", true);
    public static final Measurement COMPLEMENTARY_ANGLE = new Measurement("Compl. Angle", true, true, false);
    protected Point2D ptA;
    protected Point2D ptB;
    protected Point2D ptC;
    protected Point2D ptD;
    protected Point2D ptP;
    protected Point2D[] lineABP;
    protected Point2D[] lineCDP;
    protected boolean linesParallel;
    protected boolean intersectABsegment;
    protected boolean intersectCDsegment;
    protected boolean lineABvalid;
    protected boolean lineCDvalid;
    protected double angleDeg;

    public OpenAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        this(4, lineThickness, paintColor, labelVisible);
    }

    protected OpenAngleToolGraphic(int handlePointTotalNumber, float lineThickness, Color paintColor, boolean labelVisible) {
        super(handlePointTotalNumber, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Open Angle";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Shape newShape = null;
        Path2D.Double path = new Path2D.Double(1, 6);
        if (this.lineABvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptB), false);
        }
        if (this.lineCDvalid) {
            path.append(new Line2D.Double(this.ptC, this.ptD), false);
        }
        if (this.lineABvalid && this.lineCDvalid && !this.linesParallel && Math.abs(this.angleDeg) > 0.1) {
            newShape = new AbstractDragGraphic.AdvancedShape(5);
            AbstractDragGraphic.AdvancedShape aShape = newShape;
            aShape.addShape(path);
            Point2D ptI1 = GeomUtil.getColinearPointWithRatio((Point2D)this.lineABP[1], (Point2D)this.lineABP[0], (double)0.25);
            Point2D ptJ1 = GeomUtil.getColinearPointWithRatio((Point2D)this.lineCDP[1], (Point2D)this.lineCDP[0], (double)0.25);
            Point2D ptI2 = GeomUtil.getColinearPointWithRatio((Point2D)this.lineABP[0], (Point2D)this.lineABP[1], (double)0.25);
            Point2D ptJ2 = GeomUtil.getColinearPointWithRatio((Point2D)this.lineCDP[0], (Point2D)this.lineCDP[1], (double)0.25);
            double maxRadius = Math.min(this.ptP.distance(ptI2), this.ptP.distance(ptJ2));
            double radius = Math.min(maxRadius, (this.ptP.distance(ptI1) + this.ptP.distance(ptJ1)) / 2.0);
            double startingAngle = GeomUtil.getAngleDeg((Point2D)this.ptP, (Point2D)this.lineABP[0]);
            Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(this.ptP.getX() - radius, this.ptP.getY() - radius, 2.0 * radius, 2.0 * radius);
            Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, this.angleDeg, 0);
            aShape.addShape(arcAngle, this.getStroke(1.0f), true);
            if (!this.intersectABsegment) {
                aShape.addShape(new Line2D.Double(this.ptP, this.lineABP[1]), this.getDashStroke(1.0f), true);
            }
            if (!this.intersectCDsegment) {
                aShape.addShape(new Line2D.Double(this.ptP, this.lineCDP[1]), this.getDashStroke(1.0f), true);
            }
            int iPtSize = 8;
            Path2D.Double intersectPtShape = new Path2D.Double(1, 5);
            Rectangle2D.Double intersecPtBounds = new Rectangle2D.Double(this.ptP.getX() - (double)iPtSize / 2.0, this.ptP.getY() - (double)iPtSize / 2.0, iPtSize, iPtSize);
            intersectPtShape.append(new Line2D.Double(this.ptP.getX() - (double)iPtSize, this.ptP.getY(), this.ptP.getX() - 2.0, this.ptP.getY()), false);
            intersectPtShape.append(new Line2D.Double(this.ptP.getX() + 2.0, this.ptP.getY(), this.ptP.getX() + (double)iPtSize, this.ptP.getY()), false);
            intersectPtShape.append(new Line2D.Double(this.ptP.getX(), this.ptP.getY() - (double)iPtSize, this.ptP.getX(), this.ptP.getY() - 2.0), false);
            intersectPtShape.append(new Line2D.Double(this.ptP.getX(), this.ptP.getY() + 2.0, this.ptP.getX(), this.ptP.getY() + (double)iPtSize), false);
            intersectPtShape.append(new Arc2D.Double(intersecPtBounds, 0.0, 360.0, 0), false);
            aShape.addInvShape((Shape)intersectPtShape, this.ptP, this.getStroke(0.5f), true);
        } else if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(2);
            double positiveAngle = Math.abs(this.angleDeg);
            if (ANGLE.isComputed() && (!drawOnLabel || ANGLE.isGraphicLabel())) {
                measVal.add(new MeasureItem(ANGLE, positiveAngle, "deg"));
            }
            if (COMPLEMENTARY_ANGLE.isComputed() && (!drawOnLabel || COMPLEMENTARY_ANGLE.isGraphicLabel())) {
                measVal.add(new MeasureItem(COMPLEMENTARY_ANGLE, 180.0 - positiveAngle, "deg"));
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return this.lineABvalid && this.lineCDvalid;
    }

    protected void updateTool() {
        this.ptA = this.getHandlePoint(0);
        this.ptB = this.getHandlePoint(1);
        this.ptC = this.getHandlePoint(2);
        this.ptD = this.getHandlePoint(3);
        this.lineCDP = null;
        this.lineABP = null;
        this.intersectCDsegment = false;
        this.intersectABsegment = false;
        this.linesParallel = false;
        this.angleDeg = 0.0;
        this.lineABvalid = this.ptA != null && this.ptB != null && !this.ptB.equals(this.ptA);
        boolean bl = this.lineCDvalid = this.ptC != null && this.ptD != null && !this.ptC.equals(this.ptD);
        if (this.lineABvalid && this.lineCDvalid) {
            double denominator = (this.ptB.getX() - this.ptA.getX()) * (this.ptD.getY() - this.ptC.getY()) - (this.ptB.getY() - this.ptA.getY()) * (this.ptD.getX() - this.ptC.getX());
            boolean bl2 = this.linesParallel = denominator == 0.0;
            if (!this.linesParallel) {
                Point2D switchPt;
                double numerator1 = (this.ptA.getY() - this.ptC.getY()) * (this.ptD.getX() - this.ptC.getX()) - (this.ptA.getX() - this.ptC.getX()) * (this.ptD.getY() - this.ptC.getY());
                double numerator2 = (this.ptA.getY() - this.ptC.getY()) * (this.ptB.getX() - this.ptA.getX()) - (this.ptA.getX() - this.ptC.getX()) * (this.ptB.getY() - this.ptA.getY());
                double r = numerator1 / denominator;
                double s = numerator2 / denominator;
                this.ptP = new Point2D.Double(this.ptA.getX() + r * (this.ptB.getX() - this.ptA.getX()), this.ptA.getY() + r * (this.ptB.getY() - this.ptA.getY()));
                this.lineABP = new Point2D[3];
                this.lineCDP = new Point2D[3];
                this.intersectABsegment = r >= 0.0 && r <= 1.0;
                this.intersectCDsegment = s >= 0.0 && s <= 1.0;
                Point2D point2D = this.lineABP[0] = r >= 0.0 ? this.ptA : this.ptB;
                Point2D point2D2 = r < 0.0 ? this.ptA : (this.lineABP[1] = r > 1.0 ? this.ptB : this.ptP);
                Point2D point2D3 = r < 0.0 ? this.ptP : (this.lineABP[2] = r > 1.0 ? this.ptP : this.ptB);
                if (this.intersectABsegment) {
                    if (this.ptP.distance(this.lineABP[0]) < this.ptP.distance(this.lineABP[2])) {
                        switchPt = (Point2D)this.lineABP[2].clone();
                        this.lineABP[2] = (Point2D)this.lineABP[0].clone();
                        this.lineABP[0] = switchPt;
                    }
                } else if (this.ptP.distance(this.lineABP[0]) < this.ptP.distance(this.lineABP[1])) {
                    switchPt = (Point2D)this.lineABP[1].clone();
                    this.lineABP[1] = (Point2D)this.lineABP[0].clone();
                    this.lineABP[0] = switchPt;
                }
                Point2D point2D4 = this.lineCDP[0] = s >= 0.0 ? this.ptC : this.ptD;
                Point2D point2D5 = s < 0.0 ? this.ptC : (this.lineCDP[1] = s > 1.0 ? this.ptD : this.ptP);
                Point2D point2D6 = s < 0.0 ? this.ptP : (this.lineCDP[2] = s > 1.0 ? this.ptP : this.ptD);
                if (this.intersectCDsegment) {
                    if (this.ptP.distance(this.lineCDP[0]) < this.ptP.distance(this.lineCDP[2])) {
                        switchPt = (Point2D)this.lineCDP[2].clone();
                        this.lineCDP[2] = (Point2D)this.lineCDP[0].clone();
                        this.lineCDP[0] = switchPt;
                    }
                } else if (this.ptP.distance(this.lineCDP[0]) < this.ptP.distance(this.lineCDP[1])) {
                    switchPt = (Point2D)this.lineCDP[1].clone();
                    this.lineCDP[1] = (Point2D)this.lineCDP[0].clone();
                    this.lineCDP[0] = switchPt;
                }
                this.angleDeg = GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)this.lineABP[0], (Point2D)this.ptP, (Point2D)this.lineCDP[0]));
            }
        }
    }
}

