/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class FourPointsAngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(FourPointsAngleToolGraphic.class.getResource("/icon/22x22/draw-4p-angle.png"));
    public static final Measurement ANGLE = new Measurement("Angle", true);
    public static final Measurement COMPLEMENTARY_ANGLE = new Measurement("Compl. Angle", true, true, false);
    Point2D ptA;
    Point2D ptB;
    Point2D ptC;
    Point2D ptD;
    Point2D ptI;
    Point2D ptJ;
    Point2D ptE;
    Point2D ptF;
    Point2D ptG;
    Point2D ptH;
    Point2D ptK;
    Point2D ptL;
    Point2D ptP;
    Point2D[] lineIJP;
    Point2D[] lineKLP;
    boolean lineParallel;
    boolean intersectIJsegment;
    boolean intersectKLsegment;
    boolean lineABvalid;
    boolean lineCDvalid;
    boolean lineEFvalid;
    boolean lineGHvalid;
    boolean lineIJvalid;
    boolean lineKLvalid;
    double angleDeg;

    public FourPointsAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(8, paintColor, lineThickness, labelVisible);
        this.init();
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Four Points Angle Tool";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Shape newShape = null;
        Path2D.Double path = new Path2D.Double(1, 6);
        if (this.lineABvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptB), false);
        }
        if (this.lineCDvalid) {
            path.append(new Line2D.Double(this.ptC, this.ptD), false);
        }
        if (this.lineIJvalid) {
            path.append(new Line2D.Double(this.ptI, this.ptJ), false);
        }
        if (this.lineEFvalid) {
            path.append(new Line2D.Double(this.ptE, this.ptF), false);
        }
        if (this.lineGHvalid) {
            path.append(new Line2D.Double(this.ptG, this.ptH), false);
        }
        if (this.lineKLvalid) {
            path.append(new Line2D.Double(this.ptK, this.ptL), false);
        }
        if (this.lineIJvalid && this.lineKLvalid && !this.lineParallel && Math.abs(this.angleDeg) > 0.1) {
            newShape = new AbstractDragGraphic.AdvancedShape(4);
            AbstractDragGraphic.AdvancedShape aShape = newShape;
            aShape.addShape(path);
            double startingAngle = GeomUtil.getAngleDeg((Point2D)this.ptP, (Point2D)this.lineIJP[0]);
            double radius = 32.0;
            Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(this.ptP.getX() - radius, this.ptP.getY() - radius, 2.0 * radius, 2.0 * radius);
            Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, this.angleDeg, 0);
            double rMax = Math.min(this.ptP.distance(this.lineIJP[0]), this.ptP.distance(this.lineKLP[0])) * 2.0 / 3.0;
            double scalingMin = radius / rMax;
            aShape.addInvShape((Shape)arcAngle, this.ptP, scalingMin, true);
            if (!this.intersectIJsegment) {
                aShape.addShape(new Line2D.Double(this.ptP, this.lineIJP[1]), this.getDashStroke(1.0f), true);
            }
            if (!this.intersectKLsegment) {
                aShape.addShape(new Line2D.Double(this.ptP, this.lineKLP[1]), this.getDashStroke(1.0f), true);
            }
        } else if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(2);
            if (ANGLE.isComputed() || COMPLEMENTARY_ANGLE.isComputed()) {
                double positiveAngle = Math.abs(this.angleDeg);
                if (ANGLE.isComputed() && (!drawOnLabel || ANGLE.isGraphicLabel())) {
                    measVal.add(new MeasureItem(ANGLE, positiveAngle, "deg"));
                }
                if (COMPLEMENTARY_ANGLE.isComputed() && (!drawOnLabel || COMPLEMENTARY_ANGLE.isGraphicLabel())) {
                    measVal.add(new MeasureItem(COMPLEMENTARY_ANGLE, 180.0 - positiveAngle, "deg"));
                }
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return this.lineABvalid && this.lineCDvalid && this.lineEFvalid && this.lineGHvalid && this.lineIJvalid && this.lineKLvalid;
    }

    protected void init() {
        this.ptA = this.getHandlePoint(0);
        this.ptB = this.getHandlePoint(1);
        this.ptC = this.getHandlePoint(2);
        this.ptD = this.getHandlePoint(3);
        this.ptI = this.ptA;
        this.ptJ = this.ptC;
        this.ptE = this.getHandlePoint(4);
        this.ptF = this.getHandlePoint(5);
        this.ptG = this.getHandlePoint(6);
        this.ptH = this.getHandlePoint(7);
        this.ptK = this.ptE;
        this.ptL = this.ptG;
        this.lineKLP = null;
        this.lineIJP = null;
        this.intersectKLsegment = false;
        this.intersectIJsegment = false;
        this.lineParallel = false;
        this.lineKLvalid = false;
        this.lineIJvalid = false;
        this.lineGHvalid = false;
        this.lineEFvalid = false;
        this.lineCDvalid = false;
        this.lineABvalid = false;
        this.angleDeg = 0.0;
    }

    protected void updateTool() {
        this.init();
        this.lineABvalid = this.ptA != null && this.ptB != null && !this.ptB.equals(this.ptA);
        if (this.lineABvalid) {
            this.ptI = GeomUtil.getMidPoint((Point2D)this.ptA, (Point2D)this.ptB);
        }
        if (this.lineCDvalid = this.ptC != null && this.ptD != null && !this.ptC.equals(this.ptD)) {
            this.ptJ = GeomUtil.getMidPoint((Point2D)this.ptC, (Point2D)this.ptD);
        }
        this.lineIJvalid = this.ptI != null && this.ptJ != null && !this.ptI.equals(this.ptJ);
        this.lineEFvalid = this.ptE != null && this.ptF != null && !this.ptE.equals(this.ptF);
        if (this.lineEFvalid) {
            this.ptK = GeomUtil.getMidPoint((Point2D)this.ptE, (Point2D)this.ptF);
        }
        if (this.lineGHvalid = this.ptG != null && this.ptH != null && !this.ptG.equals(this.ptH)) {
            this.ptL = GeomUtil.getMidPoint((Point2D)this.ptG, (Point2D)this.ptH);
        } else if (this.ptG == null && this.lineEFvalid) {
            this.ptL = GeomUtil.getPerpendicularPointFromLine((Point2D)this.ptE, (Point2D)this.ptF, (Point2D)this.ptK, (double)1.0);
        }
        boolean bl = this.lineKLvalid = this.ptK != null && this.ptL != null && !this.ptK.equals(this.ptL);
        if (this.lineIJvalid && this.lineKLvalid) {
            double denominator = (this.ptJ.getX() - this.ptI.getX()) * (this.ptL.getY() - this.ptK.getY()) - (this.ptJ.getY() - this.ptI.getY()) * (this.ptL.getX() - this.ptK.getX());
            boolean bl2 = this.lineParallel = denominator == 0.0;
            if (!this.lineParallel) {
                Point2D switchPt;
                double numerator1 = (this.ptI.getY() - this.ptK.getY()) * (this.ptL.getX() - this.ptK.getX()) - (this.ptI.getX() - this.ptK.getX()) * (this.ptL.getY() - this.ptK.getY());
                double numerator2 = (this.ptI.getY() - this.ptK.getY()) * (this.ptJ.getX() - this.ptI.getX()) - (this.ptI.getX() - this.ptK.getX()) * (this.ptJ.getY() - this.ptI.getY());
                double r = numerator1 / denominator;
                double s = numerator2 / denominator;
                this.ptP = new Point2D.Double(this.ptI.getX() + r * (this.ptJ.getX() - this.ptI.getX()), this.ptI.getY() + r * (this.ptJ.getY() - this.ptI.getY()));
                this.lineIJP = new Point2D[3];
                this.lineKLP = new Point2D[3];
                this.intersectIJsegment = r >= 0.0 && r <= 1.0;
                this.intersectKLsegment = s >= 0.0 && s <= 1.0;
                Point2D point2D = this.lineIJP[0] = r >= 0.0 ? this.ptI : this.ptJ;
                Point2D point2D2 = r < 0.0 ? this.ptI : (this.lineIJP[1] = r > 1.0 ? this.ptJ : this.ptP);
                Point2D point2D3 = r < 0.0 ? this.ptP : (this.lineIJP[2] = r > 1.0 ? this.ptP : this.ptJ);
                if (this.intersectIJsegment) {
                    if (this.ptP.distance(this.lineIJP[0]) < this.ptP.distance(this.lineIJP[2])) {
                        switchPt = (Point2D)this.lineIJP[2].clone();
                        this.lineIJP[2] = (Point2D)this.lineIJP[0].clone();
                        this.lineIJP[0] = switchPt;
                    }
                } else if (this.ptP.distance(this.lineIJP[0]) < this.ptP.distance(this.lineIJP[1])) {
                    switchPt = (Point2D)this.lineIJP[1].clone();
                    this.lineIJP[1] = (Point2D)this.lineIJP[0].clone();
                    this.lineIJP[0] = switchPt;
                }
                Point2D point2D4 = this.lineKLP[0] = s >= 0.0 ? this.ptK : this.ptL;
                Point2D point2D5 = s < 0.0 ? this.ptK : (this.lineKLP[1] = s > 1.0 ? this.ptL : this.ptP);
                Point2D point2D6 = s < 0.0 ? this.ptP : (this.lineKLP[2] = s > 1.0 ? this.ptP : this.ptL);
                if (this.intersectKLsegment) {
                    if (this.ptP.distance(this.lineKLP[0]) < this.ptP.distance(this.lineKLP[2])) {
                        switchPt = (Point2D)this.lineKLP[2].clone();
                        this.lineKLP[2] = (Point2D)this.lineKLP[0].clone();
                        this.lineKLP[0] = switchPt;
                    }
                } else if (this.ptP.distance(this.lineKLP[0]) < this.ptP.distance(this.lineKLP[1])) {
                    switchPt = (Point2D)this.lineKLP[1].clone();
                    this.lineKLP[1] = (Point2D)this.lineKLP[0].clone();
                    this.lineKLP[0] = switchPt;
                }
                this.angleDeg = GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)this.lineIJP[0], (Point2D)this.ptP, (Point2D)this.lineKLP[0]));
            }
        }
    }
}

