/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.graphic.OpenAngleToolGraphic;
import org.weasis.core.ui.util.MouseEventDouble;

public class CobbAngleToolGraphic
extends OpenAngleToolGraphic {
    public static final Icon ICON = new ImageIcon(CobbAngleToolGraphic.class.getResource("/icon/22x22/draw-cobb.png"));
    public static final Measurement ANGLE = new Measurement("Angle", true);
    public static final Measurement COMPLEMENTARY_ANGLE = new Measurement("Compl. Angle", true, true, false);
    protected Point2D ptO;

    public CobbAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(5, lineThickness, paintColor, labelVisible);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getUIName() {
        return "Cobb's Angle";
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if ((handlePointIndex = super.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent)) != -1 && this.handlePointList.size() >= 4) {
            this.updateTool();
            if (this.lineABvalid && this.lineCDvalid) {
                Line2D lineMN;
                if (this.linesParallel) {
                    lineMN = GeomUtil.getMedianLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)this.ptC, (Point2D)this.ptD);
                } else {
                    AffineTransform rotate = AffineTransform.getRotateInstance(-Math.toRadians(this.angleDeg) / 2.0, this.ptP.getX(), this.ptP.getY());
                    Point2D ptM = (Point2D)this.lineABP[0].clone();
                    rotate.transform(ptM, ptM);
                    lineMN = new Line2D.Double(ptM, this.ptP);
                }
                if (handlePointIndex == 4 && this.ptO != null) {
                    this.ptO = GeomUtil.getPerpendicularPointToLine((Line2D)lineMN, (Point2D)this.ptO);
                } else if (this.linesParallel) {
                    this.ptO = GeomUtil.getMidPoint((Point2D)lineMN.getP1(), (Point2D)lineMN.getP1());
                } else {
                    Point2D H1 = GeomUtil.getMidPoint((Point2D)this.lineABP[1], (Point2D)GeomUtil.getMidPoint((Point2D)this.lineABP[0], (Point2D)this.lineABP[1]));
                    Point2D H2 = GeomUtil.getMidPoint((Point2D)this.lineCDP[1], (Point2D)GeomUtil.getMidPoint((Point2D)this.lineCDP[0], (Point2D)this.lineCDP[1]));
                    Point2D O1 = GeomUtil.getPerpendicularPointToLine((Line2D)lineMN, (Point2D)H1);
                    Point2D O2 = GeomUtil.getPerpendicularPointToLine((Line2D)lineMN, (Point2D)H2);
                    this.ptO = GeomUtil.getMidPoint((Point2D)O1, (Point2D)O2);
                }
            } else {
                this.ptO = null;
            }
            if (this.handlePointList.size() < 5) {
                this.handlePointList.add(this.ptO);
            } else {
                this.handlePointList.set(4, this.ptO);
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Shape newShape = null;
        Path2D.Double path = new Path2D.Double(1, 6);
        if (this.lineABvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptB), false);
        }
        if (this.lineCDvalid) {
            path.append(new Line2D.Double(this.ptC, this.ptD), false);
        }
        if (this.lineABvalid && this.lineCDvalid && this.ptO != null) {
            newShape = new AbstractDragGraphic.AdvancedShape(10);
            AbstractDragGraphic.AdvancedShape aShape = newShape;
            aShape.addShape(path);
            double ax = this.ptA.getX();
            double ay = this.ptA.getY();
            double bx = this.ptB.getX();
            double by = this.ptB.getY();
            double cx = this.ptC.getX();
            double cy = this.ptC.getY();
            double dx = this.ptD.getX();
            double dy = this.ptD.getY();
            double distAB2 = Point2D.distanceSq(ax, ay, bx, by);
            double distCD2 = Point2D.distanceSq(cx, cy, dx, dy);
            double r1 = ((ay - this.ptO.getY()) * (ay - by) + (ax - this.ptO.getX()) * (ax - bx)) / distAB2;
            double r2 = ((cy - this.ptO.getY()) * (cy - dy) + (cx - this.ptO.getX()) * (cx - dx)) / distCD2;
            Point2D.Double ptI = new Point2D.Double(ax + r1 * (bx - ax), ay + r1 * (by - ay));
            Point2D.Double ptJ = new Point2D.Double(cx + r2 * (dx - cx), cy + r2 * (dy - cy));
            if (r1 < 0.0 || r1 > 1.0) {
                aShape.addShape(new Line2D.Double(r1 > 1.0 ? this.ptB : this.ptA, ptI), this.getDashStroke(1.0f), true);
            }
            if (r2 < 0.0 || r2 > 1.0) {
                aShape.addShape(new Line2D.Double(r1 > 1.0 ? this.ptD : this.ptC, ptJ), this.getDashStroke(1.0f), true);
            }
            aShape.addShape(new Line2D.Double(this.ptO, ptI));
            aShape.addShape(new Line2D.Double(this.ptO, ptJ));
            double cLength = 10.0;
            double cImax = 0.6666666666666666 * Math.min(this.ptO.distance(ptI), Math.max(ptI.distance(this.ptA), ptI.distance(this.ptB)));
            aShape.addInvShape(GeomUtil.getCornerShape((Point2D)GeomUtil.getMidPoint((Point2D)this.ptA, (Point2D)this.ptB), (Point2D)ptI, (Point2D)this.ptO, (double)cLength), ptI, cLength / cImax, this.getStroke(1.0f), true);
            double cJmax = 0.6666666666666666 * Math.min(this.ptO.distance(ptJ), Math.max(ptJ.distance(this.ptC), ptJ.distance(this.ptD)));
            aShape.addInvShape(GeomUtil.getCornerShape((Point2D)GeomUtil.getMidPoint((Point2D)this.ptC, (Point2D)this.ptD), (Point2D)ptJ, (Point2D)this.ptO, (double)cLength), ptJ, cLength / cJmax, this.getStroke(1.0f), true);
            if (!this.linesParallel) {
                double extSegLength = 32.0;
                Point2D ptK = GeomUtil.getColinearPointWithLength((Point2D)ptI, (Point2D)this.ptO, (double)(this.ptO.distance(ptI) + extSegLength));
                Point2D ptL = GeomUtil.getColinearPointWithLength((Point2D)ptJ, (Point2D)this.ptO, (double)(this.ptO.distance(ptJ) + extSegLength));
                double distOKmax = 0.5 * this.ptO.distance(ptI);
                aShape.addInvShape((Shape)new Line2D.Double(this.ptO, ptK), this.ptO, extSegLength / distOKmax, false);
                double distOLmax = 0.5 * this.ptO.distance(ptJ);
                aShape.addInvShape((Shape)new Line2D.Double(this.ptO, ptL), this.ptO, extSegLength / distOLmax, false);
                double startingAngle = ptK.getY() > ptL.getY() ? GeomUtil.getAngleDeg((Point2D)this.ptO, (Point2D)ptJ) : GeomUtil.getAngleDeg((Point2D)this.ptO, (Point2D)ptI);
                double angularExtent = ptK.getY() > ptL.getY() ? GeomUtil.getAngleDeg((Point2D)ptJ, (Point2D)this.ptO, (Point2D)ptK) : GeomUtil.getAngleDeg((Point2D)ptI, (Point2D)this.ptO, (Point2D)ptL);
                angularExtent = GeomUtil.getSmallestRotationAngleDeg((double)angularExtent);
                double radius = 0.6666666666666666 * extSegLength;
                Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(this.ptO.getX() - radius, this.ptO.getY() - radius, 2.0 * radius, 2.0 * radius);
                Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, angularExtent, 0);
                double rMax = (ptK.getY() > ptL.getY() ? distOKmax : distOLmax) * 2.0 / 3.0;
                aShape.addInvShape((Shape)arcAngle, this.ptO, radius / rMax, false);
            }
        } else if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    protected void updateTool() {
        super.updateTool();
        this.ptO = this.getHandlePoint(4);
    }
}

