/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.util.ArrayList;

public class ChainPoint
implements Comparable<ChainPoint> {
    public final int x;
    public final int y;
    private float segLength;

    public float getSegLength() {
        return this.segLength;
    }

    public void setSegLength(float segLength) {
        this.segLength = segLength;
    }

    public ChainPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int compareTo(ChainPoint anotherPoint) {
        return this.y < anotherPoint.y ? -1 : (this.y == anotherPoint.y ? (this.x < anotherPoint.x ? -1 : (this.x == anotherPoint.x ? 0 : 1)) : 1);
    }

    public boolean equals(ChainPoint point) {
        return this.y == point.y && this.x == point.x;
    }

    public boolean equals(int x, int y) {
        return this.y == y && this.x == x;
    }

    public static double[] regression(ArrayList<ChainPoint> list) {
        double mean_x = 0.0;
        double mean_y = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ChainPoint p = list.get(i);
            mean_x += (double)p.x;
            mean_y += (double)p.y;
        }
        mean_x /= (double)list.size();
        mean_y /= (double)list.size();
        double mean_x2 = 0.0;
        double mean_y2 = 0.0;
        double mean_xy = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ChainPoint p = list.get(i);
            double xi = p.x;
            double yi = p.y;
            mean_x2 += (xi -= mean_x) * xi;
            mean_y2 += yi * yi;
            mean_xy += xi * yi;
        }
        mean_y2 /= (double)list.size();
        double[] val = new double[3];
        val[0] = (mean_xy /= (double)list.size()) / (mean_x2 /= (double)list.size());
        if (Double.isNaN(val[0])) {
            val[0] = 0.0;
        }
        val[1] = mean_y - mean_x * val[0];
        val[2] = mean_xy / Math.sqrt(mean_x2 * (mean_y2 - mean_y * mean_y));
        if (Double.isInfinite(val[2]) || Double.isNaN(val[2])) {
            val[2] = 1.0;
        }
        return val;
    }
}

