/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.weasis.core.api.gui.Image2DViewer;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.model.ViewModel;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.MouseActionAdapter;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.FilterOperation;
import org.weasis.core.api.image.FlipOperation;
import org.weasis.core.api.image.OperationsManager;
import org.weasis.core.api.image.PseudoColorOperation;
import org.weasis.core.api.image.RotationOperation;
import org.weasis.core.api.image.WindowLevelOperation;
import org.weasis.core.api.image.ZoomOperation;
import org.weasis.core.api.image.op.ByteLut;
import org.weasis.core.api.image.util.KernelData;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FontTools;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.image.AnnotationsLayer;
import org.weasis.core.ui.editor.image.ImageTransferHandler;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MeasureToolBar;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.core.ui.editor.image.ViewTransferHandler;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.editor.image.ViewerToolBar;
import org.weasis.core.ui.editor.image.ZoomWin;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.DragLayer;
import org.weasis.core.ui.graphic.DragPoint;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.ImageLayerChangeListener;
import org.weasis.core.ui.graphic.RenderedImageLayer;
import org.weasis.core.ui.graphic.SelectGraphic;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;
import org.weasis.core.ui.graphic.model.DefaultViewModel;
import org.weasis.core.ui.graphic.model.GraphicList;
import org.weasis.core.ui.graphic.model.GraphicsPane;
import org.weasis.core.ui.graphic.model.Tools;
import org.weasis.core.ui.util.MouseEventDouble;

public abstract class DefaultView2d<E extends ImageElement>
extends GraphicsPane
implements PropertyChangeListener,
FocusListener,
Image2DViewer,
ImageLayerChangeListener,
KeyListener {
    protected final FocusHandler focusHandler = new FocusHandler();
    protected final MouseHandler mouseClickHandler = new MouseHandler();
    static final Shape[] pointer = new Shape[5];
    protected Point highlightedPosition = null;
    private int pointerType = 0;
    private final Color pointerColor1 = Color.black;
    private final Color pointerColor2 = Color.white;
    private final Border normalBorder = new EtchedBorder(1, Color.gray, Color.white);
    private final Border focusBorder = new EtchedBorder(1, focusColor, focusColor);
    protected int frameIndex;
    protected DragSequence ds;
    protected final RenderedImageLayer<E> imageLayer;
    protected ZoomWin<E> lens;
    protected MediaSeries<E> series = null;
    protected static final Color focusColor;
    protected AnnotationsLayer infoLayer;
    protected int tileOffset;
    protected final ImageViewerEventManager<E> eventManager;
    private final DragPoint startedDragPoint = new DragPoint(DragPoint.STATE.Started);

    public DefaultView2d(ImageViewerEventManager<E> eventManager) {
        this(eventManager, null, null);
    }

    public DefaultView2d(ImageViewerEventManager<E> eventManager, AbstractLayerModel layerModel, ViewModel viewModel) {
        super(layerModel, viewModel);
        if (eventManager == null) {
            throw new IllegalArgumentException("EventManager cannot be null");
        }
        this.eventManager = eventManager;
        this.tileOffset = 0;
        this.initActionWState();
        this.imageLayer = new RenderedImageLayer(new OperationsManager((ImageOperation)this), true);
        this.setBorder(this.normalBorder);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(1024, 1024));
    }

    public void registerDefaultListeners() {
        this.addFocusListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.imageLayer.addLayerChangeListener(this);
    }

    public void copyActionWState(HashMap<String, Object> actionsInView) {
        actionsInView.putAll(this.actionsInView);
    }

    protected void initActionWState() {
        this.actionsInView.put(ActionW.ZOOM.cmd(), 0.0);
        this.actionsInView.put(ActionW.LENS.cmd(), false);
        this.actionsInView.put(ActionW.ROTATION.cmd(), 0);
        this.actionsInView.put(ActionW.FLIP.cmd(), false);
        this.actionsInView.put(ActionW.INVERSELUT.cmd(), false);
        this.actionsInView.put(ActionW.LUT.cmd(), ByteLut.defaultLUT);
        this.actionsInView.put(ActionW.INVERSESTACK.cmd(), false);
        this.actionsInView.put(ActionW.FILTER.cmd(), KernelData.NONE);
        this.actionsInView.put(ActionW.DRAW.cmd(), true);
        this.actionsInView.put("zoomInterpolation", this.eventManager.getZoomSetting().getInterpolation());
    }

    public ImageViewerEventManager<E> getEventManager() {
        return this.eventManager;
    }

    public String getPixelInfo(Point p, RenderedImageLayer<E> imageLayer) {
        E imageElement = imageLayer.getSourceImage();
        StringBuffer message = new StringBuffer();
        if (imageElement != null && imageLayer.getReadIterator() != null) {
            PlanarImage image = imageElement.getImage();
            Point realPoint = new Point((int)Math.ceil((double)p.x / imageElement.getRescaleX() - 0.5), (int)Math.ceil((double)p.y / imageElement.getRescaleY() - 0.5));
            if (image != null && realPoint.x >= 0 && realPoint.y >= 0 && realPoint.x < image.getWidth() && realPoint.y < image.getHeight()) {
                try {
                    int[] c = new int[]{0, 0, 0};
                    imageLayer.getReadIterator().getPixel(realPoint.x, realPoint.y, c);
                    if (image.getSampleModel().getNumBands() == 1) {
                        message.append(c[0]);
                    } else {
                        message.append("R=" + c[0] + " G=" + c[1] + " B=" + c[2]);
                    }
                    message.append(" - (" + p.x + "," + p.y + ")");
                }
                catch (ArrayIndexOutOfBoundsException ex) {}
            } else {
                message.append(Messages.getString("DefaultView2d.out"));
            }
        }
        return message.toString();
    }

    protected void closeLens() {
        if (this.lens != null) {
            this.lens.showLens(false);
            this.remove(this.lens);
            this.actionsInView.put(ActionW.LENS.cmd(), false);
        }
    }

    public void setSeries(MediaSeries<E> series) {
        this.setSeries(series, -1);
    }

    public void setSeries(MediaSeries<E> series, int defaultIndex) {
        MediaSeries<E> oldsequence = this.series;
        this.series = series;
        if (oldsequence != null && oldsequence != series) {
            this.closingSeries(oldsequence);
        }
        if (series == null) {
            this.imageLayer.setImage(null);
            this.getLayerModel().deleteAllGraphics();
            this.closeLens();
        } else {
            defaultIndex = defaultIndex < 0 || defaultIndex >= series.size() ? 0 : defaultIndex;
            this.frameIndex = defaultIndex + this.tileOffset;
            this.setImage((ImageElement)series.getMedia(this.frameIndex), true);
            Double val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
            this.zoom(val == null ? 1.0 : val);
            this.center();
        }
        if (series != null && oldsequence != series) {
            series.setOpen(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closingSeries(MediaSeries<E> series) {
        if (series == null) {
            return;
        }
        boolean open = false;
        List<ViewerPlugin> list = UIManager.VIEWER_PLUGINS;
        synchronized (list) {
            List<ViewerPlugin> plugins = UIManager.VIEWER_PLUGINS;
            block3: for (ViewerPlugin plugin : plugins) {
                List openSeries = plugin.getOpenSeries();
                if (openSeries == null) continue;
                for (MediaSeries s : openSeries) {
                    if (series != s) continue;
                    open = true;
                    break block3;
                }
            }
        }
        series.setOpen(open);
        series.setSelected(false, 0);
    }

    private int getImageSize(E img, TagW tag1, TagW tag2) {
        Integer size = (Integer)img.getTagValue(tag1);
        if (size == null) {
            size = (Integer)img.getTagValue(tag2);
        }
        return size == null ? 512 : size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImage(E img, boolean bestFit) {
        E oldImage = this.imageLayer.getSourceImage();
        if (img != null && !img.equals(oldImage)) {
            PlanarImage source = img.getImage();
            int width = source == null || img.getRescaleX() != img.getRescaleY() ? img.getRescaleWidth(this.getImageSize(img, TagW.ImageWidth, TagW.Columns)) : source.getWidth();
            int height = source == null || img.getRescaleX() != img.getRescaleY() ? img.getRescaleHeight(this.getImageSize(img, TagW.ImageHeight, TagW.Rows)) : source.getHeight();
            Rectangle modelArea = new Rectangle(0, 0, width, height);
            DragLayer layer = this.getLayerModel().getMeasureLayer();
            DefaultView2d defaultView2d = this;
            synchronized (defaultView2d) {
                GraphicList list = (GraphicList)img.getTagValue(TagW.MeasurementGraphics);
                if (list != null) {
                    layer.setGraphics(list);
                } else {
                    GraphicList graphics = new GraphicList();
                    img.setTag(TagW.MeasurementGraphics, (Object)graphics);
                    layer.setGraphics(graphics);
                }
            }
            this.setWindowLevel(img);
            Rectangle2D area = this.getViewModel().getModelArea();
            if (!modelArea.equals(area)) {
                ((DefaultViewModel)this.getViewModel()).adjustMinViewScaleFromImage(modelArea.width, modelArea.height);
                this.getViewModel().setModelArea((Rectangle2D)modelArea);
                this.center();
            }
            if (bestFit) {
                this.actionsInView.put(ActionW.ZOOM.cmd(), -this.getBestFitViewScale());
            }
            this.imageLayer.setImage(img);
        }
    }

    @Override
    public double getBestFitViewScale() {
        double viewScale = super.getBestFitViewScale();
        ActionState zoom = this.eventManager.getAction(ActionW.ZOOM);
        if (zoom instanceof SliderChangeListener) {
            SliderChangeListener z = (SliderChangeListener)zoom;
            int sliderValue = this.eventManager.viewScaleToSliderValue(viewScale);
            if (this.eventManager.getSelectedViewPane() == this) {
                z.setValueWithoutTriggerAction(sliderValue);
                viewScale = this.eventManager.sliderValueToViewScale(z.getValue());
            } else {
                DefaultBoundedRangeModel model = z.getModel();
                if (sliderValue < model.getMinimum()) {
                    sliderValue = model.getMinimum();
                } else if (sliderValue > model.getMaximum()) {
                    sliderValue = model.getMaximum();
                }
                viewScale = this.eventManager.sliderValueToViewScale(sliderValue);
            }
        }
        return viewScale;
    }

    public RenderedImageLayer<E> getImageLayer() {
        return this.imageLayer;
    }

    public AnnotationsLayer getInfoLayer() {
        return this.infoLayer;
    }

    public int getTileOffset() {
        return this.tileOffset;
    }

    public void setTileOffset(int tileOffset) {
        this.tileOffset = tileOffset;
    }

    public MediaSeries<E> getSeries() {
        return this.series;
    }

    public int getCurrentImageIndex() {
        if (this.series instanceof Series) {
            return ((Series)this.series).getImageIndex(this.imageLayer.getSourceImage());
        }
        return 0;
    }

    public E getImage() {
        return this.imageLayer.getSourceImage();
    }

    public RenderedImage getSourceImage() {
        E image = this.getImage();
        if (image == null) {
            return null;
        }
        return image.getImage();
    }

    public final void center() {
        Rectangle2D bound = this.getViewModel().getModelArea();
        this.setCenter(bound.getWidth() / 2.0, bound.getHeight() / 2.0);
    }

    public final void setCenter(double x, double y) {
        double scale = this.getViewModel().getViewScale();
        this.setOrigin(x - (double)(this.getWidth() - 1) / (2.0 * scale), y - (double)(this.getHeight() - 1) / (2.0 * scale));
    }

    public final void setOrigin(double x, double y) {
        this.getViewModel().setModelOffset(x, y);
    }

    public final void moveOrigin(double x, double y) {
        this.setOrigin(this.getViewModel().getModelOffsetX() + x, this.getViewModel().getModelOffsetY() + y);
    }

    public final void moveOrigin(DragPoint point) {
        if (point != null) {
            if (DragPoint.STATE.Started.equals((Object)point.getState())) {
                this.startedDragPoint.setLocation(this.getViewModel().getModelOffsetX(), this.getViewModel().getModelOffsetY());
            } else {
                this.setOrigin(this.startedDragPoint.getX() + point.getX(), this.startedDragPoint.getY() + point.getY());
            }
        }
    }

    @Override
    public Font getFont() {
        Rectangle bound = this.getBounds();
        if (bound.height < 300 || bound.width < 300) {
            return FontTools.getFont8();
        }
        if (bound.height < 500 || bound.width < 500) {
            return FontTools.getFont10();
        }
        return FontTools.getFont12();
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public void setActionsInView(String action, Object value) {
        if (action != null) {
            this.actionsInView.put(action, value);
            this.repaint();
        }
    }

    public void setSelected(boolean selected) {
        this.setBorder(selected ? this.focusBorder : this.normalBorder);
        this.getLayerModel().setSelectedGraphics(null);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            this.draw((Graphics2D)g);
        }
    }

    protected void draw(Graphics2D g2d) {
        Stroke oldStroke = g2d.getStroke();
        Paint oldColor = g2d.getPaint();
        double viewScale = this.getViewModel().getViewScale();
        double offsetX = this.getViewModel().getModelOffsetX() * viewScale;
        double offsetY = this.getViewModel().getModelOffsetY() * viewScale;
        g2d.translate(-offsetX, -offsetY);
        Font defaultFont = this.eventManager.getViewSetting().getFont();
        g2d.setFont(defaultFont);
        this.imageLayer.drawImage(g2d);
        this.drawLayers(g2d, this.affineTransform, this.inverseTransform);
        g2d.translate(offsetX, offsetY);
        this.drawPointer(g2d);
        if (this.infoLayer != null) {
            g2d.setFont(this.getFont());
            this.infoLayer.paint(g2d);
        }
        g2d.setFont(defaultFont);
        g2d.setPaint(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void drawLayers(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform) {
        if (((Boolean)this.actionsInView.get(ActionW.DRAW.cmd())).booleanValue()) {
            this.getLayerModel().draw(g2d, transform, inverseTransform);
        }
    }

    @Override
    public void zoom(double viewScale) {
        if (viewScale == 0.0) {
            viewScale = -this.getBestFitViewScale();
        }
        this.actionsInView.put(ActionW.ZOOM.cmd(), viewScale);
        super.zoom(Math.abs(viewScale));
        this.imageLayer.updateImageOperation(ZoomOperation.name);
        this.updateAffineTransform();
    }

    protected void updateAffineTransform() {
        double viewScale = this.getViewModel().getViewScale();
        Boolean flip = (Boolean)this.actionsInView.get(ActionW.FLIP.cmd());
        if (flip != null && flip.booleanValue()) {
            this.affineTransform.setToScale(-viewScale, viewScale);
            this.affineTransform.translate(-this.getViewModel().getModelArea().getWidth(), 0.0);
        } else {
            this.affineTransform.setToScale(viewScale, viewScale);
        }
        Integer rotationAngle = (Integer)this.actionsInView.get(ActionW.ROTATION.cmd());
        if (rotationAngle != null && rotationAngle > 0) {
            if (flip != null && flip.booleanValue()) {
                rotationAngle = 360 - rotationAngle;
            }
            Rectangle2D imageCanvas = this.getViewModel().getModelArea();
            this.affineTransform.rotate((double)rotationAngle.intValue() * Math.PI / 180.0, imageCanvas.getWidth() / 2.0, imageCanvas.getHeight() / 2.0);
        }
        try {
            this.inverseTransform.setTransform(this.affineTransform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    public void setDrawingsVisibility(boolean visible) {
        if ((Boolean)this.actionsInView.get(ActionW.DRAW.cmd()) != visible) {
            this.actionsInView.put(ActionW.DRAW.cmd(), visible);
            this.repaint();
        }
    }

    protected void setWindowLevel(E img) {
        float min = img.getMinValue();
        float max = img.getMaxValue();
        this.actionsInView.put(ActionW.WINDOW.cmd(), Float.valueOf(max - min));
        this.actionsInView.put(ActionW.LEVEL.cmd(), Float.valueOf((max - min) / 2.0f + min));
    }

    public Object getLensActionValue(String action) {
        if (this.lens == null) {
            return null;
        }
        return this.lens.getActionValue(action);
    }

    public void changeZoomInterpolation(int interpolation) {
        boolean update;
        Integer val = (Integer)this.actionsInView.get("zoomInterpolation");
        boolean bl = update = val == null || val != interpolation;
        if (update) {
            this.actionsInView.put("zoomInterpolation", interpolation);
            if (this.lens != null) {
                this.lens.setActionInView("zoomInterpolation", interpolation);
                this.lens.updateZoom();
            }
            this.imageLayer.updateImageOperation(ZoomOperation.name);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.series == null) {
            return;
        }
        String command = evt.getPropertyName();
        if (command.equals(ActionW.SCROLL_SERIES.cmd())) {
            Object value = evt.getNewValue();
            AbstractLayer layer = this.getLayerModel().getLayer(Tools.CROSSLINES.getId());
            if (layer != null) {
                layer.deleteAllGraphic();
            }
            if (value instanceof Double) {
                double location = (Double)value;
                Boolean cutlines = (Boolean)this.actionsInView.get(ActionW.SYNCH_CROSSLINE.cmd());
                if (cutlines != null && cutlines.booleanValue()) {
                    this.computeCrosslines(location);
                } else {
                    Double offset = (Double)this.actionsInView.get(ActionW.STACK_OFFSET.cmd());
                    if (offset != null) {
                        location += offset.doubleValue();
                    }
                    this.frameIndex = this.series.getNearestIndex(location) + this.tileOffset;
                }
            } else {
                this.frameIndex = (Integer)evt.getNewValue() + this.tileOffset;
            }
            Double val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
            boolean rescaleView = val == null || val <= 0.0;
            this.setImage((ImageElement)this.series.getMedia(this.frameIndex), rescaleView);
            if (rescaleView) {
                val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
                this.zoom(val == null ? 1.0 : val);
                this.center();
            }
        } else if (command.equals(ActionW.WINDOW.cmd())) {
            this.actionsInView.put(ActionW.WINDOW.cmd(), Float.valueOf(((Integer)evt.getNewValue()).floatValue()));
            this.imageLayer.updateImageOperation(WindowLevelOperation.name);
        } else if (command.equals(ActionW.LEVEL.cmd())) {
            this.actionsInView.put(ActionW.LEVEL.cmd(), Float.valueOf(((Integer)evt.getNewValue()).floatValue()));
            this.imageLayer.updateImageOperation(WindowLevelOperation.name);
        } else if (command.equals(ActionW.ROTATION.cmd())) {
            this.actionsInView.put(ActionW.ROTATION.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(RotationOperation.name);
            this.updateAffineTransform();
        } else if (command.equals(ActionW.ZOOM.cmd())) {
            double zoomFactor = (Double)evt.getNewValue();
            this.zoom(zoomFactor);
        } else if (command.equals(ActionW.LENSZOOM.cmd())) {
            if (this.lens != null) {
                this.lens.setActionInView(ActionW.ZOOM.cmd(), evt.getNewValue());
            }
        } else if (command.equals(ActionW.LENS.cmd())) {
            Boolean showLens = (Boolean)evt.getNewValue();
            this.actionsInView.put(ActionW.LENS.cmd(), showLens);
            if (showLens.booleanValue()) {
                if (this.lens == null) {
                    this.lens = new ZoomWin(this);
                }
                int maxWidth = this.getWidth() / 3;
                int maxHeight = this.getHeight() / 3;
                this.lens.setSize(this.lens.getWidth() > maxWidth ? maxWidth : this.lens.getWidth(), this.lens.getHeight() > maxHeight ? maxHeight : this.lens.getHeight());
                this.add(this.lens);
                this.lens.showLens(true);
            } else {
                this.closeLens();
            }
        } else if (command.equals(ActionW.PAN.cmd())) {
            Object point = evt.getNewValue();
            if (point instanceof DragPoint) {
                this.moveOrigin((DragPoint)evt.getNewValue());
            } else if (point instanceof Point) {
                Point p = (Point)point;
                this.moveOrigin(p.getX(), p.getY());
            }
        } else if (command.equals(ActionW.FLIP.cmd())) {
            this.actionsInView.put(ActionW.FLIP.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(FlipOperation.name);
            this.updateAffineTransform();
        } else if (command.equals(ActionW.LUT.cmd())) {
            this.actionsInView.put(ActionW.LUT.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(PseudoColorOperation.name);
        } else if (command.equals(ActionW.INVERSELUT.cmd())) {
            this.actionsInView.put(ActionW.INVERSELUT.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(PseudoColorOperation.name);
        } else if (command.equals(ActionW.FILTER.cmd())) {
            this.actionsInView.put(ActionW.FILTER.cmd(), evt.getNewValue());
            this.imageLayer.updateImageOperation(FilterOperation.name);
        } else if (command.equals(ActionW.PROGRESSION.cmd())) {
            this.actionsInView.put(ActionW.PROGRESSION.cmd(), evt.getNewValue());
            this.imageLayer.updateAllImageOperations();
        }
        if (this.lens != null) {
            this.lens.setCommandFromParentView(command, evt.getNewValue());
            this.lens.updateZoom();
        }
    }

    protected void computeCrosslines(double location) {
    }

    @Override
    public void dispose() {
        this.disableMouseAndKeyListener();
        this.removeFocusListener(this);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.imageLayer.removeLayerChangeListener(this);
        if (this.series != null) {
            this.closingSeries(this.series);
            this.series = null;
        }
        super.dispose();
    }

    public synchronized void disableMouseAndKeyListener() {
        int i;
        MouseListener[] listener = this.getMouseListeners();
        MouseMotionListener[] motionListeners = this.getMouseMotionListeners();
        KeyListener[] keyListeners = this.getKeyListeners();
        MouseWheelListener[] wheelListeners = this.getMouseWheelListeners();
        for (i = 0; i < listener.length; ++i) {
            this.removeMouseListener(listener[i]);
        }
        for (i = 0; i < motionListeners.length; ++i) {
            this.removeMouseMotionListener(motionListeners[i]);
        }
        for (i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        for (i = 0; i < wheelListeners.length; ++i) {
            this.removeMouseWheelListener(wheelListeners[i]);
        }
        if (this.lens != null) {
            this.lens.disableMouseAndKeyListener();
        }
    }

    public synchronized void iniDefaultMouseListener() {
        this.addMouseListener((MouseListener)((Object)this.focusHandler));
        this.addMouseMotionListener((MouseMotionListener)((Object)this.focusHandler));
    }

    public synchronized void iniDefaultKeyListener() {
        this.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 67 && e.isControlDown()) {
            ViewTransferHandler imageTransferHandler = new ViewTransferHandler();
            imageTransferHandler.exportToClipboard(this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            ViewerToolBar toolBar;
            ImageViewerPlugin<E> view = this.eventManager.getSelectedView2dContainer();
            if (view != null && (toolBar = view.getViewerToolBar()) != null) {
                String command = ViewerToolBar.getNextCommand(ViewerToolBar.actionsButtons, toolBar.getMouseLeft().getActionCommand()).cmd();
                this.changeLeftMouseAction(command);
            }
        } else {
            ActionW action = this.eventManager.getActionFromkeyEvent(e.getKeyCode());
            if (action != null) {
                this.changeLeftMouseAction(action.cmd());
            }
        }
    }

    private void changeLeftMouseAction(String command) {
        MouseActions mouseActions;
        ViewerToolBar toolBar;
        ImageViewerPlugin<E> view = this.eventManager.getSelectedView2dContainer();
        if (view != null && (toolBar = view.getViewerToolBar()) != null && !command.equals((mouseActions = this.eventManager.getMouseActions()).getAction("left"))) {
            mouseActions.setAction("left", command);
            if (view != null) {
                view.setMouseActions(mouseActions);
            }
            toolBar.changeButtonState("left", command);
        }
    }

    private void drawPointer(Graphics2D g) {
        if (this.pointerType < 1) {
            return;
        }
        if (this.pointerType == 1) {
            this.drawPointer(g, (double)(this.getWidth() - 1) * 0.5, (double)(this.getHeight() - 1) * 0.5);
        } else if (this.pointerType == 3 && this.highlightedPosition != null) {
            this.drawPointer(g, (double)this.highlightedPosition.x + 0.5, (double)this.highlightedPosition.y + 0.5);
        }
    }

    public int getPointerType() {
        return this.pointerType;
    }

    public void setPointerType(int pointerType) {
        this.pointerType = pointerType;
    }

    public void drawPointer(Graphics2D g, double x, double y) {
        int i;
        float[] dash = new float[]{5.0f};
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(x, y);
        g.setStroke(new BasicStroke(3.0f));
        g.setPaint(this.pointerColor1);
        for (i = 1; i < pointer.length; ++i) {
            g.draw(pointer[i]);
        }
        g.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
        g.setPaint(this.pointerColor2);
        for (i = 1; i < pointer.length; ++i) {
            g.draw(pointer[i]);
        }
        g.translate(-x, -y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    protected void showPixelInfos(MouseEvent mouseevent) {
        if (this.infoLayer != null) {
            Point2D pModel = this.getImageCoordinatesFromMouse(mouseevent.getX(), mouseevent.getY());
            Rectangle oldBound = this.infoLayer.getPixelInfoBound();
            String str = this.getPixelInfo(new Point((int)Math.floor(pModel.getX()), (int)Math.floor(pModel.getY())), this.imageLayer);
            oldBound.width = Math.max(oldBound.width, this.getGraphics().getFontMetrics().stringWidth(Messages.getString("DefaultView2d.pix") + str) + 4);
            this.infoLayer.setPixelInfo(str);
            this.repaint(oldBound);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public List<Action> getExportToClipboardAction() {
        ArrayList<Action> list = new ArrayList<Action>();
        AbstractAction exportToClipboardAction = new AbstractAction("Selected View to Clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTransferHandler imageTransferHandler = new ViewTransferHandler();
                imageTransferHandler.exportToClipboard(DefaultView2d.this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
        };
        exportToClipboardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        list.add(exportToClipboardAction);
        exportToClipboardAction = new AbstractAction(Messages.getString("DefaultView2d.clipboard")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageTransferHandler imageTransferHandler = new ImageTransferHandler();
                imageTransferHandler.exportToClipboard(DefaultView2d.this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
        };
        list.add(exportToClipboardAction);
        return list;
    }

    public abstract void enableMouseAndKeyListener(MouseActions var1);

    public static final AffineTransform getAffineTransform(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getAffineTransform();
        }
        return null;
    }

    static {
        DefaultView2d.pointer[0] = new Ellipse2D.Double(-27.0, -27.0, 54.0, 54.0);
        DefaultView2d.pointer[1] = new Line2D.Double(-40.0, 0.0, -5.0, 0.0);
        DefaultView2d.pointer[2] = new Line2D.Double(5.0, 0.0, 40.0, 0.0);
        DefaultView2d.pointer[3] = new Line2D.Double(0.0, -40.0, 0.0, -5.0);
        DefaultView2d.pointer[4] = new Line2D.Double(0.0, 5.0, 0.0, 40.0);
        focusColor = Color.orange;
    }

    class FocusHandler
    extends MouseActionAdapter {
        FocusHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            ImageViewerPlugin pane;
            if (e.getClickCount() == 2 && (pane = DefaultView2d.this.eventManager.getSelectedView2dContainer()) != null) {
                pane.maximizedSelectedImagePane(DefaultView2d.this);
            }
        }

        public void mousePressed(MouseEvent mouseevent) {
            ImageViewerPlugin pane = DefaultView2d.this.eventManager.getSelectedView2dContainer();
            if (pane == null) {
                return;
            }
            if (pane.isContainingView(DefaultView2d.this)) {
                pane.setSelectedImagePane(DefaultView2d.this);
            }
            DefaultView2d.this.requestFocusInWindow();
            int modifiers = mouseevent.getModifiersEx();
            MouseActions mouseActions = DefaultView2d.this.eventManager.getMouseActions();
            ActionW action = null;
            if ((modifiers & 0x400) != 0) {
                action = DefaultView2d.this.eventManager.getActionFromCommand(mouseActions.getLeft());
            } else if ((modifiers & 0x800) != 0 && (mouseActions.getActiveButtons() & 0x800) != 0) {
                action = DefaultView2d.this.eventManager.getActionFromCommand(mouseActions.getMiddle());
            } else if ((modifiers & 0x1000) != 0 && (mouseActions.getActiveButtons() & 0x1000) != 0) {
                action = DefaultView2d.this.eventManager.getActionFromCommand(mouseActions.getRight());
            }
            DefaultView2d.this.setCursor(action == null ? AbstractLayerModel.DEFAULT_CURSOR : action.getCursor());
        }

        public void mouseMoved(MouseEvent e) {
            DefaultView2d.this.showPixelInfos(e);
        }

        public void mouseReleased(MouseEvent e) {
            DefaultView2d.this.setCursor(AbstractLayerModel.DEFAULT_CURSOR);
        }
    }

    protected class MouseHandler
    extends MouseActionAdapter {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            AbstractDragGraphic dragGraph;
            int buttonMask = this.getButtonMaskEx();
            if ((e.getModifiersEx() & buttonMask) == 0) {
                return;
            }
            MouseEventDouble mouseEvt = new MouseEventDouble(e);
            mouseEvt.setImageCoordinates(DefaultView2d.this.getImageCoordinatesFromMouse(e.getX(), e.getY()));
            if (DefaultView2d.this.ds != null && !DefaultView2d.this.ds.completeDrag(mouseEvt)) {
                return;
            }
            Cursor newCursor = AbstractLayerModel.DEFAULT_CURSOR;
            if (!mouseEvt.isShiftDown()) {
                List<AbstractDragGraphic> selectedDragGraphList = DefaultView2d.this.getLayerModel().getSelectedDragableGraphics();
                Graphic firstGraphicIntersecting = DefaultView2d.this.getLayerModel().getFirstGraphicIntersecting(mouseEvt);
                if (firstGraphicIntersecting instanceof AbstractDragGraphic) {
                    AbstractDragGraphic dragGraph2 = (AbstractDragGraphic)firstGraphicIntersecting;
                    if (selectedDragGraphList != null && selectedDragGraphList.contains(dragGraph2)) {
                        if (selectedDragGraphList.size() > 1) {
                            DefaultView2d.this.ds = new BulkDragSequence(selectedDragGraphList, mouseEvt);
                            newCursor = AbstractLayerModel.MOVE_CURSOR;
                        } else if (selectedDragGraphList.size() == 1) {
                            if (dragGraph2.isOnGraphicLabel(mouseEvt)) {
                                DefaultView2d.this.ds = dragGraph2.createDragLabelSequence();
                                newCursor = AbstractLayerModel.HAND_CURSOR;
                            } else {
                                int handlePtIndex = dragGraph2.getHandlePointIndex(mouseEvt);
                                if (handlePtIndex >= 0) {
                                    dragGraph2.moveMouseOverHandlePoint(handlePtIndex, mouseEvt);
                                    DefaultView2d.this.ds = dragGraph2.createResizeDrag(handlePtIndex);
                                    newCursor = AbstractLayerModel.EDIT_CURSOR;
                                } else {
                                    DefaultView2d.this.ds = dragGraph2.createMoveDrag();
                                    newCursor = AbstractLayerModel.MOVE_CURSOR;
                                }
                            }
                        }
                    } else {
                        if (dragGraph2.isOnGraphicLabel(mouseEvt)) {
                            DefaultView2d.this.ds = dragGraph2.createDragLabelSequence();
                            newCursor = AbstractLayerModel.HAND_CURSOR;
                        } else {
                            DefaultView2d.this.ds = dragGraph2.createMoveDrag();
                            newCursor = AbstractLayerModel.MOVE_CURSOR;
                        }
                        DefaultView2d.this.getLayerModel().setSelectedGraphic(dragGraph2);
                    }
                }
            }
            if (DefaultView2d.this.ds == null && (dragGraph = DefaultView2d.this.getLayerModel().createDragGraphic(mouseEvt)) != null) {
                DefaultView2d.this.ds = dragGraph.createResizeDrag();
                if (dragGraph instanceof SelectGraphic) {
                    DefaultView2d.this.getLayerModel().setSelectGraphic((SelectGraphic)dragGraph);
                } else {
                    DefaultView2d.this.getLayerModel().setSelectedGraphic(dragGraph);
                }
            }
            DefaultView2d.this.getLayerModel().setCursor(newCursor);
            if (DefaultView2d.this.ds != null) {
                DefaultView2d.this.ds.startDrag(mouseEvt);
            } else {
                DefaultView2d.this.getLayerModel().setSelectedGraphics(null);
            }
            DefaultView2d.this.getLayerModel().fireGraphicsSelectionChanged((ImageElement)DefaultView2d.this.getImage());
        }

        public void mouseReleased(MouseEvent e) {
            int buttonMask = this.getButtonMask();
            if ((e.getModifiers() & buttonMask) == 0) {
                return;
            }
            if (DefaultView2d.this.ds == null) {
                return;
            }
            MouseEventDouble mouseEvt = new MouseEventDouble(e);
            mouseEvt.setImageCoordinates(DefaultView2d.this.getImageCoordinatesFromMouse(e.getX(), e.getY()));
            SelectGraphic selectGraphic = DefaultView2d.this.getLayerModel().getSelectGraphic();
            if (selectGraphic != null) {
                ArrayList<Graphic> selectedGraphList;
                AffineTransform transform = DefaultView2d.getAffineTransform(mouseEvt);
                Rectangle selectionRect = selectGraphic.getBounds(transform);
                boolean isSelectionSingleClic = selectionRect == null || selectionRect.width < 5 && selectionRect.height < 5;
                List<Graphic> newSelectedGraphList = null;
                if (!isSelectionSingleClic) {
                    newSelectedGraphList = DefaultView2d.this.getLayerModel().getSelectedAllGraphicsIntersecting(selectionRect, transform);
                } else {
                    Graphic selectedGraph = DefaultView2d.this.getLayerModel().getFirstGraphicIntersecting(mouseEvt);
                    if (selectedGraph != null) {
                        newSelectedGraphList = new ArrayList<Graphic>(1);
                        newSelectedGraphList.add(selectedGraph);
                    }
                }
                if (mouseEvt.isShiftDown() && (selectedGraphList = new ArrayList<Graphic>(DefaultView2d.this.getLayerModel().getSelectedGraphics())) != null && selectedGraphList.size() > 0) {
                    if (newSelectedGraphList == null) {
                        newSelectedGraphList = new ArrayList<Graphic>(selectedGraphList);
                    } else {
                        for (Graphic graphic : selectedGraphList) {
                            if (!newSelectedGraphList.contains(graphic)) {
                                newSelectedGraphList.add(graphic);
                                continue;
                            }
                            if (!isSelectionSingleClic) continue;
                            newSelectedGraphList.remove(graphic);
                        }
                    }
                }
                DefaultView2d.this.getLayerModel().setSelectedGraphics(newSelectedGraphList);
                DefaultView2d.this.getLayerModel().setSelectGraphic(null);
            }
            if (DefaultView2d.this.ds.completeDrag(mouseEvt)) {
                ActionState measure;
                ActionState drawOnceAction = DefaultView2d.this.eventManager.getAction(ActionW.DRAW_ONLY_ONCE);
                if (drawOnceAction instanceof ToggleButtonListener && ((ToggleButtonListener)drawOnceAction).isSelected() && (measure = DefaultView2d.this.eventManager.getAction(ActionW.DRAW_MEASURE)) instanceof ComboItemListener) {
                    ((ComboItemListener)measure).setSelectedItem((Object)MeasureToolBar.selectionGraphic);
                }
                DefaultView2d.this.ds = null;
            }
            DefaultView2d.this.getLayerModel().fireGraphicsSelectionChanged((ImageElement)DefaultView2d.this.getImage());
            Cursor newCursor = AbstractLayerModel.DEFAULT_CURSOR;
            List<AbstractDragGraphic> selectedDragGraphList = DefaultView2d.this.getLayerModel().getSelectedDragableGraphics();
            Graphic firstGraphicIntersecting = DefaultView2d.this.getLayerModel().getFirstGraphicIntersecting(mouseEvt);
            if (firstGraphicIntersecting instanceof AbstractDragGraphic) {
                AbstractDragGraphic dragGraph = (AbstractDragGraphic)firstGraphicIntersecting;
                if (selectedDragGraphList != null && selectedDragGraphList.contains(dragGraph)) {
                    if (selectedDragGraphList.size() > 1) {
                        newCursor = AbstractLayerModel.MOVE_CURSOR;
                    } else if (selectedDragGraphList.size() == 1) {
                        newCursor = dragGraph.isOnGraphicLabel(mouseEvt) ? AbstractLayerModel.HAND_CURSOR : (dragGraph.getHandlePointIndex(mouseEvt) >= 0 ? AbstractLayerModel.EDIT_CURSOR : AbstractLayerModel.MOVE_CURSOR);
                    }
                } else {
                    newCursor = dragGraph.isOnGraphicLabel(mouseEvt) ? AbstractLayerModel.HAND_CURSOR : AbstractLayerModel.MOVE_CURSOR;
                }
            }
            DefaultView2d.this.getLayerModel().setCursor(newCursor);
        }

        public void mouseDragged(MouseEvent e) {
            int buttonMask = this.getButtonMaskEx();
            if ((e.getModifiersEx() & buttonMask) == 0) {
                return;
            }
            if (DefaultView2d.this.ds != null) {
                MouseEventDouble mouseEvt = new MouseEventDouble(e);
                mouseEvt.setImageCoordinates(DefaultView2d.this.getImageCoordinatesFromMouse(e.getX(), e.getY()));
                DefaultView2d.this.ds.drag(mouseEvt);
            }
        }

        public void mouseMoved(MouseEvent e) {
            MouseEventDouble mouseEvt = new MouseEventDouble(e);
            mouseEvt.setImageCoordinates(DefaultView2d.this.getImageCoordinatesFromMouse(e.getX(), e.getY()));
            if (DefaultView2d.this.ds != null) {
                DefaultView2d.this.ds.drag(mouseEvt);
            } else {
                Cursor newCursor = AbstractLayerModel.DEFAULT_CURSOR;
                if (!mouseEvt.isShiftDown()) {
                    List<AbstractDragGraphic> selectedDragGraphList = DefaultView2d.this.getLayerModel().getSelectedDragableGraphics();
                    Graphic firstGraphicIntersecting = DefaultView2d.this.getLayerModel().getFirstGraphicIntersecting(mouseEvt);
                    if (firstGraphicIntersecting instanceof AbstractDragGraphic) {
                        AbstractDragGraphic dragGraph = (AbstractDragGraphic)firstGraphicIntersecting;
                        if (selectedDragGraphList != null && selectedDragGraphList.contains(dragGraph)) {
                            if (selectedDragGraphList.size() > 1) {
                                newCursor = AbstractLayerModel.MOVE_CURSOR;
                            } else if (selectedDragGraphList.size() == 1) {
                                newCursor = dragGraph.isOnGraphicLabel(mouseEvt) ? AbstractLayerModel.HAND_CURSOR : (dragGraph.getHandlePointIndex(mouseEvt) >= 0 ? AbstractLayerModel.EDIT_CURSOR : AbstractLayerModel.MOVE_CURSOR);
                            }
                        } else {
                            newCursor = dragGraph.isOnGraphicLabel(mouseEvt) ? AbstractLayerModel.HAND_CURSOR : AbstractLayerModel.MOVE_CURSOR;
                        }
                    }
                }
                DefaultView2d.this.getLayerModel().setCursor(newCursor);
            }
        }
    }

    protected static class BulkDragSequence
    implements DragSequence {
        private final List<DragSequence> childDS;

        BulkDragSequence(List<AbstractDragGraphic> dragGraphList, MouseEventDouble mouseevent) {
            this.childDS = new ArrayList<DragSequence>(dragGraphList.size());
            for (AbstractDragGraphic dragGraph : dragGraphList) {
                DragSequence dragsequence = dragGraph.createMoveDrag();
                if (dragsequence == null) continue;
                this.childDS.add(dragsequence);
            }
        }

        @Override
        public void startDrag(MouseEventDouble mouseevent) {
            int j = this.childDS.size();
            for (int i = 0; i < j; ++i) {
                this.childDS.get(i).startDrag(mouseevent);
            }
        }

        @Override
        public void drag(MouseEventDouble mouseevent) {
            int j = this.childDS.size();
            for (int i = 0; i < j; ++i) {
                this.childDS.get(i).drag(mouseevent);
            }
        }

        @Override
        public boolean completeDrag(MouseEventDouble mouseevent) {
            int j = this.childDS.size();
            for (int i = 0; i < j; ++i) {
                this.childDS.get(i).completeDrag(mouseevent);
            }
            return true;
        }
    }
}

