/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.helper.BaseMethod;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class BindMethod
extends BaseMethod {
    private static final Class OBJECT_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = BindMethod.class$("java.lang.Object")) : class$java$lang$Object;
    private final String m_referenceName;
    private final String m_referenceClassName;
    static /* synthetic */ Class class$java$lang$Object;

    public BindMethod(AbstractComponentManager componentManager, String methodName, Class componentClass, String referenceName, String referenceClassName) {
        super(componentManager, methodName, componentClass);
        this.m_referenceName = referenceName;
        this.m_referenceClassName = referenceClassName;
    }

    protected Method doFindMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Method method;
        boolean suitableMethodNotAccessible = false;
        if (this.getComponentManager().isLogEnabled(4)) {
            this.getComponentManager().log(4, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
        }
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage);
            if (method != null) {
                if (this.getComponentManager().isLogEnabled(4)) {
                    this.getComponentManager().log(4, "doFindMethod: Found Method " + method, null);
                }
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        Class parameterClass = this.getParameterClass(targetClass);
        if (parameterClass != null) {
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
            }
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.isDS11()) {
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
        } else if (this.getComponentManager().isLogEnabled(2)) {
            this.getComponentManager().log(2, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
        }
        if (suitableMethodNotAccessible) {
            this.getComponentManager().log(1, "DependencyManager : Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Class getParameterClass(Class targetClass) {
        if (this.getComponentManager().isLogEnabled(4)) {
            this.getComponentManager().log(4, "getParameterClass: Looking for interface class " + this.m_referenceClassName + "through loader of " + targetClass.getName(), null);
        }
        try {
            ClassLoader loader = targetClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> referenceClass = loader.loadClass(this.m_referenceClassName);
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getParameterClass: Found class " + referenceClass.getName(), null);
            }
            return referenceClass;
        }
        catch (ClassNotFoundException cnfe) {
            PackageAdmin pa;
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getParameterClass: Not found through component class, using PackageAdmin service", null);
            }
            if ((pa = (PackageAdmin)Activator.getPackageAdmin()) != null) {
                String referenceClassPackage = this.m_referenceClassName.substring(0, this.m_referenceClassName.lastIndexOf(46));
                ExportedPackage[] pkg = pa.getExportedPackages(referenceClassPackage);
                if (pkg != null) {
                    for (int i = 0; i < pkg.length; ++i) {
                        try {
                            if (this.getComponentManager().isLogEnabled(4)) {
                                this.getComponentManager().log(4, "getParameterClass: Checking Bundle " + pkg[i].getExportingBundle().getSymbolicName() + "/" + pkg[i].getExportingBundle().getBundleId(), null);
                            }
                            Class referenceClass = pkg[i].getExportingBundle().loadClass(this.m_referenceClassName);
                            if (this.getComponentManager().isLogEnabled(4)) {
                                this.getComponentManager().log(4, "getParameterClass: Found class " + referenceClass.getName(), null);
                            }
                            return referenceClass;
                        }
                        catch (ClassNotFoundException cnfe2) {
                            continue;
                        }
                    }
                } else if (this.getComponentManager().isLogEnabled(4)) {
                    this.getComponentManager().log(4, "getParameterClass: No bundles exporting package " + referenceClassPackage + " found ", null);
                }
            } else if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getParameterClass: PackageAdmin service not available, cannot find class", null);
            }
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getParameterClass: No class found, falling back to class Object", null);
            }
            return OBJECT_CLASS;
        }
    }

    private Method getServiceReferenceMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (this.getComponentManager().isLogEnabled(4)) {
            this.getComponentManager().log(4, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length != 1 || !method.getName().equals(this.getMethodName())) continue;
            if (this.getComponentManager().isLogEnabled(4)) {
                this.getComponentManager().log(4, "getServiceObjectAssignableMethod: Considering " + method, null);
            }
            if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage)) {
                    return method;
                }
                suitableNotAccessible = true;
                continue;
            }
            if (!this.getComponentManager().isLogEnabled(4)) continue;
            this.getComponentManager().log(4, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, MAP_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    protected Object[] getParameters(Method method, Object rawParameter) {
        Service service = (Service)rawParameter;
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < params.length; ++i) {
            if (paramTypes[i] == SERVICE_REFERENCE_CLASS) {
                params[i] = service.getReference();
                continue;
            }
            if (paramTypes[i] == MAP_CLASS) {
                params[i] = new ReadOnlyDictionary(service.getReference());
                continue;
            }
            params[i] = service.getInstance();
            if (params[i] != null) continue;
            throw new IllegalStateException("Dependency Manager: Service " + service.getReference() + " has already gone, will not " + this.getMethodNamePrefix());
        }
        return params;
    }

    protected String getMethodNamePrefix() {
        return "bind";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Service {
        public ServiceReference getReference();

        public Object getInstance();
    }
}

