/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.config.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ScrConfiguration {
    private static final String VALUE_TRUE = "true";
    static final String PROP_FACTORY_ENABLED = "ds.factory.enabled";
    static final String PROP_LOGLEVEL = "ds.loglevel";
    private static final String PROP_CT_WORKAROUND = "ds.ctworkaround";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String PROP_SHOWTRACE = "ds.showtrace";
    private static final String PROP_SHOWERRORS = "ds.showerrors";
    private final BundleContext bundleContext;
    private int logLevel;
    private boolean factoryEnabled;
    private boolean ctWorkaround;
    static final String PID = "org.apache.felix.scr.ScrService";
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeProvider;

    public ScrConfiguration(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.configure(null);
        try {
            String[] interfaceNames;
            Object service = new ManagedService(){

                public void updated(Dictionary properties) throws ConfigurationException {
                    ScrConfiguration.this.configure(properties);
                }
            };
            Object enhancedService = this.tryToCreateMetaTypeProvider(service);
            if (enhancedService == null) {
                interfaceNames = new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ScrConfiguration.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName()};
            } else {
                interfaceNames = new String[]{(class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ScrConfiguration.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (class$org$osgi$service$metatype$MetaTypeProvider == null ? (class$org$osgi$service$metatype$MetaTypeProvider = ScrConfiguration.class$("org.osgi.service.metatype.MetaTypeProvider")) : class$org$osgi$service$metatype$MetaTypeProvider).getName()};
                service = enhancedService;
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", PID);
            bundleContext.registerService(interfaceNames, service, props);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void configure(Dictionary config) {
        if (config == null) {
            this.logLevel = this.getDefaultLogLevel();
            this.factoryEnabled = this.getDefaultFactoryEnabled();
        } else {
            this.logLevel = this.getLogLevel(config.get(PROP_LOGLEVEL));
            this.factoryEnabled = VALUE_TRUE.equals(String.valueOf(config.get(PROP_FACTORY_ENABLED)));
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isFactoryEnabled() {
        return this.factoryEnabled;
    }

    public static boolean hasCtWorkaround(BundleContext bundleContext) {
        boolean ctWorkaround = VALUE_TRUE.equals(bundleContext.getProperty(PROP_CT_WORKAROUND));
        if (ctWorkaround) {
            Activator.log(2, bundleContext.getBundle(), "OSGi CT Workaround enabled. This Declarative Services instance is not operating specification compliant:", null);
            Activator.log(2, bundleContext.getBundle(), " - Dictionary returned from ComponentContext.getProperties() is writeable", null);
            Activator.log(2, bundleContext.getBundle(), " - Location Binding of Configuration is ignored", null);
            Activator.log(2, bundleContext.getBundle(), "Remove ds.ctworkaround framework property to operate specification compliant", null);
        }
        return ctWorkaround;
    }

    private boolean getDefaultFactoryEnabled() {
        return VALUE_TRUE.equals(this.bundleContext.getProperty(PROP_FACTORY_ENABLED));
    }

    private int getDefaultLogLevel() {
        return this.getLogLevel(this.bundleContext.getProperty(PROP_LOGLEVEL));
    }

    private int getLogLevel(Object levelObject) {
        block9: {
            if (levelObject != null) {
                if (levelObject instanceof Number) {
                    return ((Number)levelObject).intValue();
                }
                String levelString = levelObject.toString();
                try {
                    return Integer.parseInt(levelString);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG_LEVEL_DEBUG.equalsIgnoreCase(levelString)) {
                        return 4;
                    }
                    if (LOG_LEVEL_INFO.equalsIgnoreCase(levelString)) {
                        return 3;
                    }
                    if (LOG_LEVEL_WARN.equalsIgnoreCase(levelString)) {
                        return 2;
                    }
                    if (!LOG_LEVEL_ERROR.equalsIgnoreCase(levelString)) break block9;
                    return 1;
                }
            }
        }
        if (VALUE_TRUE.equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWTRACE))) {
            return 4;
        }
        if ("false".equalsIgnoreCase(this.bundleContext.getProperty(PROP_SHOWERRORS))) {
            return -1;
        }
        return 1;
    }

    private Object tryToCreateMetaTypeProvider(Object managedService) {
        try {
            return new MetaTypeProviderImpl(this.getDefaultLogLevel(), this.getDefaultFactoryEnabled(), (ManagedService)managedService);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

