/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.wado;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dcm4che2.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.MediaSeriesGroupNode;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomInstance;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomVideoSeries;
import org.weasis.dicom.codec.wado.WadoParameters;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.Messages;
import org.weasis.dicom.explorer.wado.DownloadPriority;
import org.weasis.dicom.explorer.wado.LoadSeries;

public class DownloadManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadManager.class);

    /*
     * Exception decompiling
     */
    public static ArrayList<LoadSeries> buildDicomSeriesFromXml(URI uri, DicomModel model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MediaSeriesGroup readPatient(DicomModel model, ArrayList<LoadSeries> seriesList, XMLStreamReader xmler, WadoParameters wadoParameters) throws XMLStreamException {
        String unknown = Messages.getString("DownloadManager.unknown");
        String patientID = DownloadManager.getTagAttribute(xmler, TagW.PatientID.getTagName(), unknown);
        Date birthdate = DateUtils.parseDA((String)DownloadManager.getTagAttribute(xmler, TagW.PatientBirthDate.getTagName(), null), (boolean)false);
        String name = DownloadManager.getTagAttribute(xmler, TagW.PatientName.getTagName(), unknown);
        String patientPseudoUID = patientID + (birthdate == null ? "" : TagW.dicomformatDate.format(birthdate).toString());
        MediaSeriesGroup patient = model.getHierarchyNode(TreeModel.rootNode, patientPseudoUID);
        if (patient == null) {
            patient = new MediaSeriesGroupNode(TagW.PatientPseudoUID, (Object)patientPseudoUID, TagW.PatientName);
            patient.setTag(TagW.PatientID, (Object)patientID);
            if (name.trim().equals("")) {
                name = unknown;
            }
            name = name.replace("^", " ");
            patient.setTag(TagW.PatientName, (Object)name);
            patient.setTag(TagW.PatientSex, (Object)DownloadManager.getTagAttribute(xmler, TagW.PatientSex.getTagName(), "O"));
            patient.setTag(TagW.PatientBirthDate, (Object)birthdate);
            patient.setTagNoNull(TagW.PatientBirthTime, (Object)TagW.getDicomTime((String)DownloadManager.getTagAttribute(xmler, TagW.PatientBirthTime.getTagName(), null)));
            model.addHierarchyNode(TreeModel.rootNode, patient);
            LOGGER.info("Adding new patient: " + patient);
        }
        boolean state = true;
        block4: while (xmler.hasNext() && state) {
            int eventType = xmler.next();
            switch (eventType) {
                case 1: {
                    if (!TagW.DICOM_LEVEL.Study.name().equals(xmler.getName().getLocalPart())) continue block4;
                    DownloadManager.readStudy(model, seriesList, xmler, patient, wadoParameters);
                    continue block4;
                }
                case 2: {
                    if (!TagW.DICOM_LEVEL.Patient.name().equals(xmler.getName().getLocalPart())) continue block4;
                    state = false;
                    continue block4;
                }
            }
        }
        return patient;
    }

    private static MediaSeriesGroup readStudy(DicomModel model, ArrayList<LoadSeries> seriesList, XMLStreamReader xmler, MediaSeriesGroup patient, WadoParameters wadoParameters) throws XMLStreamException {
        String studyUID = DownloadManager.getTagAttribute(xmler, TagW.StudyInstanceUID.getTagName(), "");
        MediaSeriesGroup study = model.getHierarchyNode(patient, studyUID);
        if (study == null) {
            study = new MediaSeriesGroupNode(TagW.StudyInstanceUID, (Object)studyUID, TagW.StudyDate);
            study.setTagNoNull(TagW.StudyDate, (Object)TagW.getDicomDate((String)DownloadManager.getTagAttribute(xmler, TagW.StudyDate.getTagName(), null)));
            study.setTagNoNull(TagW.StudyTime, (Object)TagW.getDicomTime((String)DownloadManager.getTagAttribute(xmler, TagW.StudyTime.getTagName(), null)));
            study.setTagNoNull(TagW.StudyDescription, (Object)DownloadManager.getTagAttribute(xmler, TagW.StudyDescription.getTagName(), null));
            study.setTagNoNull(TagW.AccessionNumber, (Object)DownloadManager.getTagAttribute(xmler, TagW.AccessionNumber.getTagName(), null));
            study.setTagNoNull(TagW.StudyID, (Object)DownloadManager.getTagAttribute(xmler, TagW.StudyID.getTagName(), null));
            model.addHierarchyNode(patient, study);
        }
        boolean state = true;
        block4: while (xmler.hasNext() && state) {
            int eventType = xmler.next();
            switch (eventType) {
                case 1: {
                    if (!TagW.DICOM_LEVEL.Series.name().equals(xmler.getName().getLocalPart())) continue block4;
                    DownloadManager.readSeries(model, seriesList, xmler, patient, study, wadoParameters);
                    continue block4;
                }
                case 2: {
                    if (!TagW.DICOM_LEVEL.Study.name().equals(xmler.getName().getLocalPart())) continue block4;
                    state = false;
                    continue block4;
                }
            }
        }
        return study;
    }

    private static Series readSeries(DicomModel model, ArrayList<LoadSeries> seriesList, XMLStreamReader xmler, MediaSeriesGroup patient, MediaSeriesGroup study, WadoParameters wadoParameters) throws XMLStreamException {
        String seriesUID = DownloadManager.getTagAttribute(xmler, TagW.SeriesInstanceUID.getTagName(), "");
        Series dicomSeries = (Series)model.getHierarchyNode(study, seriesUID);
        if (dicomSeries == null) {
            dicomSeries = new DicomSeries(seriesUID);
            dicomSeries.setTag(TagW.ExplorerModel, (Object)model);
            dicomSeries.setTag(TagW.SeriesInstanceUID, (Object)seriesUID);
            dicomSeries.setTag(TagW.Modality, (Object)DownloadManager.getTagAttribute(xmler, TagW.Modality.getTagName(), null));
            dicomSeries.setTag(TagW.WadoParameters, (Object)wadoParameters);
            dicomSeries.setTag(TagW.WadoInstanceReferenceList, new ArrayList());
            dicomSeries.setTagNoNull(TagW.SeriesNumber, (Object)DownloadManager.getIntegerTagAttribute(xmler, TagW.SeriesNumber.getTagName(), null));
            dicomSeries.setTagNoNull(TagW.SeriesDescription, (Object)DownloadManager.getTagAttribute(xmler, TagW.SeriesDescription.getTagName(), null));
            dicomSeries.setTagNoNull(TagW.ReferringPhysicianName, (Object)DownloadManager.getTagAttribute(xmler, TagW.ReferringPhysicianName.getTagName(), null));
            dicomSeries.setTagNoNull(TagW.WadoTransferSyntaxUID, (Object)DownloadManager.getTagAttribute(xmler, TagW.WadoTransferSyntaxUID.getTagName(), null));
            dicomSeries.setTagNoNull(TagW.WadoCompressionRate, (Object)DownloadManager.getIntegerTagAttribute(xmler, TagW.WadoCompressionRate.getTagName(), null));
            model.addHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
        } else {
            WadoParameters wado = (WadoParameters)dicomSeries.getTagValue(TagW.WadoParameters);
            if (wado == null) {
                dicomSeries.setTag(TagW.WadoParameters, (Object)wadoParameters);
            } else if (!wado.getWadoURL().equals(wadoParameters.getWadoURL())) {
                LOGGER.error("Wado parameters must be unique for a DICOM Series: {}", (Object)dicomSeries);
                return dicomSeries;
            }
        }
        List dicomInstances = (List)dicomSeries.getTagValue(TagW.WadoInstanceReferenceList);
        boolean containsInstance = false;
        if (dicomInstances == null) {
            dicomSeries.setTag(TagW.WadoInstanceReferenceList, new ArrayList());
        } else if (dicomInstances.size() > 0) {
            containsInstance = true;
        }
        boolean state = true;
        block4: while (xmler.hasNext() && state) {
            int eventType = xmler.next();
            switch (eventType) {
                case 1: {
                    String sopInstanceUID;
                    if (!TagW.DICOM_LEVEL.Instance.name().equals(xmler.getName().getLocalPart()) || (sopInstanceUID = DownloadManager.getTagAttribute(xmler, TagW.SOPInstanceUID.getTagName(), null)) == null) continue block4;
                    String tsuid = DownloadManager.getTagAttribute(xmler, TagW.TransferSyntaxUID.getTagName(), null);
                    DicomInstance dcmInstance = new DicomInstance(sopInstanceUID, tsuid);
                    if (containsInstance && dicomInstances.contains(dcmInstance)) {
                        LOGGER.warn("DICOM instance {} already exists, abort downloading.", (Object)sopInstanceUID);
                        continue block4;
                    }
                    dcmInstance.setInstanceNumber(DownloadManager.getIntegerTagAttribute(xmler, TagW.InstanceNumber.getTagName(), -1).intValue());
                    dcmInstance.setDirectDownloadFile(DownloadManager.getTagAttribute(xmler, TagW.DirectDownloadFile.getTagName(), null));
                    dicomInstances.add(dcmInstance);
                    continue block4;
                }
                case 2: {
                    if (!TagW.DICOM_LEVEL.Series.name().equals(xmler.getName().getLocalPart())) continue block4;
                    state = false;
                    continue block4;
                }
            }
        }
        if (dicomInstances.size() > 0) {
            String modality;
            if (dicomInstances.size() == 1 && "1.2.840.10008.1.2.4.100".equals(((DicomInstance)dicomInstances.get(0)).getTransferSyntaxUID())) {
                model.removeHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
                dicomSeries = new DicomVideoSeries((DicomSeries)dicomSeries);
                model.addHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
            }
            boolean ps = (modality = (String)dicomSeries.getTagValue(TagW.Modality)) != null && ("PR".equals(modality) || "KO".equals(modality));
            LoadSeries loadSeries = new LoadSeries(dicomSeries, model);
            Integer sn = (Integer)(ps ? Integer.valueOf(Integer.MAX_VALUE) : dicomSeries.getTagValue(TagW.SeriesNumber));
            DownloadPriority priority = new DownloadPriority((String)patient.getTagValue(TagW.PatientName), (String)study.getTagValue(TagW.StudyInstanceUID), (Date)study.getTagValue(TagW.StudyDate), sn);
            loadSeries.setPriority(priority);
            seriesList.add(loadSeries);
        }
        return dicomSeries;
    }

    private static String getTagAttribute(XMLStreamReader xmler, String attribute, String defaultValue) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            return val;
        }
        return defaultValue;
    }

    private static Integer getIntegerTagAttribute(XMLStreamReader xmler, String attribute, Integer defaultValue) {
        if (attribute != null) {
            try {
                String val = xmler.getAttributeValue(null, attribute);
                if (val != null) {
                    return Integer.valueOf(val);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

