/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.wado;

import org.osgi.service.prefs.Preferences;
import org.weasis.core.api.service.BundlePreferences;
import org.weasis.dicom.codec.TransferSyntax;
import org.weasis.dicom.explorer.internal.Activator;

public class DicomManager {
    private static DicomManager instance;
    private TransferSyntax wadoTSUID = null;

    public static synchronized DicomManager getInstance() {
        if (instance == null) {
            instance = new DicomManager();
        }
        return instance;
    }

    private DicomManager() {
        Preferences pref = Activator.PREFERENCES.getDefaultPreferences();
        if (pref != null) {
            Preferences prefNode = pref.node("wado");
            this.wadoTSUID = TransferSyntax.getTransferSyntax((String)prefNode.get("compression.type", "NONE"));
            if (this.wadoTSUID.getCompression() != null) {
                this.wadoTSUID.setCompression(Integer.valueOf(prefNode.getInt("compression.rate", 75)));
            }
        }
    }

    public TransferSyntax getWadoTSUID() {
        return this.wadoTSUID;
    }

    public void setWadoTSUID(TransferSyntax wadoTSUID) {
        this.wadoTSUID = wadoTSUID == null ? TransferSyntax.NONE : wadoTSUID;
    }

    public void savePreferences() {
        Preferences prefs = Activator.PREFERENCES.getDefaultPreferences();
        if (prefs != null) {
            Preferences prefNode = prefs.node("wado");
            BundlePreferences.putStringPreferences((Preferences)prefNode, (String)"compression.type", (String)this.wadoTSUID.name());
            if (this.wadoTSUID.getCompression() != null) {
                BundlePreferences.putIntPreferences((Preferences)prefNode, (String)"compression.rate", (int)this.wadoTSUID.getCompression());
            }
        }
    }
}

