/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.weasis.core.api.util.FileUtil;
import org.xml.sax.InputSource;

public class GzipManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean gzipCompress(InputStream in, String gzipFilename) {
        boolean bl;
        GZIPOutputStream gzipOut = null;
        try {
            int offset;
            gzipOut = new GZIPOutputStream(new FileOutputStream(gzipFilename));
            byte[] buf = new byte[1024];
            while ((offset = in.read(buf)) > 0) {
                gzipOut.write(buf, 0, offset);
            }
            gzipOut.finish();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(in);
                FileUtil.safeClose(gzipOut);
                throw throwable;
            }
            FileUtil.safeClose(in);
            FileUtil.safeClose(gzipOut);
            return bl2;
        }
        FileUtil.safeClose(in);
        FileUtil.safeClose(gzipOut);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean gzipUncompressToFile(InputStream inputStream, OutputStream out) {
        boolean bl;
        GZIPInputStream in = null;
        try {
            int offset;
            in = new GZIPInputStream(inputStream);
            byte[] buf = new byte[1024];
            while ((offset = in.read(buf)) > 0) {
                out.write(buf, 0, offset);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(in);
                FileUtil.safeClose(out);
                throw throwable;
            }
            FileUtil.safeClose(in);
            FileUtil.safeClose(out);
            return bl2;
        }
        FileUtil.safeClose(in);
        FileUtil.safeClose(out);
        return bl;
    }

    public static boolean gzipUncompressToFile(String inputFile, String outFilename) {
        FileOutputStream outputStream;
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(inputFile);
            outputStream = new FileOutputStream(outFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return GzipManager.gzipUncompressToFile(inputStream, outputStream);
    }

    public static boolean gzipUncompressToFile(File inputFile, File outFilename) {
        FileOutputStream outputStream;
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(inputFile);
            outputStream = new FileOutputStream(outFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return GzipManager.gzipUncompressToFile(inputStream, outputStream);
    }

    public static boolean gzipUncompressToFile(URL url, File outFilename) {
        FileOutputStream outputStream;
        InputStream input;
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            outputStream = new FileOutputStream(outFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return GzipManager.gzipUncompressToFile(input, outputStream);
    }

    public static InputStream gzipUncompressToStream(URL url) {
        try {
            return new BufferedInputStream(new GZIPInputStream(url.openStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputSource gzipUncompressToInputSource(URL url) {
        try {
            return new InputSource(new BufferedInputStream(new GZIPInputStream(url.openStream())));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputSource gzipUncompressToInputSource(File file) {
        try {
            return new InputSource(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

