/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.internal;

import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.ImagingListener;
import org.apache.felix.prefs.BackingStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.image.op.ExtremaRangeLimitDescriptor;
import org.weasis.core.api.image.op.FormatBinaryDescriptor;
import org.weasis.core.api.image.op.NotBinaryDescriptor;
import org.weasis.core.api.image.op.RectifySignedShortDataDescriptor;
import org.weasis.core.api.image.op.RectifyUShortToShortDataDescriptor;
import org.weasis.core.api.image.op.ThresholdToBinDescriptor;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.service.BundleTools;
import org.weasis.core.api.service.DataFileBackingStoreImpl;
import org.weasis.core.api.util.ProxyDetector;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static final String codecFilter = String.format("(%s=%s)", "objectClass", Codec.class.getName());
    private BundleContext bundleContext;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        bundleContext.registerService(BackingStore.class.getName(), (Object)new DataFileBackingStoreImpl(bundleContext), null);
        bundleContext.addServiceListener((ServiceListener)this, codecFilter);
        ServiceTracker m_tracker = new ServiceTracker(bundleContext, Codec.class.getName(), null);
        m_tracker.open();
        Object[] services = m_tracker.getServices();
        for (int i = 0; services != null && i < services.length; ++i) {
            if (BundleTools.CODEC_PLUGINS.contains(services[i]) || !(services[i] instanceof Codec)) continue;
            Codec codec = (Codec)services[i];
            BundleTools.CODEC_PLUGINS.add(codec);
            LOGGER.info("Register Codec Plug-in: {}", (Object)codec.getCodecName());
        }
        JAI jai = Activator.getJAI();
        OperationRegistry or = jai.getOperationRegistry();
        jai.setImagingListener(new ImagingListener(){

            public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
                LOGGER.error("JAI error ocurred: {}", (Object)message);
                return false;
            }
        });
        Activator.registerOp(or, new FormatBinaryDescriptor());
        Activator.registerOp(or, new NotBinaryDescriptor());
        Activator.registerOp(or, new ExtremaRangeLimitDescriptor());
        Activator.registerOp(or, new ThresholdToBinDescriptor());
        Activator.registerOp(or, new RectifySignedShortDataDescriptor());
        Activator.registerOp(or, new RectifyUShortToShortDataDescriptor());
        ImageToolkit.setJaiCacheMemoryCapacity(128L);
        ProxyDetector.setProxyFromJavaWebStart();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.bundleContext = null;
        BundleTools.saveSystemPreferences();
    }

    public static JAI getJAI() {
        ClassLoader bundleClassLoader = JAI.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        JAI jai = JAI.getDefaultInstance();
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        return jai;
    }

    public static void registerOp(OperationRegistry or, OperationDescriptorImpl descriptor) {
        String name = descriptor.getName();
        String[] mode = descriptor.getSupportedModes();
        RegistryElementDescriptor val = or.getDescriptor(mode[0], name);
        if (val == null) {
            or.registerDescriptor((RegistryElementDescriptor)descriptor);
            RIFRegistry.register(null, (String)name, (String)"org.weasis.core.api.image.op", (RenderedImageFactory)((RenderedImageFactory)descriptor));
        }
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        ServiceReference m_ref = event.getServiceReference();
        Codec codec = (Codec)this.bundleContext.getService(m_ref);
        if (codec == null) {
            return;
        }
        if (event.getType() == 1) {
            if (!BundleTools.CODEC_PLUGINS.contains(codec)) {
                BundleTools.CODEC_PLUGINS.add(codec);
                LOGGER.info("Register Codec Plug-in: {}", (Object)codec.getCodecName());
            }
        } else if (event.getType() == 4 && BundleTools.CODEC_PLUGINS.contains(codec)) {
            LOGGER.info("Unregister Codec Plug-in: {}", (Object)codec.getCodecName());
            BundleTools.CODEC_PLUGINS.remove(codec);
            this.bundleContext.ungetService(m_ref);
        }
    }
}

