/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.util.Vector;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.weasis.core.api.internal.Activator;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.TagW;

public class ImageToolkit {
    public static final RenderingHints NOCACHE_HINT = new RenderingHints(JAI.KEY_TILE_CACHE, null);

    public static void setJaiCacheMemoryCapacity(long tileCacheMB) {
        Activator.getJAI().getTileCache().setMemoryCapacity(tileCacheMB * 1024L * 1024L);
    }

    public static RenderedOp loadImage(File file) {
        return JAI.create((String)"LoadImage", (Object)file);
    }

    private static PlanarImage getFileloadOp(PlanarImage image) {
        return ImageToolkit.getImageOp(image, "LoadImage");
    }

    public static PlanarImage getImageOp(PlanarImage image, String opName) {
        if (image instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)image;
            if (op.getOperationName().equalsIgnoreCase(opName)) {
                return image;
            }
            while (image.getNumSources() > 0) {
                try {
                    op = (RenderedOp)(image = image.getSourceImage(0));
                    if (!op.getOperationName().equalsIgnoreCase(opName)) continue;
                    return image;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    private static File getFilePath(Vector ParameterBlock2, String opName) {
        if (ParameterBlock2 != null && ParameterBlock2.size() >= 1 && opName.equalsIgnoreCase("LoadImage")) {
            try {
                return (File)ParameterBlock2.get(0);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static File getFileNameOfSource(PlanarImage image) {
        if (image instanceof RenderedOp) {
            RenderedOp img = (RenderedOp)image;
            Vector sources = img.getSources();
            if (sources.size() == 0) {
                return ImageToolkit.getFilePath(img.getParameterBlock().getParameters(), img.getOperationName());
            }
            if (sources.size() >= 1 && sources.get(0) instanceof PlanarImage) {
                return ImageToolkit.getFileNameOfSource((PlanarImage)sources.get(0));
            }
        }
        return null;
    }

    public static RenderedImage convertIndexColorToRGBColor(RenderedImage image) {
        RenderedImage result = image;
        if (image.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)image.getColorModel();
            int mapSize = icm.getMapSize();
            byte[][] lutData = new byte[3][mapSize];
            icm.getReds(lutData[0]);
            icm.getGreens(lutData[1]);
            icm.getBlues(lutData[2]);
            LookupTableJAI lut = new LookupTableJAI(lutData);
            result = JAI.create((String)"lookup", (RenderedImage)image, (Object)lut);
        }
        return result;
    }

    public static RenderedOp scaleImage(RenderedOp image, int scaleWidth, int scaleHeight) {
        return ImageToolkit.scaleImage(image, scaleWidth, scaleHeight, false, 0.0);
    }

    public static RenderedOp scaleImage(RenderedOp image, int scaleWidth, int scaleHeight, boolean keepAspect, double color) {
        float xScale = (float)scaleWidth / (float)image.getWidth();
        float yScale = (float)scaleHeight / (float)image.getHeight();
        boolean resize = false;
        if (keepAspect) {
            resize = (double)Math.abs(xScale - yScale) < 1.0E-7;
            yScale = xScale = Math.min(xScale, yScale);
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(image);
        params.add(xScale);
        params.add(yScale);
        params.add(0.0f);
        params.add(0.0f);
        params.add(Interpolation.getInstance((int)2));
        RenderedOp result = JAI.create((String)"scale", (ParameterBlock)params);
        if (resize) {
            result = ImageToolkit.resizeImage(result, scaleWidth, scaleHeight, color);
        }
        return result;
    }

    public static RenderedOp resizeImage(RenderedOp image, int toWidth, int toHeight, double color) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (width > toWidth || height > toHeight) {
            image = ImageToolkit.cropImage(image, Math.min(width, toWidth), Math.min(height, toHeight));
        }
        if (width < toWidth || height < toHeight) {
            int w = Math.max((toWidth - width) / 2, 0);
            int h = Math.max((toHeight - height) / 2, 0);
            image = ImageToolkit.borderImage(image, w, w, h, h, color);
        }
        return image;
    }

    public static RenderedOp cropImage(RenderedOp image, int toWidth, int toHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xOffset = (width - toWidth) / 2;
        int yOffset = (height - toHeight) / 2;
        ParameterBlock params = new ParameterBlock();
        params.addSource(image);
        params.add((float)xOffset);
        params.add((float)yOffset);
        params.add((float)toWidth);
        params.add((float)toHeight);
        return JAI.create((String)"crop", (ParameterBlock)params);
    }

    public static RenderedOp borderImage(RenderedOp image, int left, int right, int top, int btm, double color) {
        ParameterBlock params = new ParameterBlock();
        params.addSource(image);
        params.add(left);
        params.add(right);
        params.add(top);
        params.add(btm);
        double[] fill = new double[]{color};
        params.add(new BorderExtenderConstant(fill));
        params.add(color);
        return JAI.create((String)"border", (ParameterBlock)params);
    }

    public static RenderedImage getDefaultRenderedImage(ImageElement image, RenderedImage source, float window, float level) {
        if (image == null || source == null) {
            return null;
        }
        RenderedOp result = null;
        SampleModel sampleModel = source.getSampleModel();
        if (sampleModel == null) {
            return null;
        }
        int datatype = sampleModel.getDataType();
        if (datatype == 0 && window == 255.0f && level == 127.5f) {
            return source;
        }
        boolean monochrome1 = "monochrome1".equalsIgnoreCase((String)image.getTagValue(TagW.PhotometricInterpretation));
        int minValue = (int)image.getPixelLevel(image.getMinValue());
        int maxValue = (int)image.getPixelLevel(image.getMaxValue());
        int tableLength = maxValue - minValue + 1;
        double high = (double)level + (double)window / 2.0;
        double low = (double)level - (double)window / 2.0;
        double range = high - low;
        if (range < 1.0) {
            range = 1.0;
        }
        double slope = 255.0 / range;
        double y_int = 255.0 - slope * high;
        if (datatype >= 0 && datatype < 3) {
            int i;
            Integer paddingValue = (Integer)image.getTagValue(TagW.PixelPaddingValue);
            Integer paddingLimit = (Integer)image.getTagValue(TagW.PixelPaddingRangeLimit);
            if (paddingValue != null) {
                if (paddingLimit == null) {
                    paddingLimit = paddingValue;
                } else if (paddingLimit < paddingValue) {
                    int temp = paddingValue;
                    paddingValue = paddingLimit;
                    paddingLimit = temp;
                }
                if (paddingValue < minValue) {
                    minValue = paddingValue;
                }
                if (paddingLimit > maxValue) {
                    maxValue = paddingLimit;
                }
                tableLength = maxValue - minValue + 1;
            }
            byte[][] lut = new byte[1][tableLength];
            for (i = 0; i < tableLength; ++i) {
                int value = (int)(slope * (double)(i + minValue) + y_int);
                if (monochrome1) {
                    value = 255 - value;
                }
                if (value > 255) {
                    value = 255;
                }
                if (value < 0) {
                    value = 0;
                }
                lut[0][i] = (byte)value;
            }
            if (paddingValue != null) {
                int max = paddingLimit - minValue + 1;
                if (i >= 0 && max <= tableLength) {
                    for (i = paddingValue - minValue; i < max; ++i) {
                        lut[0][i] = 0;
                    }
                }
            }
            LookupTableJAI lookup = new LookupTableJAI(lut, minValue);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(source);
            pb.add(lookup);
            result = JAI.create((String)"lookup", (ParameterBlock)pb, null);
        } else if (datatype == 3 || datatype == 4 || datatype == 5) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(source);
            pb.add(new double[]{slope});
            pb.add(new double[]{y_int});
            result = JAI.create((String)"rescale", (ParameterBlock)pb, null);
            pb = new ParameterBlock();
            pb.addSource(result);
            pb.add(0);
            result = JAI.create((String)"format", (ParameterBlock)pb, null);
        }
        return result;
    }

    public static RenderedImage getDefaultRenderedImage(ImageElement image, RenderedImage source) {
        float window = image.getPixelWindow(image.getDefaultWindow());
        float level = image.getPixelLevel(image.getDefaultLevel());
        return ImageToolkit.getDefaultRenderedImage(image, source, window, level);
    }
}

