/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.OperationDescriptorImpl;
import org.weasis.core.api.image.op.ThresholdToBinOpImage;
import org.weasis.core.api.image.util.LayoutUtil;

public class ThresholdToBinDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "ThresholdToBin"}, {"LocalName", "ThresholdToBin"}, {"Vendor", ""}, {"Description", "A sample operation that thresholds source pixels"}, {"DocURL", "http://www.mycompany.com/SampleDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "min"}, {"arg1Desc", "max"}};
    private static final String[] paramNames = new String[]{"min", "max"};
    private static final Class[] paramClasses = new Class[]{Double.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{new Double(0.0), new Double(128.0)};
    private static final String[] supportedModes = new String[]{"rendered"};

    public ThresholdToBinDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public RenderedImage create(ParameterBlock parameterblock, RenderingHints renderHints) {
        if (!this.validateParameters(parameterblock)) {
            return null;
        }
        if (!this.validateSources(parameterblock)) {
            return null;
        }
        renderHints = LayoutUtil.createBinaryRenderedImage();
        ImageLayout imagelayout = LayoutUtil.getImageLayoutHint(renderHints);
        return new ThresholdToBinOpImage(parameterblock.getRenderedSource(0), renderHints, imagelayout, (Double)parameterblock.getObjectParameter(0), (Double)parameterblock.getObjectParameter(1));
    }

    public boolean validateParameters(ParameterBlock paramBlock) {
        for (int i = 0; i < 2; ++i) {
            Object arg = paramBlock.getObjectParameter(i);
            if (arg == null) {
                return false;
            }
            if (arg instanceof Double) continue;
            return false;
        }
        return true;
    }

    public boolean validateSources(ParameterBlock parameterblock) {
        return parameterblock.getRenderedSource(0) != null && parameterblock.getRenderedSource(0).getSampleModel().getNumBands() == 1;
    }
}

