/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class RectifyUShortToShortDataOpImage
extends ColormapOpImage {
    public RectifyUShortToShortDataOpImage(RenderedImage source, Map config, ImageLayout layout) {
        super(source, layout, config, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] colormap) {
        for (int b = 0; b < 3; ++b) {
            byte[] map = colormap[b];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = ImageUtil.clampRoundByte((float)(map[i] & 0xFF));
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag srcTag = new RasterFormatTag(this.getSampleModel(), 1025);
        RasterFormatTag dstTag = new RasterFormatTag(dest.getSampleModel(), 1026);
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, dstTag, this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, srcTag, this.getSourceImage(0).getColorModel());
        switch (dst.getDataType()) {
            case 2: {
                this.computeRectShort(src, dst);
            }
        }
        dst.copyDataToRaster();
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        for (int b = 0; b < dstBands; ++b) {
            short[] s = srcData[b];
            short[] d = dstData[b];
            if (s.length == d.length) {
                System.arraycopy(s, 0, d, 0, d.length);
                continue;
            }
            int dstLineOffset = dstBandOffsets[b];
            int srcLineOffset = srcBandOffsets[b];
            for (int h = 0; h < dstHeight; ++h) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    d[dstPixelOffset] = s[srcPixelOffset];
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }
}

