/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.RenderedOp;

public class FormatBinaryDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "FormatBinary"}, {"LocalName", "FormatBinary"}, {"Vendor", ""}, {"Description", "format bilevel to be displayed correctly"}, {"DocURL", ""}, {"Version", "1.0"}};
    private static final String[] supportedModes = new String[]{"rendered"};

    public FormatBinaryDescriptor() {
        super(resources, supportedModes, 1, null, null, null, null);
    }

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        if (!this.validateSources(paramBlock)) {
            return null;
        }
        RenderedImage imgSource = paramBlock.getRenderedSource(0);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        byte[] table_data = new byte[]{0, -1};
        if (imgSource.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)imgSource.getColorModel();
            int size = icm.getMapSize();
            table_data = new byte[size];
            icm.getReds(table_data);
        }
        LookupTableJAI lut = new LookupTableJAI(table_data);
        ImageLayout layout = new ImageLayout();
        layout.setColorModel((ColorModel)cm);
        RenderingHints hints = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(imgSource);
        pb.add(lut);
        RenderedOp dst = JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)hints);
        return dst;
    }

    public boolean validateSources(ParameterBlock parameterblock) {
        RenderedImage img = parameterblock.getRenderedSource(0);
        return img != null && ImageUtil.isBinary((SampleModel)img.getSampleModel());
    }
}

