/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;
import org.weasis.core.api.image.op.ExtremaRangeLimitOpImage;

public class ExtremaRangeLimitDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "ExtremaRangeLimit"}, {"LocalName", "ExtremaRangeLimit"}, {"Vendor", ""}, {"Description", "Finds the maximum and minimum pixel value in each band of an image with the option to exclude a range of values."}, {"DocURL", ""}, {"Version", "1.0"}, {"arg0Desc", "The region of the image to scan"}, {"arg1Desc", "The horizontal sampling rate, may not be less than 1."}, {"arg2Desc", "The vertical sampling rate, may not be less than 1."}, {"arg3Desc", "The lowest value to exlude"}, {"arg4Desc", "The highest value to exlude"}};
    private static final String[] supportedModes = new String[]{"rendered"};
    private static final String[] paramNames = new String[]{"roi", "xPeriod", "yPeriod", "excludedMin", "maxRuns"};
    private static final Class[] paramClasses = new Class[]{ROI.class, Integer.class, Integer.class, Double.class, Double.class};
    private static final Object[] paramDefaults = new Object[]{null, 1, 1, null, null};

    public ExtremaRangeLimitDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        if (!this.validateSources(paramBlock)) {
            return null;
        }
        if (!this.validateParameters(paramBlock)) {
            return null;
        }
        RenderedImage renderedimage = paramBlock.getRenderedSource(0);
        int i = renderedimage.getMinX();
        int j = renderedimage.getMinY();
        return new ExtremaRangeLimitOpImage(renderedimage, (ROI)paramBlock.getObjectParameter(0), i, j, (Integer)paramBlock.getObjectParameter(1), (Integer)paramBlock.getObjectParameter(2), (Double)paramBlock.getObjectParameter(3), (Double)paramBlock.getObjectParameter(4));
    }

    public boolean validateSources(ParameterBlock parameterblock) {
        return parameterblock.getRenderedSource(0) != null;
    }

    public boolean validateParameters(ParameterBlock paramBlock) {
        Object arg = paramBlock.getObjectParameter(0);
        if (!(arg instanceof ROI) && arg != null) {
            return false;
        }
        return paramBlock.getObjectParameter(3) != null && paramBlock.getObjectParameter(4) != null;
    }
}

