/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public final class GeomUtil {
    public static boolean isLineValid(Point2D ptA, Point2D ptB) {
        return ptA != null && ptB != null && !ptA.equals(ptB);
    }

    public static double getAngleRad(Point2D ptA, Point2D ptB, Point2D ptC) {
        if (ptA != null && ptB != null && ptC != null) {
            return GeomUtil.getAngleRad(ptB, ptC) - GeomUtil.getAngleRad(ptB, ptA);
        }
        return 0.0;
    }

    public static double getAngleDeg(Point2D ptA, Point2D ptB, Point2D ptC) {
        if (ptA != null && ptB != null && ptC != null) {
            return Math.toDegrees(GeomUtil.getAngleRad(ptA, ptB, ptC));
        }
        return 0.0;
    }

    public static double getAngleRad(Point2D ptA, Point2D ptB) {
        return ptA != null && ptB != null ? Double.valueOf(Math.atan2(ptA.getY() - ptB.getY(), ptB.getX() - ptA.getX())) : null;
    }

    public static double getAngleDeg(Point2D ptA, Point2D ptB) {
        return ptA != null && ptB != null ? Double.valueOf(Math.toDegrees(GeomUtil.getAngleRad(ptA, ptB))) : null;
    }

    public static double getSmallestRotationAngleRad(double angle) {
        if (Math.abs(angle %= Math.PI) > Math.PI) {
            angle -= Math.signum(angle) * 2.0 * Math.PI;
        }
        return angle;
    }

    public static double getSmallestRotationAngleDeg(double angle) {
        if (Math.abs(angle %= 360.0) > 180.0) {
            angle -= Math.signum(angle) * 360.0;
        }
        return angle;
    }

    public static Point2D getMidPoint(Point2D ptA, Point2D ptB) {
        if (ptA != null && ptB != null) {
            return new Point2D.Double((ptA.getX() + ptB.getX()) / 2.0, (ptA.getY() + ptB.getY()) / 2.0);
        }
        return null;
    }

    public static Point2D getColinearPointWithLength(Point2D ptA, Point2D ptB, double newLength) {
        if (ptA != null && ptB != null) {
            return GeomUtil.getColinearPointWithRatio(ptA, ptB, newLength / ptA.distance(ptB));
        }
        return null;
    }

    public static Point2D getColinearPointWithRatio(Point2D ptA, Point2D ptB, double k) {
        if (ptA != null && ptB != null) {
            return new Point2D.Double(ptB.getX() * k + ptA.getX() * (1.0 - k), ptB.getY() * k + ptA.getY() * (1.0 - k));
        }
        return null;
    }

    public static Line2D getMedianLine(Line2D line1, Line2D line2) {
        Point2D.Double ptN;
        Point2D.Double ptM;
        Point2D ptD;
        Line2D.Double line4;
        if (line1 == null || line2 == null) {
            return null;
        }
        Point2D ptA = line1.getP1();
        Point2D ptB = line1.getP2();
        Point2D ptC = line2.getP1();
        Line2D.Double line3 = new Line2D.Double(ptA, ptC);
        if (line3.intersectsLine(line4 = new Line2D.Double(ptB, ptD = line2.getP2()))) {
            ptM = new Point2D.Double((ptA.getX() + ptD.getX()) / 2.0, (ptA.getY() + ptD.getY()) / 2.0);
            ptN = new Point2D.Double((ptB.getX() + ptC.getX()) / 2.0, (ptB.getY() + ptC.getY()) / 2.0);
        } else {
            ptM = new Point2D.Double((ptA.getX() + ptC.getX()) / 2.0, (ptA.getY() + ptC.getY()) / 2.0);
            ptN = new Point2D.Double((ptB.getX() + ptD.getX()) / 2.0, (ptB.getY() + ptD.getY()) / 2.0);
        }
        return new Line2D.Double(ptM, ptN);
    }

    public static Line2D getMedianLine(Point2D ptA, Point2D ptB, Point2D ptC, Point2D ptD) {
        if (ptA == null || ptB == null || ptC == null || ptD == null) {
            return null;
        }
        return GeomUtil.getMedianLine(new Line2D.Double(ptA, ptB), new Line2D.Double(ptC, ptD));
    }

    public static Point2D getIntersectPoint(Point2D ptA, Point2D ptB, Point2D ptC, Point2D ptD) {
        if (ptA == null || ptB == null || ptC == null || ptD == null) {
            return null;
        }
        Point2D.Double ptP = null;
        double denominator = (ptB.getX() - ptA.getX()) * (ptD.getY() - ptC.getY()) - (ptB.getY() - ptA.getY()) * (ptD.getX() - ptC.getX());
        if (denominator != 0.0) {
            double numerator = (ptA.getY() - ptC.getY()) * (ptD.getX() - ptC.getX()) - (ptA.getX() - ptC.getX()) * (ptD.getY() - ptC.getY());
            double r = numerator / denominator;
            ptP = new Point2D.Double(ptA.getX() + r * (ptB.getX() - ptA.getX()), ptA.getY() + r * (ptB.getY() - ptA.getY()));
        }
        return ptP;
    }

    public static Point2D getIntersectPoint(Line2D line1, Line2D line2) {
        if (line1 == null || line2 == null) {
            return null;
        }
        return GeomUtil.getIntersectPoint(line1.getP1(), line1.getP2(), line2.getP1(), line2.getP2());
    }

    public static boolean lineParallel(Point2D ptA, Point2D ptB, Point2D ptC, Point2D ptD) {
        if (ptA == null || ptB == null || ptC == null || ptD == null) {
            throw new IllegalArgumentException("All the points must not be null");
        }
        return (ptB.getX() - ptA.getX()) * (ptD.getY() - ptC.getY()) - (ptB.getY() - ptA.getY()) * (ptD.getX() - ptC.getX()) == 0.0;
    }

    public static boolean lineColinear(Point2D ptA, Point2D ptB, Point2D ptC, Point2D ptD) {
        return GeomUtil.lineParallel(ptA, ptB, ptC, ptD) && (ptA.getY() - ptC.getY()) * (ptD.getX() - ptC.getX()) - (ptA.getX() - ptC.getX()) * (ptD.getY() - ptC.getY()) == 0.0;
    }

    public static Point2D getPerpendicularPointToLine(Point2D ptA, Point2D ptB, Point2D ptC) {
        if (ptA == null || ptB == null || ptA.equals(ptB) || ptC == null) {
            return null;
        }
        double ax = ptA.getX();
        double ay = ptA.getY();
        double bx = ptB.getX();
        double by = ptB.getY();
        double cx = ptC.getX();
        double cy = ptC.getY();
        double r = ((ay - cy) * (ay - by) + (ax - cx) * (ax - bx)) / Point2D.distanceSq(ax, ay, bx, by);
        return new Point2D.Double(ax + r * (bx - ax), ay + r * (by - ay));
    }

    public static Point2D getPerpendicularPointToLine(Line2D line, Point2D ptC) {
        if (line == null || ptC == null) {
            return null;
        }
        return GeomUtil.getPerpendicularPointToLine(line.getP1(), line.getP2(), ptC);
    }

    public static Point2D getPerpendicularPointFromLine(Point2D ptA, Point2D ptB, Point2D ptP, double distPC) {
        if (ptA == null || ptB == null || ptA.equals(ptB) || ptP == null) {
            return null;
        }
        double distAB = ptA.distance(ptB);
        double ux = -(ptB.getY() - ptA.getY()) / distAB;
        double uy = (ptB.getX() - ptA.getX()) / distAB;
        return new Point2D.Double(ptP.getX() + distPC * ux, ptP.getY() + distPC * uy);
    }

    public static Point2D getPerpendicularPointFromLine(Point2D ptA, Point2D ptB, double distAP, double distPC) {
        return GeomUtil.getPerpendicularPointFromLine(ptA, ptB, GeomUtil.getColinearPointWithLength(ptA, ptB, distAP), distPC);
    }

    public static Line2D getParallelLine(Point2D ptA, Point2D ptB, double dist) {
        if (ptA == null || ptB == null || ptA.equals(ptB)) {
            return null;
        }
        double distAB2 = ptA.distanceSq(ptB);
        double ux = -(ptB.getY() - ptA.getY()) / distAB2;
        double uy = (ptB.getX() - ptA.getX()) / distAB2;
        Point2D.Double ptC = new Point2D.Double(ptA.getX() + dist * ux, ptA.getY() + dist * uy);
        Point2D.Double ptD = new Point2D.Double(ptB.getX() + dist * ux, ptB.getY() + dist * uy);
        return new Line2D.Double(ptC, ptD);
    }

    public static Point2D getCircleCenter(List<Point2D> ptList) {
        if (ptList == null) {
            return null;
        }
        switch (ptList.size()) {
            case 3: {
                return GeomUtil.getCircleCenter(ptList.get(0), ptList.get(1), ptList.get(2));
            }
            case 2: {
                return new Point2D.Double((ptList.get(0).getX() + ptList.get(1).getX()) / 2.0, (ptList.get(0).getY() + ptList.get(1).getY()) / 2.0);
            }
        }
        return null;
    }

    public static Point2D getCircleCenter(Point2D ptA, Point2D ptB, Point2D ptC) {
        if (ptA == null || ptB == null || ptC == null) {
            return null;
        }
        double ax = ptA.getX();
        double ay = ptA.getY();
        double bx = ptB.getX();
        double by = ptB.getY();
        double cx = ptC.getX();
        double cy = ptC.getY();
        double c1 = bx - ax;
        double c2 = by - ay;
        double c3 = cx - ax;
        double c4 = cy - ay;
        double c5 = c1 * (ax + bx) + c2 * (ay + by);
        double c6 = c3 * (ax + cx) + c4 * (ay + cy);
        double denom = 2.0 * (c1 * (cy - by) - c2 * (cx - bx));
        if (denom == 0.0) {
            return null;
        }
        double px = (c4 * c5 - c2 * c6) / denom;
        double py = (c1 * c6 - c3 * c5) / denom;
        return new Point2D.Double(px, py);
    }

    public static double extractScalingFactor(AffineTransform transform) {
        double scalingFactor = 1.0;
        if (transform != null) {
            double sx = transform.getScaleX();
            double shx = transform.getShearX();
            if (sx != 0.0 || shx != 0.0) {
                scalingFactor = Math.sqrt(sx * sx + shx * shx);
            }
        }
        return scalingFactor;
    }

    public static double extractAngleRad(AffineTransform transform) {
        double angleRad = 0.0;
        if (transform != null) {
            double sinTheta = transform.getShearY();
            double cosTheta = transform.getScaleX();
            angleRad = Math.atan2(sinTheta, cosTheta);
            if ((transform.getType() & 0x40) != 0) {
                angleRad *= -1.0;
            }
        }
        return angleRad;
    }

    public static Shape getScaledShape(Shape shape, double scalingFactor, Point2D anchorPoint) {
        if (shape == null || scalingFactor == 0.0) {
            return null;
        }
        AffineTransform scaleTransform = new AffineTransform();
        if (scalingFactor != 1.0) {
            if (anchorPoint != null) {
                scaleTransform.translate(anchorPoint.getX(), anchorPoint.getY());
            }
            scaleTransform.scale(scalingFactor, scalingFactor);
            if (anchorPoint != null) {
                scaleTransform.translate(-anchorPoint.getX(), -anchorPoint.getY());
            }
        }
        return scaleTransform.createTransformedShape(shape);
    }

    public static Rectangle2D getScaledRectangle(Rectangle2D rect, double scalingFactor) {
        Rectangle2D newRect = null;
        if (rect != null && scalingFactor != 1.0) {
            double resizedWidth = rect.getWidth() * scalingFactor;
            double resizedHeight = rect.getHeight() * scalingFactor;
            newRect = (Rectangle2D)rect.clone();
            newRect.setRect(rect.getX(), rect.getY(), resizedWidth, resizedHeight);
        }
        return newRect;
    }

    public static Shape getCornerShape(Point2D ptA, Point2D ptO, Point2D ptB, double cornerSize) {
        if (ptA == null || ptO == null || ptB == null || ptA.equals(ptO) || ptB.equals(ptO)) {
            return null;
        }
        Path2D.Double path = new Path2D.Double(1, 2);
        Point2D ptI1 = GeomUtil.getColinearPointWithLength(ptO, ptA, cornerSize);
        Point2D ptI2 = GeomUtil.getColinearPointWithLength(ptO, ptB, cornerSize);
        double rotSignum = Math.signum(GeomUtil.getSmallestRotationAngleDeg(GeomUtil.getAngleDeg(ptB, ptO, ptA)));
        Point2D ptI3 = GeomUtil.getPerpendicularPointFromLine(ptO, ptA, ptI1, rotSignum * cornerSize);
        path.append(new Line2D.Double(ptI1, ptI3), false);
        path.append(new Line2D.Double(ptI2, ptI3), false);
        return path;
    }

    public static Rectangle2D getGrowingRectangle(Rectangle2D rect, double growingSize) {
        Rectangle2D growingRect = rect != null ? (Rectangle2D)rect.clone() : null;
        GeomUtil.growRectangle(growingRect, growingSize);
        return growingRect;
    }

    public static void growRectangle(Rectangle2D rect, double growingSize) {
        if (rect == null) {
            return;
        }
        if (growingSize != 0.0) {
            double newX = rect.getX() - growingSize;
            double newY = rect.getY() - growingSize;
            double newWidth = rect.getWidth() + 2.0 * growingSize;
            double newHeight = rect.getHeight() + 2.0 * growingSize;
            rect.setRect(newX, newY, newWidth, newHeight);
        }
    }
}

