/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import com.sun.media.jai.codec.ImageCodec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileFormatFilter
extends FileFilter {
    private final Map fExtensions = new TreeMap();
    private String fDescription = null;
    private String fFullDescription = null;
    private String fDefaultExtension = null;
    private boolean fUseExtensionsInDescription = true;
    protected static Map sExtToCodec = new HashMap();

    public FileFormatFilter(String extension, String description) {
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public FileFormatFilter(String[] filters) {
        this(filters, null);
    }

    public FileFormatFilter(String[] filters, String description) {
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public String getDefaultExtension() {
        return this.fDefaultExtension;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.fExtensions.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        extension = extension.replace('*', ' ');
        extension = extension.replace('.', ' ');
        this.fExtensions.put(extension.trim().toLowerCase(), this);
        if (this.fDefaultExtension == null) {
            this.fDefaultExtension = extension;
        }
        this.fFullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fFullDescription == null) {
            if (this.fDescription == null || this.isExtensionListInDescription()) {
                this.fFullDescription = this.fDescription != null ? this.fDescription + " (" : "(";
                Set extensions = this.fExtensions.keySet();
                Iterator it = extensions.iterator();
                if (it.hasNext()) {
                    this.fFullDescription = this.fFullDescription + "*." + (String)it.next();
                }
                while (it.hasNext()) {
                    this.fFullDescription = this.fFullDescription + ", *." + (String)it.next();
                }
                this.fFullDescription = this.fFullDescription + ")";
            } else {
                this.fFullDescription = this.fDescription;
            }
        }
        return this.fFullDescription;
    }

    public void setDescription(String description) {
        this.fDescription = description;
        this.fFullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.fUseExtensionsInDescription = b;
        this.fFullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.fUseExtensionsInDescription;
    }

    public static void setImageDecodeFilters(JFileChooser chooser) {
        Enumeration codecs = ImageCodec.getCodecs();
        ArrayList<String> namesList = new ArrayList<String>(20);
        while (codecs.hasMoreElements()) {
            ImageCodec ic = (ImageCodec)codecs.nextElement();
            namesList.add(ic.getFormatName());
        }
        Collections.sort(namesList);
        Iterator it = namesList.iterator();
        String desc = "All supported files";
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            String name = (String)it.next();
            names.addElement(name);
            String altExt = FileFormatFilter.getAlternateExtension(name);
            if (altExt == null) continue;
            if (altExt.indexOf(",") != -1) {
                String[] tab = altExt.split(",");
                for (int i = 0; i < tab.length; ++i) {
                    names.addElement(tab[i]);
                }
                continue;
            }
            names.addElement(altExt);
        }
        String[] list = new String[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            list[i] = (String)names.elementAt(i);
        }
        FileFormatFilter allfilter = new FileFormatFilter(list, desc);
        allfilter.setFFullDescription(desc);
        chooser.addChoosableFileFilter(allfilter);
        for (String name : namesList) {
            desc = name.toUpperCase();
            FileFormatFilter filter = new FileFormatFilter(name, desc);
            String altExt = FileFormatFilter.getAlternateExtension(name);
            if (altExt != null) {
                if (altExt.indexOf(",") != -1) {
                    String[] tab = altExt.split(",");
                    for (int i = 0; i < tab.length; ++i) {
                        filter.addExtension(tab[i]);
                    }
                } else {
                    filter.addExtension(altExt);
                }
            }
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(allfilter);
    }

    public static void creatOneFilter(JFileChooser chooser, String name, String desc, boolean allfiles) {
        FileFormatFilter filter = new FileFormatFilter(name, desc);
        chooser.addChoosableFileFilter(filter);
        if (allfiles) {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        chooser.setFileFilter(filter);
    }

    public static synchronized void setTifFilters(JFileChooser chooser, boolean allfiles) {
        String name = "tif";
        String desc = "Tiled TIFF";
        FileFormatFilter.creatOneFilter(chooser, name, desc, allfiles);
    }

    public static synchronized void setJpgFilters(JFileChooser chooser, boolean allfiles) {
        String name = "jpg";
        String desc = "JPEG";
        FileFormatFilter.creatOneFilter(chooser, name, desc, allfiles);
    }

    public static synchronized void setPngFilters(JFileChooser chooser, boolean allfiles) {
        String name = "png";
        String desc = "PNG";
        FileFormatFilter.creatOneFilter(chooser, name, desc, allfiles);
    }

    public static String getAlternateExtension(String codecName) {
        Set maps = sExtToCodec.entrySet();
        for (Map.Entry entry : maps) {
            String value = (String)entry.getValue();
            if (!value.equals(codecName)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void setFFullDescription(String fFullDescription) {
        this.fFullDescription = fFullDescription;
    }

    static {
        sExtToCodec.put("jpg,jpe", "jpeg");
        sExtToCodec.put("tif", "tiff");
        sExtToCodec.put("pbm,ppm,pgm", "pnm");
    }
}

