/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.weasis.core.api.gui.util.DropDownButton;

public class DropButtonIcon
implements Icon {
    private Icon leftIcon;

    public DropButtonIcon(Icon leftIcon) {
        this.leftIcon = leftIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        this.leftIcon.paintIcon(c, g2d, x, y);
        if (c instanceof DropDownButton) {
            ButtonModel model = ((DropDownButton)c).getModel();
            if (model.isRollover() && !model.isPressed()) {
                g2d.setPaint(UIManager.getColor("controlShadow"));
            } else {
                g2d.setPaint(UIManager.getColor("controlHighlight"));
            }
        }
        int shiftx = x + this.leftIcon.getIconWidth() + 1;
        int shifty = y + this.leftIcon.getIconHeight() - 5;
        int[] xPoints = new int[]{shiftx, shiftx + 8, shiftx + 4};
        int[] yPoints = new int[]{shifty, shifty, shifty + 4};
        g2d.fillPolygon(xPoints, yPoints, xPoints.length);
    }

    @Override
    public int getIconWidth() {
        return this.leftIcon.getIconWidth() + 10;
    }

    @Override
    public int getIconHeight() {
        return this.leftIcon.getIconHeight();
    }
}

