/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboBoxModelAdapter;
import org.weasis.core.api.gui.util.GroupRadioMenu;
import org.weasis.core.api.gui.util.JToogleButtonGroup;

public abstract class ComboItemListener
implements ListDataListener,
ChangeListener,
ActionState {
    protected final ActionW action;
    protected final ArrayList<ComboBoxModelAdapter> itemList;
    protected final DefaultComboBoxModel model;
    private boolean enable;

    public ComboItemListener(ActionW action, Object[] objects) {
        this.action = action;
        this.enable = true;
        this.itemList = new ArrayList();
        this.model = new DefaultComboBoxModel<Object>(objects);
        this.model.addListDataListener(this);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.itemStateChanged(this.model.getSelectedItem());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
    }

    @Override
    public void enableAction(boolean enabled) {
        this.enable = enabled;
        for (ComboBoxModelAdapter c : this.itemList) {
            c.setEnabled(enabled);
        }
    }

    public String toString() {
        return this.action.getTitle();
    }

    @Override
    public ActionW getActionW() {
        return this.action;
    }

    public abstract void itemStateChanged(Object var1);

    public void registerComponent(ComboBoxModelAdapter component) {
        if (!this.itemList.contains(component)) {
            this.itemList.add(component);
            component.setModel(this.model);
            component.setEnabled(this.enable);
        }
    }

    public void unregisterJComponent(ComboBoxModelAdapter component) {
        this.itemList.remove(component);
        component.setModel(new DefaultComboBoxModel());
    }

    public synchronized Object[] getAllItem() {
        Object[] array = new Object[this.model.getSize()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.model.getElementAt(i);
        }
        return array;
    }

    public synchronized Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public synchronized void setSelectedItem(Object object) {
        this.model.setSelectedItem(object);
    }

    public synchronized void setSelectedItemWithoutTriggerAction(Object object) {
        this.model.removeListDataListener(this);
        this.model.setSelectedItem(object);
        this.model.addListDataListener(this);
    }

    public synchronized void setDataList(Object[] objects) {
        if (objects != null && objects.length > 0) {
            Object oldSelection = this.model.getSelectedItem();
            this.model.removeListDataListener(this);
            this.model.removeAllElements();
            boolean oldSelectionStillExist = false;
            for (Object object : objects) {
                this.model.addElement(object);
                if (object != oldSelection) continue;
                oldSelectionStillExist = true;
            }
            for (ComboBoxModelAdapter c : this.itemList) {
                c.setModel(this.model);
            }
            this.model.addListDataListener(this);
            if (oldSelection != null && oldSelectionStillExist) {
                this.model.setSelectedItem(oldSelection);
            } else if (objects[0] == this.model.getSelectedItem()) {
                this.itemStateChanged(this.model.getSelectedItem());
            } else {
                this.model.setSelectedItem(objects[0]);
            }
        }
    }

    public JMenu createUnregisteredRadioMenu(String title) {
        GroupRadioMenu radioMenu = new GroupRadioMenu();
        radioMenu.setModel(this.model);
        JMenu menu = radioMenu.createMenu(title);
        if (!this.enable) {
            menu.setEnabled(false);
        }
        return menu;
    }

    public ArrayList<ComboBoxModelAdapter> getItemList() {
        return this.itemList;
    }

    public DefaultComboBoxModel getModel() {
        return this.model;
    }

    public JToogleButtonGroup createButtonGroup() {
        JToogleButtonGroup group = new JToogleButtonGroup();
        this.registerComponent(group);
        return group;
    }

    public JComboBox createCombo() {
        ComboItems combo = new ComboItems();
        this.registerComponent(combo);
        return combo;
    }

    public JMenu createMenu(String title) {
        JMenu menu = new JMenu(title);
        GroupRadioMenu radioMenu = new GroupRadioMenu();
        radioMenu.setModel(this.model);
        radioMenu.fillMenu(menu);
        return menu;
    }

    public GroupRadioMenu createGroupRadioMenu() {
        GroupRadioMenu radioMenu = new GroupRadioMenu();
        this.registerComponent(radioMenu);
        return radioMenu;
    }

    static class ComboItems
    extends JComboBox
    implements ComboBoxModelAdapter {
        ComboItems() {
        }
    }
}

