/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Color;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.weasis.core.api.gui.util.GhostGlassPane;
import org.weasis.core.api.util.FileUtil;

public abstract class AbstractProperties {
    public static final String WEASIS_VERSION;
    public static final String WEASIS_PATH;
    public static final File APP_TEMP_DIR;
    public static final String OPERATING_SYSTEM;
    public static final char[] hexDigits;
    protected static Properties s_prop;
    public static final GhostGlassPane glassPane;

    protected static String checkProperty(String key, String defaultValue) {
        String result = null;
        result = s_prop.getProperty(key, defaultValue);
        s_prop.setProperty(key, result);
        return result;
    }

    public static boolean isMacNativeLookAndFeel() {
        LookAndFeel laf;
        return OPERATING_SYSTEM.startsWith("mac") && (laf = UIManager.getLookAndFeel()) != null && laf.isNativeLookAndFeel();
    }

    public static void setProperty(String key, String value) {
        if (s_prop == null) {
            s_prop = new Properties();
        }
        s_prop.setProperty(key, value);
    }

    public static void setProperty(String key, boolean[] value) {
        AbstractProperties.setProperty(key, AbstractProperties.boolToText(value));
    }

    public static void setProperty(String key, Locale value) {
        AbstractProperties.setProperty(key, AbstractProperties.localeToText(value));
    }

    public static void setProperty(String key, boolean value) {
        AbstractProperties.setProperty(key, value ? "Y" : "N");
    }

    public static void setProperty(String key, int value) {
        AbstractProperties.setProperty(key, String.valueOf(value));
    }

    public static void setProperty(String key, double value) {
        AbstractProperties.setProperty(key, String.valueOf(value));
    }

    public static void setProperty(String key, float value) {
        AbstractProperties.setProperty(key, String.valueOf(value));
    }

    public static void setProperty(String key, Color c) {
        AbstractProperties.setProperty(key, AbstractProperties.c2hex(c));
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        if (retStr == null || retStr.length() == 0) {
            return "";
        }
        return retStr;
    }

    public static boolean getPropertyBool(String key) {
        return AbstractProperties.getProperty(key).equals("Y");
    }

    public static boolean[] getPropertyArrayBool(String key, int length) {
        boolean[] val = new boolean[length];
        if (key == null) {
            return val;
        }
        String retStr = s_prop.getProperty(key);
        if (retStr == null || retStr.length() == 0) {
            return val;
        }
        char[] c = retStr.toCharArray();
        if (c.length != val.length) {
            return val;
        }
        for (int i = 0; i < c.length; ++i) {
            val[i] = String.valueOf(c[i]).equalsIgnoreCase("Y");
        }
        return val;
    }

    public static Locale getPropertyLocale(String key) {
        if (key == null) {
            return Locale.ENGLISH;
        }
        String retStr = s_prop.getProperty(key);
        if (retStr == null || retStr.length() == 0) {
            return Locale.ENGLISH;
        }
        char[] c = retStr.toCharArray();
        String[] val = new String[3];
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '_') {
                val[k] = buffer.toString();
                buffer = new StringBuffer();
                ++k;
                continue;
            }
            buffer.append(c[i]);
        }
        return new Locale(val[0], val[1], val[2]);
    }

    public static int getPropertyInt(String key) {
        if (key == null) {
            return 1;
        }
        String retStr = s_prop.getProperty(key);
        if (retStr == null || retStr.length() == 0) {
            return 1;
        }
        try {
            return Integer.parseInt(retStr);
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    public static double getPropertyDouble(String key) {
        if (key == null) {
            return 1.0;
        }
        String retStr = s_prop.getProperty(key);
        if (retStr == null || retStr.length() == 0) {
            return 1.0;
        }
        try {
            return Double.parseDouble(retStr);
        }
        catch (NumberFormatException ex) {
            return 1.0;
        }
    }

    public static float getPropertyFloat(String key) {
        if (key == null) {
            return 1.0f;
        }
        String retStr = s_prop.getProperty(key);
        if (retStr == null || retStr.length() == 0) {
            return 1.0f;
        }
        try {
            return Float.parseFloat(retStr);
        }
        catch (NumberFormatException ex) {
            return 1.0f;
        }
    }

    public static Color getPropertyColor(String key) {
        int i = AbstractProperties.getInt(key, 2730);
        if (i == 2730) {
            return new Color(128, 128, 128);
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    protected static int getInt(String key, int defaultValue) {
        String s = s_prop.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected static String c2hex(Color c) {
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }

    protected static String boolToText(boolean[] value) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            str.append(value[i] ? (char)'Y' : 'N');
        }
        return str.toString();
    }

    protected static String localeToText(Locale value) {
        return value.getLanguage() + "_" + value.getCountry() + "_" + value.getVariant() + "_";
    }

    protected static String boolToText(boolean value) {
        return value ? "Y" : "N";
    }

    public static Properties getProperties() {
        return s_prop;
    }

    public static boolean isThumbnailSortDesend() {
        return true;
    }

    static {
        File tdir;
        WEASIS_VERSION = System.getProperty("weasis.version");
        WEASIS_PATH = System.getProperty("weasis.path");
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            String dir = System.getProperty("user.home");
            if (dir == null) {
                dir = "";
            }
            tdir = new File(dir);
        } else {
            tdir = new File(tempDir);
        }
        APP_TEMP_DIR = new File(tdir, "weasis");
        try {
            FileUtil.deleteDirectoryContents(APP_TEMP_DIR);
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            APP_TEMP_DIR.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATING_SYSTEM = System.getProperty("os.name", "unknown").toLowerCase();
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        s_prop = new Properties();
        glassPane = new GhostGlassPane();
    }
}

