/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.task;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import org.weasis.core.api.gui.util.AnimatedIconStatic;
import org.weasis.core.api.gui.util.ImageSectionIcon;
import org.weasis.core.api.util.FontTools;

public class CircularProgressBar
extends JProgressBar {
    private static final Color BACK_COLOR = new Color(82, 152, 219);
    public static final ImageIcon ICON = new ImageIcon(CircularProgressBar.class.getResource("/icon/22x22/process-working.png"));
    private volatile Animate animateThread;

    public CircularProgressBar() {
        this.init();
    }

    public CircularProgressBar(int min, int max) {
        super(min, max);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setSize(30, 30);
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            if (this.isIndeterminate()) {
                this.drawInderminate((Graphics2D)g);
            } else {
                this.draw((Graphics2D)g);
            }
        }
    }

    private void drawInderminate(Graphics2D g) {
        if (this.animateThread != null) {
            this.animateThread.paintIcon(this, g);
        }
    }

    private void draw(Graphics2D g2) {
        int h = this.getHeight();
        int w = this.getWidth();
        int range = this.getMaximum() - this.getMinimum();
        if (range < 1) {
            range = 1;
        }
        int a = 360 - this.getValue() * 360 / range;
        String str = this.getValue() * 100 / range + "%";
        float x = (float)w / 2.0f - (float)g2.getFontMetrics().stringWidth(str) / 2.0f;
        float fontHeight = FontTools.getAccurateFontHeight(g2);
        float midfontHeight = fontHeight * FontTools.getMidFontHeightFactor();
        float y = (float)h / 2.0f + midfontHeight;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.WHITE);
        g2.fillArc(0, 0, w, h, 0, 360);
        g2.setPaint(BACK_COLOR);
        g2.fillArc(0, 0, w, h, a, 360 - a);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2.setPaint(Color.BLACK);
        g2.drawString(str, x, y);
    }

    @Override
    public synchronized void setIndeterminate(boolean newValue) {
        if (newValue != this.isIndeterminate()) {
            if (this.animateThread != null) {
                this.stopIndeterminate();
            }
            if (newValue && this.animateThread == null) {
                this.animateThread = new Animate(50L);
                this.animateThread.start();
            }
            super.setIndeterminate(newValue);
        }
    }

    public synchronized void stopIndeterminate() {
        Animate moribund = this.animateThread;
        this.animateThread = null;
        if (moribund != null) {
            moribund.interrupt();
        }
    }

    protected void finalize() throws Throwable {
        if (this.animateThread != null) {
            this.animateThread.interrupt();
        }
    }

    protected class Animate
    extends Thread {
        private final AnimatedIconStatic indeterminateIcon;
        private final long refresh;

        public Animate(long refresh) {
            super.setDaemon(true);
            this.refresh = refresh;
            this.indeterminateIcon = new ImageSectionIcon(ICON, 22, 22, 0, 32);
        }

        public void paintIcon(CircularProgressBar circularProgressBar, Graphics2D g) {
            int h = circularProgressBar.getHeight();
            int w = circularProgressBar.getWidth();
            int x = (w - this.indeterminateIcon.getIconWidth()) / 2;
            int y = (h - this.indeterminateIcon.getIconHeight()) / 2;
            g.setPaint(Color.WHITE);
            g.fillRect(x, y, this.indeterminateIcon.getIconWidth(), this.indeterminateIcon.getIconHeight());
            this.indeterminateIcon.paintIcon(circularProgressBar, g, x, y);
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                this.indeterminateIcon.animate();
                CircularProgressBar.this.repaint();
                try {
                    Thread.sleep(this.refresh);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }
}

