/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.display;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.Messages;

public class PresetWindowLevel {
    public static final PresetWindowLevel CUSTOM = new PresetWindowLevel(Messages.getString("PresetWindowLevel.custom"), Messages.getString("PresetWindowLevel.all"), 0.0f, 0.0f);
    public static final PresetWindowLevel DEFAULT = new PresetWindowLevel(Messages.getString("PresetWindowLevel.default"), Messages.getString("PresetWindowLevel.all"), 0.0f, 0.0f);
    public static final PresetWindowLevel AUTO = new PresetWindowLevel(Messages.getString("PresetWindowLevel.full"), Messages.getString("PresetWindowLevel.all"), 0.0f, 0.0f);
    private static final ArrayList<PresetWindowLevel> presets = PresetWindowLevel.getPresetCollection();
    private final String name;
    private final String modality;
    private final float window;
    private final float level;

    public PresetWindowLevel(String name, String modality, float window, float level) {
        this.name = name;
        this.modality = modality;
        this.window = window;
        this.level = level;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getModality() {
        return this.modality;
    }

    public float getWindow() {
        return this.window;
    }

    public float getLevel() {
        return this.level;
    }

    public static PresetWindowLevel[] getPresetCollection(String modality) {
        ArrayList<PresetWindowLevel> mpresets = new ArrayList<PresetWindowLevel>();
        mpresets.add(CUSTOM);
        mpresets.add(DEFAULT);
        mpresets.add(AUTO);
        for (int i = 3; i < presets.size(); ++i) {
            if (!PresetWindowLevel.presets.get((int)i).modality.equals(modality)) continue;
            mpresets.add(presets.get(i));
        }
        return mpresets.toArray(new PresetWindowLevel[mpresets.size()]);
    }

    private static ArrayList<PresetWindowLevel> getPresetCollection() {
        ArrayList<PresetWindowLevel> presets = new ArrayList<PresetWindowLevel>();
        presets.add(CUSTOM);
        presets.add(DEFAULT);
        presets.add(AUTO);
        PresetWindowLevel.readPresets(presets);
        return presets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readPresets(ArrayList<PresetWindowLevel> presets) {
        block13: {
            XMLStreamReader xmler = null;
            InputStream stream = null;
            try {
                XMLInputFactory xmlif = XMLInputFactory.newInstance();
                stream = PresetWindowLevel.class.getResourceAsStream("/config/presets.xml");
                xmler = xmlif.createXMLStreamReader(stream);
                while (xmler.hasNext()) {
                    int eventType = xmler.next();
                    switch (eventType) {
                        case 1: {
                            String key = xmler.getName().getLocalPart();
                            if (!"presets".equals(key)) break;
                            block12: while (xmler.hasNext()) {
                                eventType = xmler.next();
                                switch (eventType) {
                                    case 1: {
                                        key = xmler.getName().getLocalPart();
                                        if (!"preset".equals(key) || xmler.getAttributeCount() != 4) continue block12;
                                        presets.add(new PresetWindowLevel(xmler.getAttributeValue(null, "name"), xmler.getAttributeValue(null, "modality"), Float.parseFloat(xmler.getAttributeValue(null, "window")), Float.parseFloat(xmler.getAttributeValue(null, "level"))));
                                        continue block12;
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
                FileUtil.safeClose((XMLStreamReader)xmler);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                break block13;
            }
            finally {
                FileUtil.safeClose(xmler);
                FileUtil.safeClose((Closeable)stream);
            }
            FileUtil.safeClose((Closeable)stream);
        }
    }
}

