/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.display;

import org.weasis.dicom.codec.Messages;

public enum Modality {
    ImageModality(Messages.getString("Modality.by_modality")),
    Default(Messages.getString("Modality.default")),
    CR("Computed Radiography"),
    CT("Computed Tomography"),
    DX("Digital Radiography"),
    ES("Endoscopy"),
    MG("Mammography"),
    MR("Magnetic Resonance"),
    NM("Nuclear Medicine"),
    OT("Other"),
    PR("Presentation State"),
    PX("Panoramic X-Ray"),
    PT("Positron emission tomography (PET)"),
    RF("Radio Fluoroscopy"),
    US("Ultrasound"),
    SC("Secondary Capture"),
    XA("X-Ray Angiography"),
    XC("External-camera Photography");

    private final String description;

    private Modality(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static Modality getModality(String modality) {
        Modality v = Default;
        if (modality != null) {
            try {
                v = Modality.valueOf(modality);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }
}

