/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.display;

import java.io.File;
import java.util.List;
import java.util.Scanner;
import org.weasis.core.api.image.op.ByteLut;
import org.weasis.core.api.image.op.ByteLutCollection;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.internal.Activator;

public class LutManager {
    public static final String LUT_DIR = "luts";

    public static ByteLut[] getLutCollection() {
        List luts = ByteLutCollection.getLutCollection();
        LutManager.readLutFiles(luts);
        LutManager.readLutFilesFromConfigDir(luts);
        return luts.toArray(new ByteLut[luts.size()]);
    }

    public static void readLutFiles(List<ByteLut> luts) {
        String[] files = new String[]{"BlackBody.txt", "Cardiac.txt", "Flow.txt", "GEcolor.txt", "GrayRainbow.txt", "Hue1.txt", "Hue2.txt", "Stern.txt", "Ucla.txt", "VR Bones.txt"};
        for (int i = 0; i < files.length; ++i) {
            try {
                byte[][] lut = LutManager.readLutFile(new Scanner(LutManager.class.getResourceAsStream("/config/luts/" + files[i]), "UTF-8"));
                luts.add(new ByteLut(FileUtil.nameWithoutExtension((String)files[i]), lut, ByteLutCollection.invert((byte[][])lut)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void readLutFilesFromConfigDir(List<ByteLut> luts) {
        File lutFolder = new File(Activator.PREFERENCES.getDataFolder(), LUT_DIR);
        if (lutFolder.exists() && lutFolder.isDirectory()) {
            File[] files = lutFolder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].canRead()) continue;
                try {
                    byte[][] lut = LutManager.readLutFile(new Scanner(files[i], "UTF-8"));
                    luts.add(new ByteLut(FileUtil.nameWithoutExtension((String)files[i].getName()), lut, ByteLutCollection.invert((byte[][])lut)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[][] readLutFile(Scanner scan) throws Exception {
        byte[][] lut = new byte[3][256];
        for (int lineIndex = 0; scan.hasNext() && lineIndex < 256; ++lineIndex) {
            String[] line = scan.nextLine().split("\t");
            if (line.length != 3) continue;
            lut[0][lineIndex] = (byte)Integer.parseInt(line[0]);
            lut[1][lineIndex] = (byte)Integer.parseInt(line[1]);
            lut[2][lineIndex] = (byte)Integer.parseInt(line[2]);
        }
        return lut;
    }
}

