/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.display;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.VOIUtils;

public class DicomLut {
    public static final String LINEAR = "LINEAR";
    public static final String SIGMOID = "SIGMOID";
    private boolean autoWindowing = true;
    private float center;
    private float width;
    private String vlutFct;
    private DicomObject voiLut;
    private DicomObject prState;
    private short[] pval2gray;
    String overlayRGB = null;

    public void createLut(DicomObject img, int frame) {
        DicomObject voiLut;
        DicomObject mlutObj = VOIUtils.selectModalityLUTObject(img, null, frame);
        DicomObject voiObj = VOIUtils.selectVoiObject(img, null, frame);
        boolean inverse = DicomLut.isInverse(img);
        int stored = img.getInt(2621697, img.getInt(2621696, 8));
        boolean signed = img.getInt(2621699) != 0;
        float slope = mlutObj.getFloat(2625619, 1.0f);
        float intercept = mlutObj.getFloat(2625618, 0.0f);
        DicomObject mLut = mlutObj.getNestedDicomObject(2633728);
        DicomObject dicomObject = voiLut = voiObj != null ? voiObj.getNestedDicomObject(2633744) : null;
        if (voiLut == null && voiObj != null) {
            this.vlutFct = voiObj.getString(2625622);
            this.center = voiObj.getFloat(2625616, 0.0f);
            this.width = voiObj.getFloat(2625617, 0.0f);
        }
    }

    private static boolean isInverse(DicomObject img) {
        String shape = img.getString(0x20500020);
        return shape != null ? "INVERSE".equals(shape) : "MONOCHROME1".equals(img.getString(2621444));
    }

    private static byte[][] createSigmoidLut(int inBits, float slope, float intercept, float center, float width, boolean inverse) {
        int size = 256;
        int outMax = size - 1;
        float ic = (center - intercept) / slope;
        float k = -4.0f * slope / width;
        byte[][] data = new byte[1][size];
        for (int i = 0; i < size; ++i) {
            int tmp = (int)((double)size / (1.0 + Math.exp(((float)i - ic) * k)));
            if (inverse) {
                tmp = outMax - tmp;
            }
            data[0][i] = (byte)tmp;
        }
        return data;
    }
}

