/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

public enum TransferSyntax {
    NONE(null, "None", null),
    EXPLICIT_VR_LE("1.2.840.10008.1.2.1", "Explicit VR Little Endian", null),
    RLE("1.2.840.10008.1.2.5", "RLE Lossless", null),
    JPEG_LOSSY_8("1.2.840.10008.1.2.4.50", "JPEG Lossy (8 bits)", 75),
    JPEG_LOSSY_12("1.2.840.10008.1.2.4.51", "JPEG Lossy (12 bits)", 75),
    JPEG_LOSSLESS_57("1.2.840.10008.1.2.4.57", "JPEG Lossless", null),
    JPEG_LOSSLESS_70("1.2.840.10008.1.2.4.70", "JPEG Lossless", null),
    JPEGLS_LOSSLESS("1.2.840.10008.1.2.4.80", "JPEG-LS Lossless", null),
    JPEGLS_NEAR_LOSSLESS("1.2.840.10008.1.2.4.81", "JPEG-LS Lossy (Near-Lossless)", null),
    JPEG2000_LOSSLESS("1.2.840.10008.1.2.4.90", "JPEG 2000 (Lossless Only)", null),
    JPEG2000("1.2.840.10008.1.2.4.91", "JPEG 2000", 75);

    private final String label;
    private final String transferSyntaxUID;
    private Integer compression;

    private TransferSyntax(String transferSyntaxUID, String label, Integer compression) {
        this.label = label;
        this.transferSyntaxUID = transferSyntaxUID;
        this.compression = compression;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public String toString() {
        if (this.transferSyntaxUID == null) {
            return this.label;
        }
        return this.label + " [" + this.transferSyntaxUID + "]";
    }

    public Integer getCompression() {
        return this.compression;
    }

    public void setCompression(Integer compression) {
        this.compression = compression;
    }

    public static TransferSyntax getTransferSyntax(String tsuid) {
        try {
            return TransferSyntax.valueOf(tsuid);
        }
        catch (Exception exception) {
            return NONE;
        }
    }
}

