/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.dcm4che2.data.DicomObject;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.DicomEncapDocElement;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.FileExtractor;
import org.weasis.dicom.codec.Messages;

public class DicomEncapDocSeries
extends Series<DicomEncapDocElement>
implements FileExtractor {
    public DicomEncapDocSeries(String subseriesInstanceUID) {
        super(TagW.SubseriesInstanceUID, (Object)subseriesInstanceUID, TagW.SubseriesInstanceUID);
    }

    public DicomEncapDocSeries(DicomSeries dicomSeries) {
        super(TagW.SubseriesInstanceUID, dicomSeries.getTagValue(TagW.SubseriesInstanceUID), TagW.SubseriesInstanceUID);
        Iterator iter = dicomSeries.getTagEntrySetIterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            this.setTag((TagW)e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(MediaElement media) {
        if (media instanceof DicomEncapDocElement && media.getMediaReader() instanceof DicomMediaIO) {
            DicomMediaIO dicomImageLoader = (DicomMediaIO)media.getMediaReader();
            byte[] doc = null;
            String extension = "tmp";
            try {
                DicomObject dicom = dicomImageLoader.getDicomObject();
                String mime = dicom.getString(4325394);
                String[] extensions = MimeInspector.getExtensions((String)mime);
                if (extensions.length > 0) {
                    extension = extensions[0];
                }
                doc = dicom.getBytes(4325393);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (doc != null) {
                BufferedOutputStream tempFileStream = null;
                try {
                    File file = File.createTempFile("encap_", "." + extension, AbstractProperties.APP_TEMP_DIR);
                    tempFileStream = new BufferedOutputStream(new FileOutputStream(file));
                    ((OutputStream)tempFileStream).write(doc);
                    DicomEncapDocElement dicom = (DicomEncapDocElement)media;
                    dicom.setDocument(file);
                    this.medias.add(dicom);
                    FileUtil.safeClose((Closeable)tempFileStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    FileUtil.safeClose(tempFileStream);
                }
            }
        }
    }

    public String getToolTips() {
        StringBuffer toolTips = new StringBuffer();
        toolTips.append("<html>");
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.pat"), TagW.PatientName);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.mod"), TagW.Modality);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series_nb"), TagW.SeriesNumber);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.study"), TagW.StudyDescription);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series"), TagW.SeriesDescription);
        toolTips.append(Messages.getString("DicomSeries.date") + this.getDate() + "<br>");
        toolTips.append("</html>");
        return toolTips.toString();
    }

    public String toString() {
        return (String)this.getTagValue(TagW.SubseriesInstanceUID);
    }

    public String getDate() {
        Date seriesDate = (Date)this.getTagValue(TagW.SeriesDate);
        if (seriesDate != null) {
            return new SimpleDateFormat("dd/MM/yyyy").format(seriesDate);
        }
        return "";
    }

    public String getMimeType() {
        return "encap/dicom";
    }

    @Override
    public File getExtractFile() {
        DicomEncapDocElement media = (DicomEncapDocElement)this.getMedia(MediaSeries.MEDIA_POSITION.FIRST);
        if (media != null) {
            return media.getDocument();
        }
        return null;
    }
}

