/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.net.URI;
import java.util.Hashtable;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.dicom.codec.DicomMediaIO;

public class DicomCodec
implements Codec {
    public static final String NAME = "dcm4che 2.0.24 (modified)";

    public String[] getReaderMIMETypes() {
        return new String[]{"application/dicom", "xds-i/dicom", "image/dicom", "video/dicom", "encap/dicom"};
    }

    public String[] getReaderExtensions() {
        return MimeInspector.getExtensions((String)"application/dicom");
    }

    public boolean isMimeTypeSupported(String mimeType) {
        if (mimeType != null) {
            for (String mime : this.getReaderMIMETypes()) {
                if (!mimeType.equals(mime)) continue;
                return true;
            }
        }
        return false;
    }

    public MediaReader getMediaIO(URI media, String mimeType, Hashtable<String, Object> properties) {
        if (this.isMimeTypeSupported(mimeType)) {
            return new DicomMediaIO(media);
        }
        return null;
    }

    public String getCodecName() {
        return NAME;
    }

    public String[] getWriterExtensions() {
        return null;
    }

    public String[] getWriterMIMETypes() {
        return null;
    }
}

