/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.rle;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RLEImageReader
extends ImageReader {
    private static final Logger log = LoggerFactory.getLogger(RLEImageReader.class);
    private final int[] header = new int[16];
    private final byte[] buf = new byte[8192];
    private long headerPos;
    private long bufOff;
    private int bufPos;
    private int bufLen;
    private ImageInputStream iis;
    private int width = -1;
    private int height = -1;
    private ColorModel colorModel;
    private boolean convertSpace = false;
    private int curSeg;
    private int nSegs;
    private long segEnd;

    public RLEImageReader(ImageReaderSpi originator) {
        super(originator);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (ImageInputStream)input;
    }

    @Override
    public int getHeight(int imageIndex) {
        return this.height;
    }

    @Override
    public int getWidth(int imageIndex) {
        return this.width;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("Input not set");
        }
        BufferedImage bi = this.getReadImage(param);
        this.readRLEHeader();
        this.nSegs = this.header[0];
        this.checkDestination(this.nSegs, bi);
        WritableRaster raster = bi.getRaster();
        DataBuffer db = raster.getDataBuffer();
        if (db instanceof DataBufferByte) {
            DataBufferByte dbb = (DataBufferByte)db;
            byte[][] bankData = dbb.getBankData();
            ComponentSampleModel sm = (ComponentSampleModel)bi.getSampleModel();
            int[] bankIndices = sm.getBankIndices();
            int[] bandOffsets = sm.getBandOffsets();
            int pixelStride = sm.getPixelStride();
            for (int i = 0; i < this.nSegs; ++i) {
                this.seekSegment(i + 1);
                this.unrle(bankData[bankIndices[i]], bandOffsets[i], pixelStride);
            }
        } else {
            short[] ss = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
            this.seekSegment(1);
            this.unrle(ss, 8);
            this.seekSegment(2);
            this.unrle(ss, 0);
        }
        this.seekInputToEndOfRLEData();
        BufferedImage retImage = this.getDestination(param, bi);
        if (retImage == bi) {
            log.debug("Returning raw, unconverted image.");
            return retImage;
        }
        if (retImage.getColorModel().getNumComponents() == 3) {
            this.convertColorSpaceToRGB(param, bi, retImage);
        } else {
            this.copyGrayRegion(param, bi, retImage);
        }
        return retImage;
    }

    private void copyGrayRegion(ImageReadParam param, BufferedImage src, BufferedImage dest) {
        Rectangle region = param.getSourceRegion();
        int w = this.width;
        int h = this.height;
        int x = 0;
        int y = 0;
        if (region != null) {
            w = (int)region.getWidth();
            h = (int)region.getHeight();
            x = (int)region.getX();
            y = (int)region.getY();
        }
        int sampleX = param.getSourceXSubsampling();
        int sampleY = param.getSourceYSubsampling();
        int srcX = param.getSubsamplingXOffset() + x;
        int srcY = param.getSubsamplingYOffset() + y;
        int srcW = Math.min(w, this.width - srcX);
        int srcH = Math.min(h, this.height - srcY);
        int destW = srcW / sampleX;
        int destH = srcH / sampleY;
        int[] pixel = null;
        SampleModel srcSm = src.getSampleModel();
        DataBuffer srcDb = src.getRaster().getDataBuffer();
        SampleModel destSm = dest.getSampleModel();
        DataBuffer destDb = dest.getRaster().getDataBuffer();
        for (int iy = 0; iy < destH; ++iy) {
            for (int ix = 0; ix < destW; ++ix) {
                pixel = srcSm.getPixel(ix * sampleX + srcX, iy * sampleY + srcY, pixel, srcDb);
                destSm.setPixel(ix, iy, pixel, destDb);
            }
        }
    }

    private void convertColorSpaceToRGB(ImageReadParam param, BufferedImage src, BufferedImage dest) {
        int[] srcRgb;
        Rectangle region = param.getSourceRegion();
        int w = this.width;
        int h = this.height;
        int x = 0;
        int y = 0;
        if (region != null) {
            w = (int)region.getWidth();
            h = (int)region.getHeight();
            x = (int)region.getX();
            y = (int)region.getY();
        }
        int sampleX = param.getSourceXSubsampling();
        int sampleY = param.getSourceYSubsampling();
        int srcX = param.getSubsamplingXOffset() + x;
        int srcY = param.getSubsamplingYOffset() + y;
        int srcW = Math.min(w, this.width - srcX);
        int srcH = Math.min(h, this.height - srcY);
        int destW = srcW / sampleX;
        int[] destRgb = srcRgb = new int[srcW];
        if (srcW != destW) {
            destRgb = new int[destW];
        }
        int destH = srcH / sampleY;
        log.debug("Converting image " + src.getColorModel().getColorSpace() + " to " + dest.getColorModel().getColorSpace());
        for (int iy = 0; iy < destH; ++iy) {
            src.getRGB(srcX, iy * sampleY + srcY, srcW, 1, srcRgb, 0, this.width);
            if (srcRgb != destRgb) {
                for (int ix = 0; ix < destW; ++ix) {
                    destRgb[ix] = srcRgb[ix * sampleX];
                }
            }
            dest.setRGB(0, iy, destW, 1, destRgb, 0, this.width);
        }
    }

    private BufferedImage getReadImage(ImageReadParam param) {
        BufferedImage bi = param.getDestination();
        ImageTypeSpecifier imageType = param.getDestinationType();
        if (bi == null && imageType == null) {
            throw new IllegalArgumentException("RLE Image Reader needs set ImageReadParam.destination or an ImageTypeSpecifier");
        }
        if (imageType == null) {
            return bi;
        }
        this.width = imageType.getSampleModel().getWidth();
        this.height = imageType.getSampleModel().getHeight();
        this.colorModel = imageType.getColorModel();
        this.convertSpace = this.colorModel.getColorSpace().getType() == 3 && (bi == null || bi.getColorModel().getColorSpace().getType() != 3);
        WritableRaster raster = Raster.createWritableRaster(imageType.getSampleModel(), null);
        bi = new BufferedImage(this.colorModel, raster, false, null);
        return bi;
    }

    private BufferedImage getDestination(ImageReadParam param, BufferedImage readImage) {
        BufferedImage bi = param.getDestination();
        if (bi != null) {
            return bi;
        }
        Rectangle region = param.getSourceRegion();
        int sampleX = param.getSourceXSubsampling();
        int sampleY = param.getSourceYSubsampling();
        if (region != null && region.getX() == 0.0 && region.getY() == 0.0 && region.getWidth() == (double)this.width && region.getHeight() == (double)this.height) {
            region = null;
        }
        if (region == null && sampleX == 1 && sampleY == 1 && !this.convertSpace) {
            return readImage;
        }
        int destWidth = this.width / sampleX;
        int destHeight = this.height / sampleY;
        if (region != null) {
            destWidth = (int)(region.getWidth() / (double)sampleX);
            destHeight = (int)(region.getHeight() / (double)sampleY);
        }
        int type = 10;
        if (this.convertSpace || readImage.getColorModel().getNumComponents() == 3) {
            type = 5;
        } else if (readImage.getColorModel().getComponentSize(0) > 8) {
            type = 11;
        }
        return new BufferedImage(destWidth, destHeight, type);
    }

    private void readRLEHeader() throws IOException {
        this.headerPos = this.iis.getStreamPosition();
        this.fillBuffer();
        if (this.bufLen < 64) {
            throw new EOFException();
        }
        int i = 0;
        while (i < 16) {
            this.header[i] = this.buf[this.bufPos] & 0xFF | (this.buf[this.bufPos + 1] & 0xFF) << 8 | (this.buf[this.bufPos + 2] & 0xFF) << 16 | (this.buf[this.bufPos + 3] & 0xFF) << 24;
            ++i;
            this.bufPos += 4;
        }
    }

    private void seekSegment(int seg) throws IOException {
        long segPos = this.headerPos + (long)this.header[seg];
        long l = this.segEnd = seg < this.nSegs ? this.headerPos + (long)this.header[seg + 1] : Long.MAX_VALUE;
        if (segPos < this.bufOff) {
            this.iis.seek(segPos);
            this.fillBuffer();
        } else {
            while (segPos - this.bufOff >= (long)this.bufLen) {
                this.fillBuffer();
            }
            this.bufPos = (int)(segPos - this.bufOff);
        }
        this.curSeg = seg;
    }

    private void seekInputToEndOfRLEData() throws IOException {
        this.iis.seek(this.bufOff + (long)this.bufPos);
    }

    private byte nextByte() throws IOException {
        if (this.bufOff + (long)this.bufPos >= this.segEnd) {
            throw new EOFException();
        }
        if (this.bufPos == this.bufLen) {
            this.fillBuffer();
        }
        return this.buf[this.bufPos++];
    }

    private void nextBytes(byte[] bs, int off, int len) throws IOException {
        int read;
        for (int pos = 0; pos < len; pos += read) {
            if (this.bufPos == this.bufLen) {
                this.fillBuffer();
            }
            read = Math.min(len - pos, this.bufLen - this.bufPos);
            System.arraycopy(this.buf, this.bufPos, bs, off + pos, read);
            this.bufPos += read;
        }
    }

    private void fillBuffer() throws IOException {
        this.bufOff = this.iis.getStreamPosition();
        this.bufPos = 0;
        this.bufLen = this.iis.read(this.buf);
        if (this.bufLen <= 0) {
            throw new EOFException();
        }
    }

    private void checkDestination(int nSegs, BufferedImage bi) throws IIOException {
        WritableRaster raster = bi.getRaster();
        int nBands = raster.getNumBands();
        int dataType = raster.getTransferType();
        if (nSegs == 1 || nSegs == 3) {
            if (nBands == nSegs && dataType == 0) {
                return;
            }
        } else if (nSegs == 2) {
            if (nBands == 1 && (dataType == 1 || dataType == 2)) {
                return;
            }
        } else {
            throw new IIOException("Unsupported Number of RLE Segments: " + ((long)nSegs & 0xFFFFFFFFL));
        }
        throw new IIOException("Number of RLE Segments: " + nSegs + " incompatible with Destination[bands=" + nBands + ", data=" + raster.getDataBuffer() + "]");
    }

    /*
     * Unable to fully structure code
     */
    private void unrle(byte[] bs, int off, int pixelStride) throws IOException {
        if (pixelStride == 1) {
            this.unrle(bs);
            return;
        }
        pos = off;
lbl5:
        // 3 sources

        try {
            while (pos < bs.length) {
                block6: {
                    b = this.nextByte();
                    if (b < 0) break block6;
                    l = this.checkLengthTooLong(b + 1, (off + bs.length - pos) / pixelStride);
                    i = 0;
                    while (i < l) {
                        bs[pos] = this.nextByte();
                        ++i;
                        pos += pixelStride;
                    }
                    ** GOTO lbl5
                }
                if (b == -128) continue;
                l = this.checkLengthTooLong(-b + 1, (off + bs.length - pos) / pixelStride);
                b = this.nextByte();
                i = 0;
                while (i < l) {
                    bs[pos] = b;
                    ++i;
                    pos += pixelStride;
                }
                ** GOTO lbl5
            }
        }
        catch (EOFException e) {
            RLEImageReader.log.warn("RLE Segment #{} too short, set missing {} bytes to 0", (Object)this.curSeg, (Object)((bs.length - pos + off) / pixelStride));
        }
    }

    private void unrle(byte[] bs) throws IOException {
        int pos = 0;
        try {
            while (pos < bs.length) {
                int l;
                byte b = this.nextByte();
                if (b >= 0) {
                    l = this.checkLengthTooLong(b + 1, bs.length - pos);
                    this.nextBytes(bs, pos, l);
                    pos += l;
                    continue;
                }
                if (b == -128) continue;
                l = this.checkLengthTooLong(-b + 1, bs.length - pos);
                b = this.nextByte();
                Arrays.fill(bs, pos, pos + l, b);
                pos += l;
            }
        }
        catch (EOFException e) {
            log.warn("RLE Segment #{} too short, set missing {} bytes to 0", (Object)this.curSeg, (Object)(bs.length - pos));
        }
    }

    private int checkLengthTooLong(int length, int max) {
        if (length > max) {
            log.warn("RLE Segment #{} too long, truncate {} bytes", (Object)this.curSeg, (Object)(length - max));
            return max;
        }
        return length;
    }

    /*
     * Unable to fully structure code
     */
    private void unrle(short[] ss, int shiftLeft) throws IOException {
        pos = 0;
lbl2:
        // 3 sources

        try {
            while (pos < ss.length) {
                block5: {
                    b = this.nextByte();
                    if (b < 0) break block5;
                    l = this.checkLengthTooLong(b + 1, ss.length - pos);
                    for (i = 0; i < l; ++i) {
                        v0 = pos++;
                        ss[v0] = (short)(ss[v0] | (this.nextByte() & 255) << shiftLeft);
                    }
                    ** GOTO lbl2
                }
                if (b == -128) continue;
                l = this.checkLengthTooLong(-b + 1, ss.length - pos);
                v = (this.nextByte() & 255) << shiftLeft;
                for (i = 0; i < l; ++i) {
                    v1 = pos++;
                    ss[v1] = (short)(ss[v1] | v);
                }
                ** GOTO lbl2
            }
        }
        catch (EOFException e) {
            RLEImageReader.log.warn("RLE Segment #{} too short, set missing {} bytes to 0", (Object)this.curSeg, (Object)(ss.length - pos));
        }
    }
}

