/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.dcm;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageio.stream.SegmentedImageInputStream;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.image.LookupTable;
import org.dcm4che2.image.OverlayUtils;
import org.dcm4che2.image.PartialComponentSampleModel;
import org.dcm4che2.image.VOIUtils;
import org.dcm4che2.imageio.ImageReaderFactory;
import org.dcm4che2.imageio.ItemParser;
import org.dcm4che2.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che2.imageio.plugins.dcm.DicomStreamMetaData;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.image.op.RectifySignedShortDataDescriptor;
import org.weasis.dicom.codec.ColorModelFactory;

public class DicomImageReader
extends ImageReader {
    private static final Logger log = LoggerFactory.getLogger(DicomImageReader.class);
    private static final String J2KIMAGE_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    private static final int[] OFFSETS_0 = new int[]{0};
    private static final int[] OFFSETS_0_0_0 = new int[]{0, 0, 0};
    private static final int[] OFFSETS_0_1_2 = new int[]{0, 1, 2};
    private ImageInputStream iis;
    private DicomInputStream dis;
    private DicomObject ds;
    private int width;
    private int height;
    private int frames;
    private int allocated;
    private int dataType;
    private int samples;
    private boolean monochrome;
    private boolean paletteColor;
    private boolean banded;
    private boolean bigEndian;
    private boolean swapByteOrder;
    private long pixelDataPos;
    private int pixelDataLen;
    protected boolean compressed;
    private DicomStreamMetaData streamMetaData;
    protected ImageReader reader;
    private ItemParser itemParser;
    private SegmentedImageInputStream siis;
    private String pmi;
    private Float autoWindowCenter;
    private Float autoWindowWidth;
    protected String tsuid;

    protected DicomImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetLocal();
        if (input != null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("Input not an ImageInputStream!");
            }
            this.iis = (ImageInputStream)input;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resetLocal();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    private void resetLocal() {
        this.iis = null;
        this.dis = null;
        this.ds = null;
        this.streamMetaData = null;
        this.width = 0;
        this.height = 0;
        this.frames = 0;
        this.allocated = 0;
        this.dataType = 0;
        this.samples = 0;
        this.banded = false;
        this.bigEndian = false;
        this.swapByteOrder = false;
        this.pixelDataPos = 0L;
        this.pixelDataLen = 0;
        this.tsuid = null;
        this.pmi = null;
        this.compressed = false;
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
        this.itemParser = null;
        this.siis = null;
        this.autoWindowCenter = null;
        this.autoWindowWidth = null;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new DicomImageReadParam();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.readMetaData();
        return this.streamMetaData;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readMetaData();
        return this.frames;
    }

    private void readMetaData() throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.ds != null) {
            return;
        }
        this.dis = new DicomInputStream(this.iis);
        this.dis.setHandler(new StopTagInputHandler(2145386512));
        this.ds = this.dis.readDicomObject();
        while (this.dis.tag() == -196612) {
            this.dis.readBytes(this.dis.valueLength());
            this.dis.readDicomObject(this.ds, -1);
        }
        this.streamMetaData = new DicomStreamMetaData();
        this.streamMetaData.setDicomObject(this.ds);
        this.bigEndian = this.dis.getTransferSyntax().bigEndian();
        this.tsuid = this.ds.getString(131088);
        this.width = this.ds.getInt(2621457);
        this.height = this.ds.getInt(2621456);
        this.frames = this.ds.getInt(0x280008);
        this.allocated = this.ds.getInt(2621696, 8);
        this.samples = this.ds.getInt(0x280002, 1);
        boolean bl = this.banded = this.ds.getInt(2621446) != 0;
        int n = this.allocated <= 8 ? 0 : (this.dataType = this.ds.getInt(2621699) != 0 ? 2 : 1);
        if (this.allocated > 16 && this.samples == 1) {
            this.dataType = 3;
        }
        this.paletteColor = ColorModelFactory.isPaletteColor(this.ds);
        this.monochrome = ColorModelFactory.isMonochrome(this.ds);
        this.pmi = this.ds.getString(2621444);
        if (this.dis.tag() == 2145386512) {
            if (this.frames == 0) {
                this.frames = 1;
            }
            boolean bl2 = this.swapByteOrder = this.bigEndian && this.dis.vr() == VR.OW && this.dataType == 0;
            if (this.swapByteOrder && this.banded) {
                throw new UnsupportedOperationException("Big Endian color-by-plane with Pixel Data VR=OW not implemented");
            }
            this.pixelDataPos = this.dis.getStreamPosition();
            this.pixelDataLen = this.dis.valueLength();
            boolean bl3 = this.compressed = this.pixelDataLen == -1;
            if (this.compressed) {
                ImageReaderFactory f = ImageReaderFactory.getInstance();
                log.debug("Transfer syntax for image is " + this.tsuid + " with image reader class " + f.getClass());
                f.adjustDatasetForTransferSyntax(this.ds, this.tsuid);
            }
        } else if (this.ds.getString(2654176) != null && this.frames == 0) {
            this.frames = 1;
            this.compressed = true;
        }
    }

    protected void initImageReader(int imageIndex) throws IOException {
        this.readMetaData();
        if (this.reader == null) {
            if (this.compressed) {
                this.initCompressedImageReader(imageIndex);
            } else {
                this.initRawImageReader();
            }
        }
        if (this.compressed && this.itemParser != null) {
            this.itemParser.seekFrame(this.siis, imageIndex);
            this.reader.setInput(this.siis, false);
        }
    }

    private void initCompressedImageReader(int imageIndex) throws IOException {
        ImageReaderFactory f = ImageReaderFactory.getInstance();
        this.reader = f.getReaderForTransferSyntax(this.tsuid);
        if (!"1.2.840.10008.1.2.4.94".equals(this.tsuid)) {
            this.itemParser = new ItemParser(this.dis, this.iis, this.frames, this.tsuid);
            this.siis = new SegmentedImageInputStream(this.iis, (StreamSegmentMapper)this.itemParser);
        }
    }

    private void initRawImageReader() {
        long[] frameOffsets = new long[this.frames];
        int frameLen = this.width * this.height * this.samples * (this.allocated >> 3);
        frameOffsets[0] = this.pixelDataPos;
        for (int i = 1; i < frameOffsets.length; ++i) {
            frameOffsets[i] = frameOffsets[i - 1] + (long)frameLen;
        }
        Object[] imageDimensions = new Dimension[this.frames];
        Arrays.fill(imageDimensions, new Dimension(this.width, this.height));
        RawImageInputStream riis = new RawImageInputStream(this.iis, this.createImageTypeSpecifier(), frameOffsets, (Dimension[])imageDimensions);
        riis.setByteOrder(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.reader = ImageIO.getImageReadersByFormatName("RAW").next();
        this.reader.setInput(riis);
    }

    protected ImageTypeSpecifier createImageTypeSpecifier() {
        ColorModel cm = ColorModelFactory.createColorModel(this.ds);
        SampleModel sm = this.createSampleModel();
        return new ImageTypeSpecifier(cm, sm);
    }

    private SampleModel createSampleModel() {
        if (this.samples == 1) {
            return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, 1, this.width, OFFSETS_0);
        }
        if (this.banded) {
            return new BandedSampleModel(this.dataType, this.width, this.height, this.width, OFFSETS_0_1_2, OFFSETS_0_0_0);
        }
        if (!this.compressed && this.pmi.endsWith("422")) {
            return new PartialComponentSampleModel(this.width, this.height, 2, 1);
        }
        if (!this.compressed && this.pmi.endsWith("420")) {
            return new PartialComponentSampleModel(this.width, this.height, 2, 2);
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, 3, this.width * 3, OFFSETS_0_1_2);
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readMetaData();
        if (OverlayUtils.isOverlay(imageIndex)) {
            return OverlayUtils.getOverlayHeight(this.ds, imageIndex);
        }
        return this.height;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readMetaData();
        if (OverlayUtils.isOverlay(imageIndex)) {
            return OverlayUtils.getOverlayWidth(this.ds, imageIndex);
        }
        return this.width;
    }

    public Float getAutoWindowCenter() {
        return this.autoWindowCenter;
    }

    public Float getAutoWindowWidth() {
        return this.autoWindowWidth;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.initImageReader(0);
        return this.reader.getImageTypes(0);
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.initImageReader(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if (this.compressed) {
            ImageReadParam param1 = this.reader.getDefaultReadParam();
            this.copyReadParam(param, param1);
            return this.decompressRaster(imageIndex, param1);
        }
        if (this.pmi.endsWith("422") || this.pmi.endsWith("420")) {
            log.debug("Using a 422/420 partial component image reader.");
            if (param.getSourceXSubsampling() != 1 || param.getSourceYSubsampling() != 1 || param.getSourceRegion() != null) {
                log.warn("YBR_*_422 and 420 reader does not support source sub-sampling or source region.");
                throw new UnsupportedOperationException("Implement sub-sampling/soure region.");
            }
            SampleModel sm = this.createSampleModel();
            WritableRaster wr = Raster.createWritableRaster(sm, new Point());
            DataBufferByte dbb = (DataBufferByte)wr.getDataBuffer();
            byte[] data = dbb.getData();
            log.debug("Seeking to " + (this.pixelDataPos + (long)(imageIndex * data.length)) + " and reading " + data.length + " bytes.");
            this.iis.seek(this.pixelDataPos + (long)(imageIndex * data.length));
            this.iis.read(data);
            if (this.swapByteOrder) {
                ByteUtils.toggleShortEndian(data);
            }
            return wr;
        }
        Raster raster = this.reader.readRaster(imageIndex, param);
        if (this.swapByteOrder) {
            ByteUtils.toggleShortEndian(((DataBufferByte)raster.getDataBuffer()).getData());
        }
        return raster;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage bi;
        if (OverlayUtils.isOverlay(imageIndex)) {
            this.readMetaData();
            String rgbs = param != null ? ((DicomImageReadParam)param).getOverlayRGB() : null;
            return OverlayUtils.extractOverlay(this.ds, imageIndex, this, rgbs);
        }
        this.initImageReader(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if (this.compressed) {
            ImageReadParam param1 = this.reader.getDefaultReadParam();
            this.copyReadParam(param, param1);
            bi = this.reader.read(0, param1);
            this.postDecompress();
            if (this.paletteColor && bi.getColorModel().getNumComponents() == 1) {
                bi = new BufferedImage(ColorModelFactory.createColorModel(this.ds), bi.getRaster(), false, null);
            }
        } else if (this.pmi.endsWith("422") || this.pmi.endsWith("420")) {
            bi = this.readYbr400(imageIndex, param);
        } else {
            bi = this.reader.read(imageIndex, param);
            if (this.swapByteOrder) {
                ByteUtils.toggleShortEndian(((DataBufferByte)bi.getRaster().getDataBuffer()).getData());
            }
        }
        RenderedImage img = this.validateSignedShortDataBuffer(bi);
        return img instanceof BufferedImage ? (BufferedImage)img : ((RenderedOp)img).getAsBufferedImage();
    }

    private BufferedImage readYbr400(int imageIndex, ImageReadParam param) throws IOException {
        ImageReadParam useParam = param;
        Rectangle sourceRegion = param.getSourceRegion();
        if (param.getSourceXSubsampling() != 1 || param.getSourceYSubsampling() != 1 || sourceRegion != null) {
            useParam = this.getDefaultReadParam();
        }
        WritableRaster wr = (WritableRaster)this.readRaster(imageIndex, useParam);
        BufferedImage bi = new BufferedImage(ColorModelFactory.createColorModel(this.ds), wr, false, null);
        if (useParam == param) {
            return bi;
        }
        return DicomImageReader.subsampleRGB(bi, sourceRegion, param.getSourceXSubsampling(), param.getSourceYSubsampling());
    }

    public static BufferedImage subsampleRGB(BufferedImage src, Rectangle sourceRegion, int subSampleX, int subSampleY) {
        if (sourceRegion == null) {
            sourceRegion = new Rectangle(src.getWidth(), src.getHeight());
        }
        int dWidth = (int)Math.ceil((double)sourceRegion.width / (double)subSampleX);
        int dHeight = (int)Math.ceil((double)sourceRegion.height / (double)subSampleY);
        BufferedImage dest = DicomImageReader.createRGBBufferedImage(dWidth, dHeight);
        int[] srcRgb = new int[src.getWidth()];
        int[] destRgb = new int[dWidth];
        int maxY = sourceRegion.y + sourceRegion.height;
        int maxX = sourceRegion.x + sourceRegion.width;
        int destY = 0;
        int iy = sourceRegion.y;
        while (iy < maxY) {
            srcRgb = src.getRGB(sourceRegion.x, iy, sourceRegion.width, 1, srcRgb, 0, src.getWidth());
            if (subSampleX == 1) {
                dest.setRGB(0, destY, dWidth, 1, srcRgb, 0, src.getWidth());
            } else {
                int destX = 0;
                for (int ix = sourceRegion.x; ix < maxX; ix += subSampleX) {
                    destRgb[destX++] = srcRgb[ix];
                }
                dest.setRGB(0, destY, dWidth, 1, destRgb, 0, dWidth);
            }
            iy += subSampleY;
            ++destY;
        }
        return dest;
    }

    public static BufferedImage createRGBBufferedImage(int destWidth, int destHeight) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        WritableRaster r = ((ColorModel)cm).createCompatibleWritableRaster(destWidth, destHeight);
        BufferedImage dest = new BufferedImage(cm, r, false, null);
        return dest;
    }

    @Override
    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        RenderedImage bi;
        this.initImageReader(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if (this.compressed) {
            ImageReadParam param1 = this.reader.getDefaultReadParam();
            this.copyReadParam(param, param1);
            bi = this.reader.readAsRenderedImage(0, param1);
            this.postDecompress();
        } else if (this.pmi.endsWith("422") || this.pmi.endsWith("420")) {
            bi = this.readYbr400(imageIndex, param);
        } else {
            bi = this.reader.readAsRenderedImage(imageIndex, param);
            if (this.swapByteOrder) {
                ByteUtils.toggleShortEndian(((DataBufferByte)bi.getData().getDataBuffer()).getData());
            }
        }
        return this.validateSignedShortDataBuffer(bi);
    }

    public RenderedImage validateSignedShortDataBuffer(RenderedImage source) {
        int highBit;
        if (source != null && this.dataType == 2 && source.getSampleModel().getDataType() == 2 && (highBit = this.ds.getInt(2621698, this.allocated) + 1) < this.allocated) {
            source = RectifySignedShortDataDescriptor.create((RenderedImage)source, (int[])new int[]{highBit}, null);
        }
        return source;
    }

    public int getDataType() {
        return this.dataType;
    }

    @Override
    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        return super.readTile(imageIndex, tileX, tileY);
    }

    @Override
    public Raster readTileRaster(int imageIndex, int tileX, int tileY) throws IOException {
        return super.readTileRaster(imageIndex, tileX, tileY);
    }

    public void readPixelData() throws Exception {
        this.readMetaData();
        if (this.dis.tag() != 2145386512) {
            throw new Exception("Cannot read pixel data");
        }
        this.dis.setHandler(this.dis);
        this.dis.reset();
        this.dis.readDicomObject(this.ds, -1);
    }

    public long getPixelDataPos() {
        return this.pixelDataPos;
    }

    public byte[] readBytes(int imageIndex, ImageReadParam param) throws IOException {
        this.initImageReader(imageIndex);
        if (this.compressed) {
            return this.itemParser.readFrame(this.siis, imageIndex);
        }
        int frameLen = this.width * this.height * this.samples * (this.allocated >> 3);
        byte[] ret = new byte[frameLen];
        long offset = this.pixelDataPos + (long)imageIndex * (long)frameLen;
        this.iis.seek(offset);
        this.iis.read(ret);
        return ret;
    }

    protected void copyReadParam(ImageReadParam src, ImageReadParam dst) {
        dst.setDestination(src.getDestination());
        dst.setSourceRegion(src.getSourceRegion());
        dst.setSourceSubsampling(src.getSourceXSubsampling(), src.getSourceYSubsampling(), src.getSubsamplingXOffset(), src.getSubsamplingYOffset());
        dst.setDestinationOffset(src.getDestinationOffset());
        if (ImageReaderFactory.getInstance().needsImageTypeSpecifier(this.tsuid)) {
            dst.setDestinationType(this.createImageTypeSpecifier());
        }
    }

    private Raster decompressRaster(int imageIndex, ImageReadParam param) throws IOException {
        if (!this.reader.canReadRaster()) {
            BufferedImage bi = this.reader.read(0, param);
            this.postDecompress();
            return bi.getRaster();
        }
        Raster raster = this.reader.readRaster(0, param);
        this.postDecompress();
        return raster;
    }

    protected void postDecompress() {
        if (this.reader.getClass().getName().startsWith(J2KIMAGE_READER)) {
            this.reader.dispose();
            ImageReaderFactory f = ImageReaderFactory.getInstance();
            this.reader = f.getReaderForTransferSyntax(this.tsuid);
        } else {
            this.reader.reset();
        }
    }

    private LookupTable createLut(DicomImageReadParam param, int frame, Raster raster) {
        DicomObject voiObj;
        short[] pval2gray = param.getPValue2Gray();
        DicomObject pr = param.getPresentationState();
        float c = param.getWindowCenter();
        float w = param.getWindowWidth();
        String vlutFct = param.getVoiLutFunction();
        if (param.isAutoWindowing() && (voiObj = VOIUtils.selectVoiObject(this.ds, pr, frame)) == null) {
            float[] cw = VOIUtils.getMinMaxWindowCenterWidth(this.ds, pr, frame, raster);
            c = cw[0];
            w = cw[1];
            vlutFct = "LINEAR";
            this.autoWindowCenter = Float.valueOf(c);
            this.autoWindowWidth = Float.valueOf(w);
        }
        return LookupTable.createLutForImageWithPR(this.ds, pr, frame, c, w, vlutFct, 8, pval2gray);
    }
}

