/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import org.noos.xing.mydoggy.Content;
import org.osgi.service.prefs.Preferences;
import org.weasis.core.api.command.Option;
import org.weasis.core.api.command.Options;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.SliderCineListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.image.op.ByteLut;
import org.weasis.core.api.image.util.KernelData;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.service.BundlePreferences;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MeasureToolBar;
import org.weasis.core.ui.editor.image.PannerListener;
import org.weasis.core.ui.editor.image.SynchView;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.GraphicsListener;
import org.weasis.core.ui.graphic.model.Tools;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.SortSeriesStack;
import org.weasis.dicom.codec.display.LutManager;
import org.weasis.dicom.codec.display.PresetWindowLevel;
import org.weasis.dicom.codec.display.ViewingProtocols;
import org.weasis.dicom.codec.geometry.ImageOrientation;
import org.weasis.dicom.viewer2d.ResetTools;
import org.weasis.dicom.viewer2d.View2dContainer;
import org.weasis.dicom.viewer2d.View2dFactory;
import org.weasis.dicom.viewer2d.internal.Activator;

public class EventManager
extends ImageViewerEventManager<DicomImageElement>
implements ActionListener {
    public static final String[] functions = new String[]{"zoom", "wl", "move"};
    private static ActionW[] keyEventActions = new ActionW[]{ActionW.ZOOM, ActionW.SCROLL_SERIES, ActionW.ROTATION, ActionW.WINLEVEL, ActionW.PAN, ActionW.MEASURE, ActionW.CONTEXTMENU};
    private static EventManager instance;
    private final SliderCineListener moveTroughSliceAction = this.getMoveTroughSliceAction(20, SliderCineListener.TIME.second, 0.1);
    private final SliderChangeListener windowAction;
    private final SliderChangeListener levelAction;
    private final SliderChangeListener rotateAction;
    private final SliderChangeListener zoomAction;
    private final SliderChangeListener lensZoomAction;
    private final ToggleButtonListener flipAction;
    private final ToggleButtonListener inverseLutAction;
    private final ToggleButtonListener inverseStackAction;
    private final ToggleButtonListener showLensAction;
    private final ToggleButtonListener imageOverlayAction;
    private final ToggleButtonListener drawOnceAction;
    private final ComboItemListener presetAction;
    private final ComboItemListener lutAction;
    private final ComboItemListener filterAction;
    private final ComboItemListener sortStackAction;
    private final ComboItemListener viewingProtocolAction;
    private final ComboItemListener layoutAction;
    private final ComboItemListener synchAction;
    private final ComboItemListener measureAction;
    private final PannerListener panAction;
    public static final ArrayList<SynchView> SYNCH_LIST;

    public static synchronized EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    private EventManager() {
        this.iniAction((ActionState)this.moveTroughSliceAction);
        this.windowAction = this.newWindowAction();
        this.iniAction((ActionState)this.windowAction);
        this.levelAction = this.newLevelAction();
        this.iniAction((ActionState)this.levelAction);
        this.rotateAction = this.newRotateAction();
        this.iniAction((ActionState)this.rotateAction);
        this.zoomAction = this.newZoomAction();
        this.iniAction((ActionState)this.zoomAction);
        this.flipAction = this.newFlipAction();
        this.iniAction((ActionState)this.flipAction);
        this.inverseLutAction = this.newInverseLutAction();
        this.iniAction((ActionState)this.inverseLutAction);
        this.inverseStackAction = this.newInverseStackAction();
        this.iniAction((ActionState)this.inverseStackAction);
        this.showLensAction = this.newLensAction();
        this.iniAction((ActionState)this.showLensAction);
        this.lensZoomAction = this.newLensZoomAction();
        this.iniAction((ActionState)this.lensZoomAction);
        this.imageOverlayAction = this.newImageOverlayAction();
        this.iniAction((ActionState)this.imageOverlayAction);
        this.drawOnceAction = this.newDrawOnlyOnceAction();
        this.iniAction((ActionState)this.drawOnceAction);
        this.presetAction = this.newPresetAction();
        this.iniAction((ActionState)this.presetAction);
        this.lutAction = this.newLutAction();
        this.iniAction((ActionState)this.lutAction);
        this.filterAction = this.newFilterAction();
        this.iniAction((ActionState)this.filterAction);
        this.sortStackAction = this.newSortStackAction();
        this.iniAction((ActionState)this.sortStackAction);
        this.viewingProtocolAction = this.newViewingProtocolAction();
        this.iniAction((ActionState)this.viewingProtocolAction);
        this.layoutAction = this.newLayoutAction(View2dContainer.MODELS);
        this.iniAction((ActionState)this.layoutAction);
        this.synchAction = this.newSynchAction(SYNCH_LIST.toArray(new SynchView[SYNCH_LIST.size()]));
        this.iniAction((ActionState)this.synchAction);
        this.measureAction = this.newMeasurementAction(MeasureToolBar.graphicList.toArray(new Graphic[MeasureToolBar.graphicList.size()]));
        this.iniAction((ActionState)this.measureAction);
        this.panAction = this.newPanAction();
        this.iniAction((ActionState)this.panAction);
        Preferences prefs = Activator.PREFERENCES.getDefaultPreferences();
        this.zoomSetting.applyPreferences(prefs);
        this.viewSetting.applyPreferences(prefs);
        this.mouseActions.applyPreferences(prefs);
        if (prefs != null) {
            Preferences prefNode = prefs.node("mouse.sensivity");
            this.windowAction.setMouseSensivity(prefNode.getDouble(this.windowAction.getActionW().cmd(), 1.25));
            this.levelAction.setMouseSensivity(prefNode.getDouble(this.levelAction.getActionW().cmd(), 1.25));
            this.moveTroughSliceAction.setMouseSensivity(prefNode.getDouble(this.moveTroughSliceAction.getActionW().cmd(), 0.1));
            this.rotateAction.setMouseSensivity(prefNode.getDouble(this.rotateAction.getActionW().cmd(), 0.25));
            this.zoomAction.setMouseSensivity(prefNode.getDouble(this.zoomAction.getActionW().cmd(), 0.1));
        }
        this.initializeParameters();
    }

    private void iniAction(ActionState action) {
        this.actions.put(action.getActionW(), action);
    }

    private void initializeParameters() {
        this.enableActions(false);
        this.windowAction.getModel().addChangeListener((ChangeListener)this.presetAction);
        this.levelAction.getModel().addChangeListener((ChangeListener)this.presetAction);
    }

    private ComboItemListener newFilterAction() {
        return new ComboItemListener(ActionW.FILTER, KernelData.ALL_FILTERS){

            public void itemStateChanged(Object object) {
                if (object instanceof KernelData) {
                    EventManager.this.firePropertyChange(this.action.cmd(), null, object);
                }
            }
        };
    }

    protected SliderCineListener getMoveTroughSliceAction(int speed, SliderCineListener.TIME time, double mouseSensivity) {
        return new SliderCineListener(ActionW.SCROLL_SERIES, 1, 2, 1, speed, time, mouseSensivity){
            protected CineThread currentCine;

            public void stateChanged(BoundedRangeModel model) {
                MediaElement media;
                DefaultView2d selectedImagePane;
                int index = model.getValue() - 1;
                Series series = null;
                ImageElement image = null;
                if (EventManager.this.selectedView2dContainer != null && (selectedImagePane = EventManager.this.selectedView2dContainer.getSelectedImagePane()).getSeries() instanceof Series && (media = (series = (Series)selectedImagePane.getSeries()).getMedia(index)) instanceof ImageElement && (image = (ImageElement)media) != null) {
                    int min = (int)image.getMinValue();
                    int max = (int)image.getMaxValue();
                    if (min == 0 && max == 0) {
                        image.getImage();
                        min = (int)image.getMinValue();
                        max = (int)image.getMaxValue();
                    }
                    if (PresetWindowLevel.DEFAULT.equals(EventManager.this.presetAction.getSelectedItem())) {
                        EventManager.this.windowAction.getModel().removeChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.levelAction.getModel().removeChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.windowAction.setMinMaxValueWithoutTriggerAction(0, max - min, (int)image.getDefaultWindow());
                        EventManager.this.levelAction.setMinMaxValueWithoutTriggerAction(min, max, (int)image.getDefaultLevel());
                        EventManager.this.windowAction.getModel().addChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.levelAction.getModel().addChangeListener((ChangeListener)EventManager.this.presetAction);
                    } else if (PresetWindowLevel.AUTO.equals(EventManager.this.presetAction.getSelectedItem())) {
                        EventManager.this.windowAction.getModel().removeChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.levelAction.getModel().removeChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.windowAction.setMinMaxValueWithoutTriggerAction(0, max - min, max - min);
                        EventManager.this.levelAction.setMinMaxValueWithoutTriggerAction(min, max, (max - min) / 2 + min);
                        EventManager.this.windowAction.getModel().addChangeListener((ChangeListener)EventManager.this.presetAction);
                        EventManager.this.levelAction.getModel().addChangeListener((ChangeListener)EventManager.this.presetAction);
                    }
                }
                Number location = index;
                GridBagLayoutModel layout = (GridBagLayoutModel)EventManager.this.layoutAction.getSelectedItem();
                ActionState synch = EventManager.this.getAction(ActionW.SYNCH);
                if (image != null && View2dFactory.getViewTypeNumber(layout, DefaultView2d.class) > 1 && synch instanceof ComboItemListener) {
                    SynchView synchview = (SynchView)((ComboItemListener)synch).getSelectedItem();
                    if (synchview.isActionEnable(ActionW.SCROLL_SERIES)) {
                        double[] val = (double[])image.getTagValue(TagW.SlicePosition);
                        if (val != null) {
                            location = val[0] + val[1] + val[2];
                        }
                    } else {
                        ArrayList panes = EventManager.this.selectedView2dContainer.getImagePanels();
                        for (DefaultView2d p : panes) {
                            Boolean cutlines = (Boolean)p.getActionValue(ActionW.SYNCH_CROSSLINE.cmd());
                            if (cutlines == null || !cutlines.booleanValue()) continue;
                            double[] val = (double[])image.getTagValue(TagW.SlicePosition);
                            if (val != null) {
                                location = val[0] + val[1] + val[2];
                                break;
                            }
                            return;
                        }
                    }
                }
                EventManager.this.firePropertyChange(this.action.cmd(), null, location);
                if (image != null) {
                    EventManager.this.fireSeriesViewerListeners(new SeriesViewerEvent((SeriesViewer)EventManager.this.selectedView2dContainer, series, (MediaElement)image, SeriesViewerEvent.EVENT.SELECT));
                }
            }

            public void setSpeed(int speed) {
                super.setSpeed(speed);
                if (this.currentCine != null) {
                    this.currentCine.iniSpeed();
                }
            }

            public synchronized void start() {
                if (this.currentCine != null) {
                    this.stop();
                }
                if (this.getMax() - this.getMin() > 0) {
                    this.currentCine = new CineThread();
                    this.currentCine.start();
                }
            }

            public synchronized void stop() {
                CineThread moribund = this.currentCine;
                this.currentCine = null;
                if (moribund != null) {
                    moribund.cining = false;
                    moribund.interrupt();
                }
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                this.setValue(this.getValue() + e.getWheelRotation());
            }

            public int getCurrentCineRate() {
                if (this.currentCine != null) {
                    return this.currentCine.getCurrentCineRate();
                }
                return 0;
            }

            class CineThread
            extends Thread {
                private volatile int iteration;
                private volatile int wait;
                private volatile int currentCineRate;
                private volatile long start;
                private volatile boolean cining = true;

                CineThread() {
                }

                @Override
                public void run() {
                    this.iniSpeed();
                    while (this.cining) {
                        GuiExecutor.instance().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (CineThread.this.cining) {
                                    int frameIndex = this.getValue() + 1;
                                    frameIndex = frameIndex > this.getMax() ? 0 : frameIndex;
                                    this.setValue(frameIndex);
                                }
                            }
                        });
                        ++this.iteration;
                        long elapsed = (System.currentTimeMillis() - this.start) / 1000L;
                        if (elapsed > 0L) {
                            this.currentCineRate = (int)((long)this.iteration / elapsed);
                            this.wait = this.currentCineRate < this.getSpeed() ? --this.wait : ++this.wait;
                            if (this.wait < 0) {
                                this.wait = 0;
                            }
                        }
                        if (this.wait <= 0) continue;
                        try {
                            Thread.sleep(this.wait);
                        }
                        catch (Exception exception) {}
                    }
                }

                public void iniSpeed() {
                    this.iteration = 0;
                    this.currentCineRate = this.getSpeed();
                    this.wait = 1000 / this.currentCineRate;
                    this.start = System.currentTimeMillis();
                }

                public int getCurrentCineRate() {
                    return this.currentCineRate;
                }
            }
        };
    }

    private ComboItemListener newPresetAction() {
        return new ComboItemListener(ActionW.PRESET, PresetWindowLevel.getPresetCollection((String)"UNKOWN")){

            public void itemStateChanged(Object object) {
                if (object instanceof PresetWindowLevel) {
                    EventManager.this.windowAction.getModel().removeChangeListener((ChangeListener)((Object)this));
                    EventManager.this.levelAction.getModel().removeChangeListener((ChangeListener)((Object)this));
                    ImageElement img = null;
                    if (EventManager.this.selectedView2dContainer != null) {
                        img = EventManager.this.selectedView2dContainer.getSelectedImagePane().getImage();
                    }
                    if (img == null) {
                        return;
                    }
                    PresetWindowLevel preset = (PresetWindowLevel)object;
                    if (preset.equals(PresetWindowLevel.DEFAULT)) {
                        EventManager.this.windowAction.setValue((int)img.getDefaultWindow());
                        EventManager.this.levelAction.setValue((int)img.getDefaultLevel());
                    } else if (preset.equals(PresetWindowLevel.AUTO)) {
                        int min = (int)img.getMinValue();
                        int max = (int)img.getMaxValue();
                        EventManager.this.windowAction.setValue(max - min);
                        EventManager.this.levelAction.setValue((max - min) / 2 + min);
                    } else if (!preset.equals(PresetWindowLevel.CUSTOM)) {
                        EventManager.this.windowAction.setValue((int)preset.getWindow());
                        EventManager.this.levelAction.setValue((int)preset.getLevel());
                    }
                    EventManager.this.firePropertyChange(this.action.cmd(), null, preset);
                    EventManager.this.windowAction.getModel().addChangeListener((ChangeListener)((Object)this));
                    EventManager.this.levelAction.getModel().addChangeListener((ChangeListener)((Object)this));
                }
            }

            public void stateChanged(ChangeEvent evt) {
                this.model.removeListDataListener((ListDataListener)((Object)this));
                this.model.setSelectedItem(PresetWindowLevel.CUSTOM);
                this.model.addListDataListener((ListDataListener)((Object)this));
                EventManager.this.firePropertyChange(this.action.cmd(), null, PresetWindowLevel.CUSTOM);
            }
        };
    }

    private ComboItemListener newLutAction() {
        return new ComboItemListener(ActionW.LUT, LutManager.getLutCollection()){

            public void itemStateChanged(Object object) {
                if (object instanceof ByteLut) {
                    EventManager.this.firePropertyChange(this.action.cmd(), null, object);
                }
            }
        };
    }

    private ToggleButtonListener newImageOverlayAction() {
        return new ToggleButtonListener(ActionW.IMAGE_OVERLAY, true){

            public void actionPerformed(boolean selected) {
                EventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    private ComboItemListener newSortStackAction() {
        return new ComboItemListener(ActionW.SORTSTACK, SortSeriesStack.getValues()){

            public void itemStateChanged(Object object) {
                EventManager.this.firePropertyChange(this.action.cmd(), null, object);
            }
        };
    }

    private ComboItemListener newViewingProtocolAction() {
        return new ComboItemListener(ActionW.VIEWINGPROTOCOL, ViewingProtocols.getValues()){

            public void itemStateChanged(Object object) {
                EventManager.this.firePropertyChange(this.action.cmd(), null, object);
            }
        };
    }

    protected ToggleButtonListener newInverseStackAction() {
        return new ToggleButtonListener(ActionW.INVERSESTACK, false){

            public void actionPerformed(boolean selected) {
                EventManager.this.firePropertyChange(this.action.cmd(), null, selected);
            }
        };
    }

    public ActionW getActionFromCommand(String command) {
        ActionW action = super.getActionFromCommand(command);
        if (action == null && command != null) {
            for (ActionW a : keyEventActions) {
                if (!a.cmd().equals(command)) continue;
                return a;
            }
        }
        return action;
    }

    public ActionW getActionFromkeyEvent(int keyEvent) {
        ActionW action = super.getActionFromkeyEvent(keyEvent);
        if (action == null && keyEvent != 0) {
            for (ActionW a : keyEventActions) {
                if (a.getKeyCode() != keyEvent) continue;
                return a;
            }
        }
        return action;
    }

    public void setSelectedView2dContainer(ImageViewerPlugin<DicomImageElement> selectedView2dContainer) {
        if (this.selectedView2dContainer != null) {
            this.selectedView2dContainer.setMouseActions(null);
            this.selectedView2dContainer.setDrawActions(null);
            this.moveTroughSliceAction.stop();
        }
        this.selectedView2dContainer = selectedView2dContainer;
        if (selectedView2dContainer != null) {
            this.synchAction.setSelectedItemWithoutTriggerAction((Object)selectedView2dContainer.getSynchView());
            this.layoutAction.setSelectedItemWithoutTriggerAction((Object)selectedView2dContainer.getOriginalLayoutModel());
            this.updateComponentsListener((DefaultView2d<DicomImageElement>)selectedView2dContainer.getSelectedImagePane());
            selectedView2dContainer.setMouseActions(this.mouseActions);
            Graphic graphic = null;
            ActionState action = this.getAction(ActionW.DRAW_MEASURE);
            if (action instanceof ComboItemListener) {
                graphic = (Graphic)((ComboItemListener)action).getSelectedItem();
            }
            selectedView2dContainer.setDrawActions(graphic);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals(ActionW.CINESTART.cmd())) {
            this.moveTroughSliceAction.start();
        } else if (command.equals(ActionW.CINESTOP.cmd())) {
            this.moveTroughSliceAction.stop();
        }
    }

    public void resetAllActions() {
        DefaultView2d viewPane;
        this.firePropertyChange(ActionW.ZOOM.cmd(), null, 0.0);
        if (this.selectedView2dContainer != null && (viewPane = this.selectedView2dContainer.getSelectedImagePane()) != null) {
            viewPane.center();
        }
        this.presetAction.setSelectedItem((Object)PresetWindowLevel.DEFAULT);
        this.flipAction.setSelected(false);
        this.rotateAction.setValue(0);
        this.inverseLutAction.setSelected(false);
        this.lutAction.setSelectedItem((Object)ByteLut.defaultLUT);
        this.filterAction.setSelectedItem((Object)KernelData.NONE);
    }

    public void reset(ResetTools action) {
        DefaultView2d viewPane;
        if (ResetTools.All.equals((Object)action)) {
            this.resetAllActions();
        } else if (ResetTools.Zoom.equals((Object)action)) {
            this.firePropertyChange(ActionW.ZOOM.cmd(), null, 0.0);
        } else if (ResetTools.Rotation.equals((Object)action)) {
            this.rotateAction.setValue(0);
        } else if (ResetTools.WindowLevel.equals((Object)action)) {
            this.presetAction.setSelectedItem((Object)PresetWindowLevel.DEFAULT);
        } else if (ResetTools.Pan.equals((Object)action) && this.selectedView2dContainer != null && (viewPane = this.selectedView2dContainer.getSelectedImagePane()) != null) {
            viewPane.center();
        }
    }

    public synchronized boolean updateComponentsListener(DefaultView2d<DicomImageElement> defaultView2d) {
        if (defaultView2d == null) {
            return false;
        }
        Content selectedContent = UIManager.toolWindowManager.getContentManager().getSelectedContent();
        if (selectedContent == null || selectedContent.getComponent() != this.selectedView2dContainer) {
            return false;
        }
        if (this.selectedView2dContainer == null || defaultView2d != this.selectedView2dContainer.getSelectedImagePane()) {
            return false;
        }
        this.clearAllPropertyChangeListeners();
        if (defaultView2d.getSourceImage() == null) {
            this.enableActions(false);
            return false;
        }
        if (!this.enabledAction) {
            this.enableActions(true);
        }
        ImageElement image = defaultView2d.getImage();
        MediaSeries series = defaultView2d.getSeries();
        this.windowAction.setMinMaxValueWithoutTriggerAction(0, (int)(image.getMaxValue() - image.getMinValue()), ((Float)defaultView2d.getActionValue(ActionW.WINDOW.cmd())).intValue());
        this.levelAction.setMinMaxValueWithoutTriggerAction((int)image.getMinValue(), (int)image.getMaxValue(), ((Float)defaultView2d.getActionValue(ActionW.LEVEL.cmd())).intValue());
        this.rotateAction.setValueWithoutTriggerAction(((Integer)defaultView2d.getActionValue(ActionW.ROTATION.cmd())).intValue());
        this.flipAction.setSelectedWithoutTriggerAction(((Boolean)defaultView2d.getActionValue(ActionW.FLIP.cmd())).booleanValue());
        this.zoomAction.setValueWithoutTriggerAction(this.viewScaleToSliderValue(Math.abs((Double)defaultView2d.getActionValue(ActionW.ZOOM.cmd()))));
        this.showLensAction.setSelectedWithoutTriggerAction(((Boolean)defaultView2d.getActionValue(ActionW.LENS.cmd())).booleanValue());
        Double lensZoom = (Double)defaultView2d.getLensActionValue(ActionW.ZOOM.cmd());
        if (lensZoom != null) {
            this.lensZoomAction.setValueWithoutTriggerAction(this.viewScaleToSliderValue(Math.abs(lensZoom)));
        }
        Object[] presets = PresetWindowLevel.getPresetCollection((String)((String)series.getTagValue(TagW.Modality)));
        this.presetAction.setDataList(presets);
        this.presetAction.setSelectedItemWithoutTriggerAction(defaultView2d.getActionValue(ActionW.PRESET.cmd()));
        this.moveTroughSliceAction.setMinMaxValue(1, series.size(), defaultView2d.getFrameIndex() + 1);
        Integer speed = (Integer)series.getTagValue(TagW.CineRate);
        if (speed != null) {
            this.moveTroughSliceAction.setSpeed(speed.intValue());
        }
        this.lutAction.setSelectedItemWithoutTriggerAction(defaultView2d.getActionValue(ActionW.LUT.cmd()));
        this.inverseLutAction.setSelectedWithoutTriggerAction(((Boolean)defaultView2d.getActionValue(ActionW.INVERSELUT.cmd())).booleanValue());
        this.filterAction.setSelectedItemWithoutTriggerAction(defaultView2d.getActionValue(ActionW.FILTER.cmd()));
        this.imageOverlayAction.setSelectedWithoutTriggerAction(((Boolean)defaultView2d.getActionValue(ActionW.IMAGE_OVERLAY.cmd())).booleanValue());
        this.sortStackAction.setSelectedItemWithoutTriggerAction(defaultView2d.getActionValue(ActionW.SORTSTACK.cmd()));
        this.viewingProtocolAction.setSelectedItemWithoutTriggerAction(defaultView2d.getActionValue(ActionW.VIEWINGPROTOCOL.cmd()));
        this.inverseStackAction.setSelectedWithoutTriggerAction(((Boolean)defaultView2d.getActionValue(ActionW.INVERSESTACK.cmd())).booleanValue());
        this.updateAllListeners((ImageViewerPlugin<DicomImageElement>)this.selectedView2dContainer, (SynchView)this.synchAction.getSelectedItem());
        for (PluginTool p : this.selectedView2dContainer.getToolPanel()) {
            if (!(p instanceof GraphicsListener)) continue;
            defaultView2d.getLayerModel().addGraphicSelectionListener((GraphicsListener)p);
        }
        return true;
    }

    protected boolean isCompatible(MediaSeries<DicomImageElement> series1, MediaSeries<DicomImageElement> series2) {
        return ImageOrientation.hasSameOrientation(series1, series2);
    }

    public void updateAllListeners(ImageViewerPlugin<DicomImageElement> viewerPlugin, SynchView synchView) {
        block15: {
            this.clearAllPropertyChangeListeners();
            if (viewerPlugin == null) break block15;
            DefaultView2d viewPane = viewerPlugin.getSelectedImagePane();
            if (viewPane == null) {
                return;
            }
            MediaSeries series = viewPane.getSeries();
            if (series != null) {
                this.addPropertyChangeListeners(viewPane);
                ArrayList panes = viewerPlugin.getImagePanels();
                panes.remove(viewPane);
                viewPane.setActionsInView(ActionW.SYNCH_CROSSLINE.cmd(), (Object)false);
                if (SynchView.NONE.equals(synchView)) {
                    for (int i = 0; i < panes.size(); ++i) {
                        DefaultView2d pane = (DefaultView2d)panes.get(i);
                        AbstractLayer layer = pane.getLayerModel().getLayer(Tools.CROSSLINES.getId());
                        if (layer != null) {
                            layer.deleteAllGraphic();
                        }
                        MediaSeries s = pane.getSeries();
                        String fruid = (String)series.getTagValue(TagW.FrameOfReferenceUID);
                        if (s == null || fruid == null || !fruid.equals(s.getTagValue(TagW.FrameOfReferenceUID))) continue;
                        if (!ImageOrientation.hasSameOrientation((MediaSeries)series, (MediaSeries)s)) {
                            pane.setActionsInView(ActionW.SYNCH_CROSSLINE.cmd(), (Object)true);
                            this.propertySupport.addPropertyChangeListener(ActionW.SCROLL_SERIES.cmd(), (PropertyChangeListener)pane);
                        }
                        this.moveTroughSliceAction.stateChanged((BoundedRangeModel)this.moveTroughSliceAction.getModel());
                    }
                } else if (SynchView.Mode.Stack.equals((Object)synchView.getMode())) {
                    boolean hasLink = false;
                    String fruid = (String)series.getTagValue(TagW.FrameOfReferenceUID);
                    DicomImageElement img = (DicomImageElement)series.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
                    double[] val = img == null ? null : (double[])img.getTagValue(TagW.SlicePosition);
                    for (int i = 0; i < panes.size(); ++i) {
                        MediaSeries s;
                        DefaultView2d pane = (DefaultView2d)panes.get(i);
                        AbstractLayer layer = pane.getLayerModel().getLayer(Tools.CROSSLINES.getId());
                        if (layer != null) {
                            layer.deleteAllGraphic();
                        }
                        if ((s = pane.getSeries()) == null || fruid == null || val == null || !fruid.equals(s.getTagValue(TagW.FrameOfReferenceUID))) continue;
                        if (ImageOrientation.hasSameOrientation((MediaSeries)series, (MediaSeries)s)) {
                            hasLink = true;
                            pane.setActionsInView(ActionW.SYNCH_LINK.cmd(), (Object)true);
                            pane.setActionsInView(ActionW.SYNCH_CROSSLINE.cmd(), (Object)false);
                            if (EventManager.hasSameSize((MediaSeries<DicomImageElement>)series, (MediaSeries<DicomImageElement>)s)) {
                                this.addPropertyChangeListeners(pane, synchView);
                                continue;
                            }
                            this.propertySupport.addPropertyChangeListener(ActionW.SCROLL_SERIES.cmd(), (PropertyChangeListener)pane);
                            continue;
                        }
                        pane.setActionsInView(ActionW.SYNCH_LINK.cmd(), (Object)false);
                        pane.setActionsInView(ActionW.SYNCH_CROSSLINE.cmd(), (Object)true);
                        this.propertySupport.addPropertyChangeListener(ActionW.SCROLL_SERIES.cmd(), (PropertyChangeListener)pane);
                    }
                    viewPane.setActionsInView(ActionW.SYNCH_LINK.cmd(), (Object)hasLink);
                    this.moveTroughSliceAction.stateChanged((BoundedRangeModel)this.moveTroughSliceAction.getModel());
                } else if (SynchView.Mode.Tile.equals((Object)synchView.getMode())) {
                    for (int i = 0; i < panes.size(); ++i) {
                        DefaultView2d pane = (DefaultView2d)panes.get(i);
                        pane.setActionsInView(ActionW.SYNCH_LINK.cmd(), (Object)true);
                        pane.setActionsInView(ActionW.SYNCH_CROSSLINE.cmd(), (Object)false);
                        this.addPropertyChangeListeners(pane, synchView);
                    }
                }
            }
        }
    }

    public static boolean hasSameSize(MediaSeries<DicomImageElement> series1, MediaSeries<DicomImageElement> series2) {
        if (series1 != null && series2 != null) {
            DicomImageElement image1 = (DicomImageElement)series1.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
            DicomImageElement image2 = (DicomImageElement)series2.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
            if (image1 != null && image2 != null) {
                return image1.hasSameSize((ImageElement)image2);
            }
        }
        return false;
    }

    public void savePreferences() {
        Preferences prefs = Activator.PREFERENCES.getDefaultPreferences();
        this.viewSetting.savePreferences(prefs);
        this.mouseActions.savePreferences(prefs);
        if (prefs != null) {
            Preferences prefNode = prefs.node("mouse.sensivity");
            BundlePreferences.putDoublePreferences((Preferences)prefNode, (String)this.windowAction.getActionW().cmd(), (double)this.windowAction.getMouseSensivity());
            BundlePreferences.putDoublePreferences((Preferences)prefNode, (String)this.levelAction.getActionW().cmd(), (double)this.levelAction.getMouseSensivity());
            BundlePreferences.putDoublePreferences((Preferences)prefNode, (String)this.moveTroughSliceAction.getActionW().cmd(), (double)this.moveTroughSliceAction.getMouseSensivity());
            BundlePreferences.putDoublePreferences((Preferences)prefNode, (String)this.rotateAction.getActionW().cmd(), (double)this.rotateAction.getMouseSensivity());
            BundlePreferences.putDoublePreferences((Preferences)prefNode, (String)this.zoomAction.getActionW().cmd(), (double)this.zoomAction.getMouseSensivity());
        }
    }

    public void zoom(String[] argv) throws IOException {
        String[] usage = new String[]{"Change the zoom value of the selected image (0.0 is the best fit value in the window", "Usage: dicom:zoom [set | increase | decrease] [VALUE]", "  -s --set [decimal value]  set a new value from 0.0 to 12.0 (zoom magnitude, 0.0 is the best fit in window value)", "  -i --increase [integer value]  increase of some amount", "  -d --decrease [integer value]  decrease of some amount", "  -? --help       show help"};
        final Option opt = Options.compile((String[])usage).parse((Object[])argv);
        final List args = opt.args();
        if (opt.isSet("help") || args.isEmpty()) {
            opt.usage();
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (opt.isSet("increase")) {
                        int val = Integer.parseInt((String)args.get(0));
                        EventManager.this.zoomAction.setValue(EventManager.this.zoomAction.getValue() + val);
                    } else if (opt.isSet("decrease")) {
                        int val = Integer.parseInt((String)args.get(0));
                        EventManager.this.zoomAction.setValue(EventManager.this.zoomAction.getValue() - val);
                    } else if (opt.isSet("set")) {
                        double val = Double.parseDouble((String)args.get(0));
                        if (val == 0.0) {
                            EventManager.this.firePropertyChange(ActionW.ZOOM.cmd(), null, 0.0);
                        } else {
                            EventManager.this.zoomAction.setValue(EventManager.this.viewScaleToSliderValue(val));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void wl(String[] argv) throws IOException {
        String[] usage = new String[]{"Change the window/level values of the selected image", "Usage: dicom:wl -- [window integer value] [level integer value] (it is mantory to have -- for negative values)", "  -? --help       show help"};
        Option opt = Options.compile((String[])usage).parse((Object[])argv);
        final List args = opt.args();
        if (opt.isSet("help") || args.size() != 2) {
            opt.usage();
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int win = EventManager.this.windowAction.getValue() + Integer.parseInt((String)args.get(0));
                    int level = EventManager.this.levelAction.getValue() + Integer.parseInt((String)args.get(1));
                    EventManager.this.windowAction.setValue(win);
                    EventManager.this.levelAction.setValue(level);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void move(String[] argv) throws IOException {
        String[] usage = new String[]{"Change the pan value of the selected image", "Usage: dicom:move -- [x integer value] [y integer value] (it is mantory to have -- for negative values)", "  -? --help       show help"};
        Option opt = Options.compile((String[])usage).parse((Object[])argv);
        final List args = opt.args();
        if (opt.isSet("help") || args.size() != 2) {
            opt.usage();
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int valx = Integer.parseInt((String)args.get(0));
                    int valy = Integer.parseInt((String)args.get(1));
                    EventManager.this.panAction.setPoint((Point2D)new Point(valx, valy));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        SYNCH_LIST = new ArrayList();
        SYNCH_LIST.add(SynchView.NONE);
        SYNCH_LIST.add(SynchView.DEFAULT_STACK);
        SYNCH_LIST.add(SynchView.DEFAULT_TILE);
    }
}

