//=============================================================================
// vsprintf.c : 
// 2004/02/21 by Gaku

//
//	2004/06/14 custmize for amd64 by Sakky
//

//-----------------------------------------------------------------------------
#include <stdio.h>
#include <string.h>

//-----------------------------------------------------------------------------
#define FLG_LEFT  0x0001
#define FLG_ZERO  0x0002
#define FLG_EX    0x0004
#define FLG_OCT   0x0010
#define FLG_HEX   0x0020
#define FLG_UHEX  0x0040
#define FLG_LONG  0x0100
#define FLG_SHORT 0x0200

#define BUFSIZE 64
#define FLOAT_BUFSIZE 512

#define MAX_PRECISION 18
#define DEFAULT_PRECISION 6


//-----------------------------------------------------------------------------
static char lower_charset[] = "0123456789abcdef";
static char upper_charset[] = "0123456789ABCDEF";

static double scale_up1[] = {
		1.0e+0,
		1.0e+40,
		1.0e+80,
		1.0e+120,
		1.0e+160,
		1.0e+200,
		1.0e+240,
		1.0e+280
	};

static double scale_up2[] = {
		1.0e+0,
		1.0e+5,
		1.0e+10,
		1.0e+15,
		1.0e+20,
		1.0e+25,
		1.0e+30,
		1.0e+35
	};

static double scale_up3[] = {
		1.0e+0,
		1.0e+1,
		1.0e+2,
		1.0e+3,
		1.0e+4,
	};

static double scale_down1[] = {
		1.0e-0,
		1.0e-40,
		1.0e-80,
		1.0e-120,
		1.0e-160,
		1.0e-200,
		1.0e-240,
		1.0e-280
	};

static double scale_down2[] = {
		1.0e-0,
		1.0e-5,
		1.0e-10,
		1.0e-15,
		1.0e-20,
		1.0e-25,
		1.0e-30,
		1.0e-35
	};

static double scale_down3[] = {
		1.0e-0,
		1.0e-1,
		1.0e-2,
		1.0e-3,
		1.0e-4,
	};

//-----------------------------------------------------------------------------
static int search (double *p, int n, double v, int (*comp)(double, double))
{
	int a, b, c;

	a = 0;
	b = n;

	do {
		c = ( a + b ) / 2;

		if (comp(v, p[c])) {
			a = c;
		} else {
			b = c;
		}
	} while (a + 1 < b);

	return a;
}

//-----------------------------------------------------------------------------
static int comp_up (double a, double b)
{
	if (a >= b)
		return 1;
	return 0;
}

//-----------------------------------------------------------------------------
static int comp_down (double a, double b)
{
	if (a/10 <= b)
		return 1;
	return 0;
}

//-----------------------------------------------------------------------------
static char* itoa (char *p,
	unsigned long val, int base, int precision, char *charset)
{
	unsigned long l;

	if (0 != precision) {
		// 𕶎ɕϊ
		do {
			l = val / base;
			*--p = charset[val - l * base];
			val = l;
		} while (0 < val);
	}

	return p;
}

//-----------------------------------------------------------------------------
static int ftoa (char *p, double val)
{
	int (*comp)(double, double);
	double *tab1, *tab2, *tab3;
	double scale = 1.0e+0;
	char *tmp, *buf;
	unsigned long ul;
	int n, n1, n2, n3;

	if (scale > val) {
		tab1 = scale_down1;
		tab2 = scale_down2;
		tab3 = scale_down3;
		comp = comp_down;
	} else {
		tab1 = scale_up1;
		tab2 = scale_up2;
		tab3 = scale_up3;
		comp = comp_up;
	}

	// XP[킹
	n1 = search(tab1, sizeof(*tab1), val, comp);
	scale *= tab1[n1];
	n2 = search(tab2, sizeof(*tab2), val / scale, comp);
	scale *= tab2[n2];
	n3 = search(tab3, sizeof(*tab3), val / scale, comp);
	scale *= tab3[n3];

	// w擾
	n = 40 * n1 + 5 * n2 + n3;

	// 0.xxx ̌`ɍ킹
	val /= scale * 10;

	// UɗƂĂ當ɕϊ
	for (buf = p; buf < p + MAX_PRECISION; buf += 6) {
		val *= 1.0e+6;
		ul = (unsigned long)val;
		if (1000000 <= ul)
			ul = 999999;
		tmp = itoa(buf+6, ul, 10, 6, lower_charset);
		while (buf < tmp)
			*--tmp = '0';
		val -= ul;
	}

	return n;
}

//-----------------------------------------------------------------------------
static int round (char *p, int precision)
{
	char *tmp;

	if (MAX_PRECISION < precision)
		precision = MAX_PRECISION;

	tmp = p + precision-2;

	// ľܓ
	if ('5' <= tmp[1]) {
		tmp[1] = '0';
		tmp[0] += 1;
	}

	// Jグ
	while (p < tmp) {
		if ('9' >= *tmp)
			return 0;

		*tmp = '0';
		*--tmp += 1;
	}

	// ӂꂽƂm点
	*tmp = '1';

	return 1;
}

//-----------------------------------------------------------------------------
static int format_e (char *bf, char *p, double val, int precision, char e)
{
	char *tmp;
	int i, n;

	// x𐧌
	precision += 1;

	if (MAX_PRECISION < precision)
		precision = MAX_PRECISION;

	// 𕶎ɕϊ
	n = ftoa(p, val);
	if (round(p, precision+1)) {
		if (1.0e+0 > val)
			n--;
		else
			n++;
		val *= 10;
	}

	// 𕶎ɓWJ
	bf[0] = p[0];
	bf[1] = '.';

	for (i = 2; i < precision+1; i++)
		bf[i] = p[i-1];

	// e 
	bf[i++] = e;

	// w̕
	if (1.0e+0 > val)
		bf[i++] = '-';
	else
		bf[i++] = '+';

	// w𕶎ɓWJ
	tmp = p + BUFSIZE;
	p = itoa(tmp, n, 10, BUFSIZE, lower_charset);

	// w͕KR
	while (p > tmp-3)
		*--p = '0';

	// wRs[
	while (p < tmp)
		bf[i++] = *p++;

	return i;
}

//-----------------------------------------------------------------------------
static int format_f (char *bf, char *p, double val, int precision)
{
	int i, j, k, m, n;

	// x𐧌
	if (MAX_PRECISION < precision)
		precision = MAX_PRECISION;

	// 𕶎ɕϊ
	n = ftoa(p, val);

	// ۂ߈ʒuvZ
	if (1.0e+0 > val) {
		k = precision - ( n-1 );
	} else {
		k = n+1 + precision;
		if (MAX_PRECISION < k)
			k = MAX_PRECISION;
	}

	// ۂ߂
	if (0 < k) {
		if (round(p, k+1)) {
			if (1.0e+0 > val)
				n--;
			else
				n++;
			val *= 10;
		}
	}

	if (1.0e+0 > val) {
		// 1.0 菬ꍇ
		bf[0] = '0';
		bf[1] = '.';

		m = n-1;
		if (precision < m)
			m = precision;

		for (k = 0; k < m; k++)
			bf[2+k] = '0';

		for (j = 0; k+j < precision; j++)
			bf[2+k+j] = p[j];

		i = 2+k+j;
	} else {
		// 1.0 傫ꍇ
		m = n+1;
		if (MAX_PRECISION < m)
			m = MAX_PRECISION;

		for (j = 0; j < m; j++)
			bf[j] = p[j];

		for (k = j; k < n+1; k++)
			bf[k] = '0';

		if (0 < precision) {
			bf[k++] = '.';

			for (i = 0; i < precision; i++) {
				if (MAX_PRECISION > j+i)
					bf[k++] = p[j+i];
				else
					bf[k++] = '0';
			}
		}

		i = k;
	}

	return i;
}

//-----------------------------------------------------------------------------
static int format (char *bf,
	char *p, int len, int flag, char sign, int width, int precision)
{
	int olen;
	int i, n = 0;

	// ̌vZ
	if (len < precision)
		olen = precision;
	else
		olen = len;

	// El () ̏ꍇɁA󔒂u
	if (0 == ( flag & ( FLG_LEFT | FLG_ZERO ) )) {
		while (n < width - olen)
			bf[n++] = ' ';
	}

	if ('\0' != sign) {
		// t
		bf[n++] = sign;
	} else {
		// vtBbNXt
		if (0 != ( flag & ( FLG_OCT | FLG_HEX | FLG_UHEX ) )) {
			bf[n++] = '0';

			if (FLG_HEX & flag)
				bf[n++] = 'x';
			else if (FLG_UHEX & flag)
				bf[n++] = 'X';
		}
	}

	// El ([) ̏ꍇɁA[u
	if (FLG_ZERO == ( flag & ( FLG_LEFT | FLG_ZERO ) )) {
		while (n < width - olen)
			bf[n++] = '0';
	}

	// x킹̃[u
	while (n < precision - len) {
		bf[n++] = '0';
	}

	// {̏o
	for (i = 0; i < len; i++) {
		bf[n++] = p[i];
	}

	// l߂̏ꍇA󔒂u
	if (flag & FLG_LEFT) {
		while (n < width)
			bf[n++] = ' ';
	}

	return n;
}

//-----------------------------------------------------------------------------
static int format_float (char *bf, char *p,
	double value, char fmt, int flag, char sign, int width, int precision)
{
	char buffer[FLOAT_BUFSIZE];
	int n = 0, n1, n2;

	// ̔
	if (0 > value) {
		value = -value;
		sign = '-';
	}

	switch (fmt) {
	case 'e':
	case 'E':
		n = format_e(buffer, p, value, precision, fmt);
		n = format(bf, buffer, n, flag & ~FLG_ZERO, sign, width, -1);
		break;
	case 'f':
		n = format_f(buffer, p, value, precision);
		n = format(bf, buffer, n, flag & ~FLG_ZERO, sign, width, -1);
		break;
	case 'g':
	case 'G':
		n1 = format_e(buffer, p, value, precision, fmt-'g'+'e');
		n2 = format_f(buffer, p, value, precision);

		// 񂪒ZȂ̗p
		if (n1 < n2) {
			n = format_e(buffer, p, value, precision, fmt-'g'+'e');
			n = format(bf, buffer, n, flag & ~FLG_ZERO, sign, width, -1);
		} else {
			n = format_f(buffer, p, value, precision);
			n = format(bf, buffer, n, flag & ~FLG_ZERO, sign, width, -1);
		}
		break;
	}

	return n;
}


//=============================================================================
int vsprintf (char *bf, char *form, va_list args)
{
	char buffer[BUFSIZE];
	char *end = buffer + BUFSIZE;
	char *fmt, *p;
	long l;
	unsigned long ul;
	double d;
	int n = 0;

	for (fmt = form; ; fmt++) {

		int flag = 0;
		int width = 0;
		int precision = -1;
		char sign = '\0';

		// % ܂ł̓Rs[
		while ('\0' != *fmt && '%' != *fmt) {
			bf[n++] = *fmt++;
		}

		// I
		if ('%' != *fmt)
			break;

		// tOǂݍ
		for (fmt++; ; fmt++) {
			if ('-' == *fmt)
				flag |= FLG_LEFT;
			else if ('+' == *fmt)
				sign = '+';
			else if ('0' == *fmt)
				flag |= FLG_ZERO;
			else if (' ' == *fmt && '+' != sign )
				sign = ' ';
			else if ('#' == *fmt)
				flag |= FLG_EX;
			else
				break;
		}

		// w
		if ('1' <= *fmt && '9' >= *fmt) {

			// ڎw̏ꍇ
			int i = 0;

			do {
				i *= 10;
				i += *fmt++ - '0';
			} while ('0' <= *fmt && '9' >= *fmt);

			width = i;

		} else if ('*' == *fmt) {

			// w肳ꍇ
			width = va_arg(args,int);

			if (0 > width)
				flag |= FLG_LEFT;

			fmt++;
		}

		// xw
		if ('.' == *fmt) {
			fmt++;
			if ('0' <= *fmt && '9' >= *fmt) {

				// ڎw
				int i = 0;

				do {
					i *= 10;
					i += *fmt++ - '0';
				} while ('0' <= *fmt && '9' >= *fmt);

				precision = i;

			} else if ('*' == *fmt) {

				// w
				precision = va_arg(args,int);

				fmt++;
			}
		}

		// vtBbNXǂݍ
		if ('h' == *fmt) {
			flag |= FLG_SHORT;
			fmt++;
		} else if ('l' == *fmt) {
			flag |= FLG_LONG;
			fmt++;
		} else if ('I' == *fmt) {
			flag |= FLG_LONG;
			fmt++;
		}

		// ^Cvw - K{
		switch (*fmt) {
		case 'c':
			// o
			buffer[0] = (char)va_arg(args,int);
			n += format(bf+n, buffer, 1, flag & ~FLG_ZERO, '\0', width, -1);
			break;
		case 'd':
		case 'i':
			// tPOi
			l = va_arg(args,long);
			if (0 > l) {
				sign = '-';
				l = -l;
			}
			p = itoa(end, l, 10, precision, lower_charset);
			n += format(bf+n, p, end-p, flag, sign, width, precision);
			break;
		case 'o':
			// Wi
			ul = va_arg(args,unsigned long);
			if (FLG_EX & flag)
				flag |= FLG_OCT;
			p = itoa(end, ul, 8, precision, lower_charset);
			n += format(bf+n, p, end-p, flag, sign, width, precision);
			break;
		case 'u':
			// POi
			ul = va_arg(args,unsigned long);
			p = itoa(end, ul, 10, precision, lower_charset);
			n += format(bf+n, p, end-p, flag, sign, width, precision);
			break;
		case 'p':
			// |C^
			if (-1 == precision)
				precision = 2*sizeof(void*);
		case 'x':
			// PUi
			ul = va_arg(args,unsigned long);
			if (FLG_EX & flag)
				flag |= FLG_HEX;
			p = itoa(end, ul, 16, precision, lower_charset);
			n += format(bf+n, p, end-p, flag, sign, width, precision);
			break;
		case 'X':
			ul = va_arg(args,unsigned long);
			if (FLG_EX & flag)
				flag |= FLG_UHEX;
			p = itoa(end, ul, 16, precision, upper_charset);
			n += format(bf+n, p, end-p, flag, sign, width, precision);
			break;
		case 'e':
		case 'E':
		case 'f':
		case 'g':
		case 'G':
			// _
			d = va_arg(args,double);
			p = buffer;
			if (-1 == precision)
				precision = DEFAULT_PRECISION;
			n += format_float(bf+n, p, d, *fmt, flag, sign, width, precision);
			break;
//		case 'n':
//			// 擾
//			set_signed(n, &args, flag);
//			break;
		case 's':
			// o
			p = va_arg(args,char*);

			if (NULL == p)
				p = "(null)";

			l = strlen(p);
			if (-1 == precision || precision > l)
					precision = l;

			n += format(bf+n, p, l, flag & ~FLG_ZERO, '\0', width, precision);
			break;
		default:
			// ̂ق
			bf[n++] = *fmt;
			break;
		}
	}

	bf[n] = '\0';

	return n;
}


int sprintf (char *bf, char *form, ...){
	int r;
	va_list args;
	va_start(args,form);
	r=vsprintf(bf,form,args);
	va_end(args);
	return r;
}
