/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.phalanx;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.phalanx.binding.condition.Condition;
import org.logical_paradox.phalanx.binding.resultset.ResultSet;

/**
 * XMLhLgvZbT
 * XMLŎw肳ꂽāAK؂ȌT[rXɗv𔭍s
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public class DocumentProcessor {
	public static final String PHALANX_JAXB_PACKAGE_NAME = "org.logical_paradox.phalanx.binding";

	/** K[ */
	private static Log log = LogFactory.getLog(DocumentProcessor.class);

	/** A}[V[̑ */
	private JAXBContext conditionCtx;
	private JAXBContext resultSetCtx;
	private Unmarshaller conditionUnmarshaller;
	private Marshaller resultSetMarshaller;
	private String configDir;

	/**
	 * RXgN^
	 * @param dsruri DSRURI
	 * @param xmlEncoding XML̃GR[fBO
	 * @param configDir RtBOt@Ci[fBNg
	 * @throws RemoteException DSR̃X^u擾łȂ
	 */
	private DocumentProcessor(String dsruri, String xmlEncoding, String configDir) throws Exception {
		/*
		 * A}[V[̑̍쐬
		 * XML؋@\A}[V[쐬
		 */
		conditionCtx = JAXBContext.newInstance(PHALANX_JAXB_PACKAGE_NAME + ".condition");
		resultSetCtx = JAXBContext.newInstance(PHALANX_JAXB_PACKAGE_NAME + ".resultset");
		conditionUnmarshaller = conditionCtx.createUnmarshaller();
		conditionUnmarshaller.setValidating(true);

		resultSetMarshaller = resultSetCtx.createMarshaller();
		resultSetMarshaller.setProperty(Marshaller.JAXB_ENCODING, xmlEncoding);
		resultSetMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);

		this.configDir = configDir;
	}
	/**
	 * hLgvZbT쐬
	 * hLgvZbT̃CX^X́C̃\bhĂяoтɍ쐬D<br>
	 * hLgvZbTɊ֘AÂĂ郋bNAbvT[rX́Ĉ̂ėpD
	 * @param dsruri DSRURI
	 * @param xmlEncoding ʂ̏o̓GR[fBO
	 * @param configDir RtBOt@Ci[fBNg
	 * @return ꂽhLgvZbT
	 * @throws Exception
	 */
	public static DocumentProcessor newInstance(String dsruri, String xmlEncoding, String configDir) throws Exception {
		return new DocumentProcessor(dsruri, xmlEncoding, configDir);
	}
	/**
	 * s
	 * @param query ₢킹d(XML)
	 * @return ʓd(XML)
	 * @throws JAXBException XMLhLg̃A}[VɎs
	 */
	public String search(String query) throws Exception {
		log.info("***** ₢킹d܂: " + query);

		ByteArrayInputStream istream = new ByteArrayInputStream(query.getBytes("ISO-8859-1"));

		// XMLA}[VO
		Condition condition = (Condition)conditionUnmarshaller.unmarshal(istream);

		// T[o[ɖ₢킹
		SearchLogic logic = SearchLogicFactory.getSearchLogic(condition);
		log.info("***** WbN[" + logic.getLogicIdentifier() + "]I܂");

		// 
		ResultSet searchResult = logic.search(condition, configDir);

		// ʂXMLɕϊĕԂ
		StringWriter buffer = new StringWriter();
		resultSetMarshaller.marshal(searchResult, buffer);

		log.info("***** ʂo͂܂: " + buffer.toString());

		return buffer.toString();
	}
}
