/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search.lo;

import java.util.Iterator;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperator;

public class SeqLogicalOperator
implements LogicalOperator {
    public KoikeIndexResultSet[] execute(KoikeIndexResultSet[] resultset) throws LogicalOperationException {
        if (resultset == null || resultset.length == 0) {
            return null;
        }
        if (resultset.length == 1) {
            return new KoikeIndexResultSet[]{resultset[0]};
        }
        KoikeIndexResultSet base = resultset[0];
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        Iterator it = base.iteratorInvertedIndexes();
        while (it.hasNext()) {
            InvertedIndex iidx = new InvertedIndex((InvertedIndex)it.next());
            Iterator locations = iidx.iteratorLocations();
            while (locations.hasNext()) {
                Location location = (Location)locations.next();
                int offset = location.getOffset() + 1;
                boolean found = true;
                int i = 1;
                while (found && i < resultset.length) {
                    if (!resultset[i].isLocated(location.getNodeId(), location.getDocno(), offset)) {
                        found = false;
                    }
                    ++i;
                    ++offset;
                }
                if (found) continue;
                iidx.removeLocation(location);
            }
            if (iidx.getDocumentAvailability() <= 0L) continue;
            rs.addInvertedIndex(iidx);
        }
        if (rs.isEmpty()) {
            return null;
        }
        KoikeIndexResultSet[] result = new KoikeIndexResultSet[]{rs};
        return result;
    }
}

