/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search.lo;

import java.util.HashMap;
import java.util.Iterator;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperator;

public class AndLogicalOperator
implements LogicalOperator {
    public KoikeIndexResultSet[] execute(KoikeIndexResultSet[] resultset) throws LogicalOperationException {
        if (resultset == null || resultset.length == 0) {
            return null;
        }
        if (resultset.length == 1) {
            return resultset;
        }
        HashMap<String, InvertedIndex> map = new HashMap<String, InvertedIndex>();
        Iterator it = resultset[0].iteratorInvertedIndexes();
        while (it.hasNext()) {
            InvertedIndex iidx = (InvertedIndex)it.next();
            InvertedIndex newIidx = new InvertedIndex(iidx);
            map.put(iidx.getNodeId() + ":" + iidx.getBlockNo(), newIidx);
        }
        KoikeIndexResultSet[] results = new KoikeIndexResultSet[resultset.length];
        KoikeIndexResultSet resultSet = new KoikeIndexResultSet();
        for (int i = 1; i < resultset.length; ++i) {
            KoikeIndexResultSet rs = resultset[i];
            try {
                results[i] = (KoikeIndexResultSet)rs.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new LogicalOperationException(e);
            }
            boolean found = false;
            Iterator it2 = rs.iteratorInvertedIndexes();
            while (it2.hasNext()) {
                InvertedIndex iidx = (InvertedIndex)it2.next();
                InvertedIndex invertedIndex = (InvertedIndex)map.get(iidx.getNodeId() + ":" + iidx.getBlockNo());
                if (invertedIndex != null && (invertedIndex.getDocumentAvailability() & iidx.getDocumentAvailability()) > 0L) {
                    found = true;
                    long documents = invertedIndex.getDocumentAvailability() & iidx.getDocumentAvailability();
                    invertedIndex.setDocumentAvailability(documents);
                    resultSet.addInvertedIndex(invertedIndex);
                    continue;
                }
                if (invertedIndex != null) {
                    map.remove(invertedIndex.getNodeId() + ":" + invertedIndex.getBlockNo());
                    resultSet.removeInvertedIndex(invertedIndex);
                }
                map.remove(iidx.getNodeId() + ":" + iidx.getBlockNo());
                results[i].removeInvertedIndex(iidx);
            }
            if (found) continue;
            map = null;
            return null;
        }
        for (InvertedIndex iidx : map.values()) {
            for (int i = 1; i < results.length; ++i) {
                InvertedIndex target = results[i].getInvertedIndex(iidx);
                if (target != null) {
                    results[i].getInvertedIndex(iidx).setDocumentAvailability(iidx.getDocumentAvailability());
                    continue;
                }
                resultSet.removeInvertedIndex(target);
            }
        }
        results[0] = resultSet;
        return results;
    }
}

