/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.summary;

import java.util.ArrayList;
import java.util.Collections;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.summary.SummaryGenerator;

public class DefaultSummaryGenerator
implements SummaryGenerator {
    public static final int DEFAULT_SUMMARY_LENGTH = 100;
    private final int summaryLength;

    public DefaultSummaryGenerator() {
        this.summaryLength = 100;
    }

    public DefaultSummaryGenerator(int summaryLength_) {
        this.summaryLength = summaryLength_;
    }

    public String createSummary(String document, String[] terms) {
        Integer[] locations = null;
        ArrayList<Location> summaryStartPoints = new ArrayList<Location>();
        for (int i = 0; i < terms.length; ++i) {
            locations = StringUtils.searchWordIndexes((String)document, (String)terms[i]);
            for (int j = 0; j < locations.length; ++j) {
                summaryStartPoints.add(new Location(i, terms[i], locations[j]));
            }
        }
        if (summaryStartPoints.size() == 0) {
            return "";
        }
        Collections.sort(summaryStartPoints);
        Location[] summaryStartPoint = summaryStartPoints.toArray(new Location[0]);
        ArrayList<EvaluationPoint> evals = new ArrayList<EvaluationPoint>();
        String candidate = null;
        for (int i = 0; i < summaryStartPoint.length; ++i) {
            candidate = document.substring(summaryStartPoint[i].pos);
            if (candidate.length() > this.summaryLength) {
                candidate = candidate.substring(0, this.summaryLength);
            } else if (candidate.length() < this.summaryLength) {
                int pos = document.length() - this.summaryLength;
                if (pos < 0) {
                    pos = 0;
                }
                candidate = document.substring(pos);
            }
            evals.add(this.eval(candidate, summaryStartPoint[i].pos, terms));
        }
        Collections.sort(evals);
        EvaluationPoint best = (EvaluationPoint)evals.get(0);
        StringBuffer sb = new StringBuffer();
        String summary = best.getSummary();
        if (!document.startsWith(summary)) {
            sb.append("..");
        }
        sb.append(summary);
        if (!document.endsWith(summary)) {
            sb.append("..");
        }
        return sb.toString();
    }

    protected EvaluationPoint eval(String summary, int pos, String[] terms) {
        int occupied = 0;
        int variation = 0;
        String remain = summary;
        for (int i = 0; i < terms.length; ++i) {
            occupied += StringUtils.searchWordIndexes((String)summary, (String)terms[i]).length * terms[i].length();
            String replaced = remain.replaceAll(terms[i], "");
            if (replaced.length() >= remain.length()) continue;
            ++variation;
        }
        int distance = occupied * 100 / summary.length();
        return new EvaluationPoint(summary, pos, distance, variation * 100 / terms.length);
    }

    class EvaluationPoint
    implements Comparable {
        private String summary;
        private int pos;
        private int distance;
        private int variation;
        private int locationScore;

        public EvaluationPoint(String summary_, int pos_, int distance_, int variation_) {
            this.summary = summary_;
            this.pos = pos_;
            this.distance = distance_;
            this.variation = variation_;
            this.computeTotalScore();
        }

        public String getSummary() {
            return this.summary;
        }

        protected void computeTotalScore() {
            this.locationScore = this.distance + this.variation * 9;
        }

        public int compareTo(Object o) {
            EvaluationPoint e = (EvaluationPoint)o;
            if (e.getLocationScore() == this.getLocationScore()) {
                return 0;
            }
            if (e.getLocationScore() > this.getLocationScore()) {
                return 1;
            }
            return -1;
        }

        public int getLocationScore() {
            return this.locationScore;
        }

        public int getPos() {
            return this.pos;
        }

        public int getDistanceScore() {
            return this.distance;
        }

        public int getVariationScore() {
            return this.variation;
        }
    }

    class Location
    implements Comparable {
        final int index;
        final String term;
        final int pos;

        public Location(int index_, String term_, int pos_) {
            this.index = index_;
            this.term = term_;
            this.pos = pos_;
        }

        public int compareTo(Object o) {
            Location l = (Location)o;
            if (l.pos == this.pos) {
                return 0;
            }
            if (this.pos < l.pos) {
                return -1;
            }
            return 1;
        }
    }
}

