/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.indexer;

import java.io.FileInputStream;
import java.util.Properties;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.indexer.IndexerThread;
import org.logical_paradox.koike.core.logging.LogFactory;
import org.logical_paradox.koike.core.logging.Logger;

public class Indexer {
    private Logger log = LogFactory.getLogger();
    private KoikeConfig config;
    private IndexerThread[] indexers;

    public void loadConfig(String filename) throws Exception {
        this.log.write("**** \u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u30ed\u30fc\u30c9\u3057\u3066\u3044\u307e\u3059 ****");
        Properties prop = new Properties();
        prop.load(new FileInputStream(filename));
        this.config = new KoikeConfig(prop);
    }

    public void begin() throws Exception {
        int i;
        this.log.write("**** \u30a4\u30f3\u30c7\u30af\u30b5\u3092\u958b\u59cb\u3057\u3066\u3044\u307e\u3059 ****");
        int threadCount = this.config.getIndexerThreads();
        this.log.write("**** \u30a4\u30f3\u30c7\u30af\u30b5\u3092" + threadCount + "\u500b\u751f\u6210\u3057\u307e\u3057\u305f ****");
        this.indexers = new IndexerThread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            this.indexers[i] = new IndexerThread(this.config);
            this.indexers[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            this.indexers[i].join();
        }
        this.log.write("**** \u30a4\u30f3\u30c7\u30af\u30b5\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f ****");
    }

    public static void main(String[] args) throws Exception {
        Indexer indexer = new Indexer();
        String configfilename = null;
        configfilename = args.length == 0 ? "conf/koike.conf" : args[0];
        indexer.loadConfig(configfilename);
        indexer.begin();
    }
}

