/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.logical_paradox.koike.core.ConcreteInterfaceFactory;
import org.logical_paradox.koike.core.KoikeConfigException;
import org.logical_paradox.koike.core.search.SearchEngine;

public class KoikeConfig {
    public static final int DEFAULT_INDEXER_THREADS = 3;
    public static final int DEFAULT_N_GRAM_TERM_LENGTH = 2;
    private Properties masterProperty;
    private SearchEngine searchEngine;
    private ConcreteInterfaceFactory interfaceFactory;
    private String initialParameter;
    private boolean waitOnEmpty = false;
    private int indexerThreads = 3;
    private int ngramTermLength = 2;

    public KoikeConfig(Properties prop) throws KoikeConfigException {
        this.marshall(prop);
    }

    protected void marshall(Properties prop) throws KoikeConfigException {
        this.masterProperty = prop;
        try {
            String factoryName = prop.getProperty("INTERFACE_FACTORY");
            if (factoryName == null || factoryName.trim().length() == 0) {
                throw new IllegalArgumentException("\u5fc5\u9808\u9805\u76ee[INTERFACE_FACTORY]\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            Constructor<?> constructor = Class.forName(factoryName).getConstructor(String.class);
            this.initialParameter = prop.getProperty("INTERFACE_FACTORY_INITPARAM");
            this.interfaceFactory = (ConcreteInterfaceFactory)constructor.newInstance(this.initialParameter);
            String ngramTermLengthStr = prop.getProperty("N_GRAM_TERM_LENGTH");
            this.ngramTermLength = ngramTermLengthStr == null || ngramTermLengthStr.trim().length() == 0 ? 2 : Integer.parseInt(ngramTermLengthStr);
            String threadCountStr = prop.getProperty("INDEXER_THREADS");
            this.indexerThreads = threadCountStr != null && threadCountStr.trim().length() > 0 ? Integer.parseInt(threadCountStr) : 3;
            String waitOnEmptyStr = prop.getProperty("WAIT_ON_EMPTY");
            this.waitOnEmpty = waitOnEmptyStr != null && waitOnEmptyStr.trim().length() > 0 ? Boolean.valueOf(waitOnEmptyStr) : false;
        }
        catch (Exception e) {
            throw new KoikeConfigException(e);
        }
    }

    public int getIndexerThreads() {
        return this.indexerThreads;
    }

    public String getInitialParameter() {
        return this.initialParameter;
    }

    public ConcreteInterfaceFactory getInterfaceFactory() {
        return this.interfaceFactory;
    }

    public int getNgramTermLength() {
        return this.ngramTermLength;
    }

    public SearchEngine getSearchEngine() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String searchEngineClass;
        if (this.searchEngine == null && (searchEngineClass = this.masterProperty.getProperty("SEARCH_ENGINE_CLASS")) != null && searchEngineClass.trim().length() > 0) {
            Class<?> clazz = Class.forName(searchEngineClass);
            Constructor<?> cstr = clazz.getConstructor(KoikeConfig.class);
            this.searchEngine = (SearchEngine)cstr.newInstance(this);
        }
        return this.searchEngine;
    }

    public boolean isWaitOnEmpty() {
        return this.waitOnEmpty;
    }
}

