/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.cli.Argument;
import org.logical_paradox.common.cli.ArgumentParser;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueue;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.router.RNodeClientFactory;
import org.logical_paradox.rss.router.RSSRoutingNodeConfig;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.router.RoutingNodeClientImpl;
import org.logical_paradox.rss.router.algorithm.AllocatingAlgorithm;
import org.logical_paradox.rss.router.algorithm.AllocationException;

public class RNodeClientFactoryImpl
extends UnicastRemoteObject
implements RNodeClientFactory,
RSSSubModule {
    private static final long serialVersionUID = -1646722572391043386L;
    private static final Log log = LogFactory.getLog(RNodeClientFactoryImpl.class);
    public static final String RSS_ROUTING_NODE_CONFIG = "../conf/rssroutingfactory.conf";
    private String rnodeConfigFilename = "../conf/rssroutingfactory.conf";
    private Hashtable<String, RoutingNodeClient> searchNodes = null;
    private String factoryServiceName = null;
    private RSSRoutingNodeConfig config = null;
    private URLPool unTracedURLs = null;
    private SyncQueue syncQueue = new SyncQueue();
    private SyncQueue rejectedCommandQueue = new SyncQueue();
    private AllocatingAlgorithm allocater = null;
    private String DSRURL;

    public RNodeClientFactoryImpl() throws RemoteException {
    }

    public RNodeClientFactoryImpl(String filename) throws RemoteException {
        this.rnodeConfigFilename = filename;
    }

    public void init(String dsrurl) throws RemoteException {
        this.DSRURL = dsrurl;
        if (this.DSRURL == null || this.DSRURL.trim().length() == 0) {
            throw new RemoteException("dsr service name is empty");
        }
        this.unTracedURLs = new URLPool();
        this.searchNodes = new Hashtable();
        try {
            log.info((Object)("\u5206\u6563\u30b5\u30fc\u30d3\u30b9\u30ec\u30b8\u30b9\u30c8\u30ea'" + this.DSRURL + "'\u306b\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u3057\u3066\u3044\u307e\u3059"));
            this.factoryServiceName = LookupFactory.getLookup(this.DSRURL).bind(10, this);
            log.info((Object)("\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9: " + this.getNodeId()));
            log.info((Object)"\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u306b\u6210\u529f\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            log.info((Object)"\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            throw (RemoteException)e;
        }
    }

    public String getNodeId() throws RemoteException {
        return this.factoryServiceName;
    }

    public RoutingNodeClient bindSearchNode() throws RemoteException {
        log.info((Object)"\u63a2\u7d22\u30ce\u30fc\u30c9\u3092\u30d0\u30a4\u30f3\u30c9\u3057\u3066\u3044\u307e\u3059");
        RoutingNodeClient client = this.attachSearchNode();
        try {
            log.info((Object)("\u63a2\u7d22\u30ce\u30fc\u30c9\u304c\uff0c\u540d\u524d'" + client.getNodeId() + "'\u3068\u3057\u3066\u767b\u9332\u3055\u308c\u307e\u3057\u305f"));
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return client;
    }

    public void unbindSearchNode(String robotId) throws RemoteException {
        log.info((Object)("\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u3092\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059"));
        boolean exitf = true;
        if (this.detachSearchNode(robotId)) {
            exitf = false;
        }
        if (exitf) {
            log.info((Object)("\u7ba1\u7406\u3055\u308c\u3066\u3044\u306a\u3044\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u3092\u5207\u308a\u96e2\u305d\u3046\u3068\u3057\u307e\u3057\u305f"));
            throw new RemoteException("no routing manager manages the robot '" + robotId + "'.");
        }
        log.info((Object)("\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u304c\u5207\u308a\u96e2\u3055\u308c\u307e\u3057\u305f"));
    }

    public RoutingNodeClient attachSearchNode() throws RemoteException {
        RoutingNodeClientImpl rn = new RoutingNodeClientImpl(this);
        this.searchNodes.put(rn.getNodeId(), rn);
        this.allocater.addChildNode(rn.getNodeId());
        return rn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detachSearchNode(String robotId) {
        boolean rc = false;
        Hashtable<String, RoutingNodeClient> hashtable = this.searchNodes;
        synchronized (hashtable) {
            RoutingNodeClient rnc = this.searchNodes.get(robotId);
            if (rnc == null || this.searchNodes.remove(robotId) == null) {
                rc = false;
            } else {
                this.allocater.removeChildNode(robotId);
                try {
                    UnicastRemoteObject.unexportObject(rnc, true);
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                rc = true;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnTracedURL(String url) throws RemoteException {
        try {
            URLPool uRLPool = this.unTracedURLs;
            synchronized (uRLPool) {
                this.unTracedURLs.remove(url);
            }
        }
        catch (MalformedURLException ue) {
            throw new RemoteException(ue.getMessage());
        }
    }

    public void addUnTracedURL(String url) throws RemoteException {
        try {
            this.unTracedURLs.add(url);
        }
        catch (MalformedURLException ue) {
            throw new RemoteException(ue.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateURL() {
        try {
            URLPool uRLPool = this.unTracedURLs;
            synchronized (uRLPool) {
                String[] domains = this.unTracedURLs.domains();
                for (int i = 0; i < domains.length; ++i) {
                    String domain = domains[i];
                    String[] urls = this.unTracedURLs.urls(domain);
                    for (int j = 0; j < urls.length; ++j) {
                        try {
                            String destNodeId = this.allocater.allocate(urls[j]);
                            this.rejectedCommandQueue.add(new SyncCommand((Serializable)((Object)urls[j]), 3, this.getNodeId(), destNodeId));
                            this.unTracedURLs.remove(urls[j]);
                            continue;
                        }
                        catch (RemoteException re) {
                            re.printStackTrace();
                            continue;
                        }
                        catch (AllocationException ae) {
                            ae.printStackTrace();
                            continue;
                        }
                        catch (SyncQueueException se) {
                            continue;
                        }
                        catch (MalformedURLException ue) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String[] getAllowedRoutingIPRanges() throws RemoteException {
        return this.config.getRoutingIPRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClientNames() throws RemoteException {
        Vector<String> tmp = new Vector<String>();
        Hashtable<String, RoutingNodeClient> hashtable = this.searchNodes;
        synchronized (hashtable) {
            Enumeration<String> e = this.searchNodes.keys();
            while (e.hasMoreElements()) {
                tmp.addElement(e.nextElement().toString());
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        return tmp.toArray(new String[1]);
    }

    public SyncCommand[] getModifiedSyncData(String rk) throws RemoteException {
        this.allocateURL();
        SyncCommand[] o = this.rejectedCommandQueue.get(rk);
        this.rejectedCommandQueue.clear(rk);
        return o;
    }

    public void sync(SyncCommand[] locks) throws Exception {
        if (locks == null || locks.length == 0) {
            return;
        }
        log.info((Object)(locks.length + "\u4ef6\u306e\u540c\u671f\u30c7\u30fc\u30bf\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f"));
        Vector<SyncCommand> receivedCommands = new Vector<SyncCommand>(Arrays.asList(locks));
        SyncCommand[] rejectedCommands = this.syncQueue.add(locks);
        receivedCommands.removeAll(Arrays.asList(rejectedCommands));
        for (int i = 0; i < receivedCommands.size(); ++i) {
            SyncCommand command = receivedCommands.elementAt(i);
            if (command.getType() == 3) {
                this.unTracedURLs.add((String)command.getObject());
                continue;
            }
            if (command.getType() != 255) continue;
            this.rejectedCommandQueue.add(command);
        }
        this.rejectedCommandQueue.add(rejectedCommands);
    }

    public static void main(String[] args) {
        try {
            Argument[] arguments = ArgumentParser.parse((String[])args);
            String filename = null;
            for (int i = 0; i < arguments.length; ++i) {
                Argument arg = arguments[i];
                if (!arg.isOption() || !"config".equals(arg.getName())) continue;
                filename = arg.getValue();
            }
            RNodeClientFactoryImpl factory = null;
            factory = filename == null ? new RNodeClientFactoryImpl() : new RNodeClientFactoryImpl(filename);
            factory.startModule();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void startModule() throws ModuleException {
        try {
            RSSRoutingNodeConfig conf = new RSSRoutingNodeConfig(this.rnodeConfigFilename);
            this.init(conf.getRSSDSR());
            this.allocater = conf.getAllocatingAlgorithm();
            this.allocater.setRoutingAlgorithm(conf.getRoutingAlgorithm());
            String defaultURLsLine = conf.getRSSFactoryDefaultURLs();
            if (defaultURLsLine != null) {
                String[] defaultURLs = defaultURLsLine.split(",");
                for (int i = 0; i < defaultURLs.length; ++i) {
                    this.addUnTracedURL(defaultURLs[i]);
                }
            }
            this.config = conf;
            log.info((Object)("IP\u30a2\u30c9\u30ec\u30b9\u7bc4\u56f2\u8a2d\u5b9a: \u5168" + conf.getRoutingIPRanges().length + "\u4ef6"));
            log.info((Object)("RNodeClientFactory '" + this.factoryServiceName + "' is started"));
            log.info((Object)("\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30d5\u30a1\u30af\u30c8\u30ea\u30b5\u30fc\u30d3\u30b9'" + this.factoryServiceName + "'\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f"));
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public String getName() throws RemoteException {
        return this.factoryServiceName;
    }

    public String getFqsn() throws RemoteException {
        return this.factoryServiceName + "@" + this.config.getRSSDSR();
    }

    public void shutdown(boolean force) throws RemoteException {
        log.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059");
        String[] clientNodes = this.getClientNames();
        if (clientNodes != null && clientNodes.length > 0) {
            log.info((Object)"\u63a2\u7d22\u30ce\u30fc\u30c9\u306e\u505c\u6b62\u3092\u5f85\u3063\u3066\u3044\u307e\u3059..");
            SyncCommand[] commands = new SyncCommand[clientNodes.length];
            for (int i = 0; i < clientNodes.length; ++i) {
                SyncCommand cmd = new SyncCommand();
                cmd.setType(255);
                cmd.setTo(clientNodes[i]);
                cmd.setFrom(this.getNodeId());
                cmd.setObject((Serializable)((Object)clientNodes[i]));
                commands[i] = cmd;
            }
            try {
                this.sync(commands);
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteException(e.getMessage());
            }
            log.info((Object)"\u63a2\u7d22\u30ce\u30fc\u30c9\u304c\u5168\u3066\u505c\u6b62\u3057\u307e\u3057\u305f");
        }
        try {
            while (this.searchNodes.size() > 0) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)"\u63a2\u7d22\u30ce\u30fc\u30c9\u505c\u6b62\u5f85\u3061\u4e2d\u306b\uff0c\u4e88\u671f\u3057\u306a\u3044\u5272\u308a\u8fbc\u307f\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff1a", (Throwable)e);
        }
        try {
            log.info((Object)"\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u3092DSR\u304b\u3089\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059");
            LookupFactory.getLookup(this.DSRURL).unbind(10, this.factoryServiceName);
        }
        catch (Exception e1) {
            throw new RemoteException(e1.getMessage());
        }
        UnicastRemoteObject.unexportObject(this, force);
        log.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }
}

