/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import HTTPClient.NVPair;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TooManyListenersException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.http.RSSHttpResponse;
import org.logical_paradox.rss.http.RSSHttpURLConnection;
import org.logical_paradox.rss.http.RSSHttpURLConnectionFactory;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.robot.RSSWebSpiderRobot;
import org.logical_paradox.rss.robot.event.RSSWSAgentEvent;
import org.logical_paradox.rss.robot.event.RSSWSAgentListener;

public class RSSWebSpiderAgent
extends Thread {
    private static final Log log = LogFactory.getLog(RSSWebSpiderAgent.class);
    private RSSHttpURLConnection con = null;
    private String content = null;
    private RSSWSAgentListener eventListener = null;
    private boolean running = false;
    private RSSWebSpiderRobot robot = null;

    public RSSWebSpiderAgent(RSSWebSpiderRobot r) {
        this.robot = r;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setup(String remoteHost, int timeoutSec) throws MalformedURLException, IOException, TooManyListenersException {
        log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u306e\u30bb\u30c3\u30c8\u30a2\u30c3\u30d7\u3092\u3057\u3066\u3044\u307e\u3059");
        NVPair[] nvp = new NVPair[]{new NVPair("User-Agent", this.robot.getSpiderConfig().getHttpUserAgent()), new NVPair("Cache-Control", "no-cache")};
        RSSHttpURLConnection c = RSSHttpURLConnectionFactory.getConnection(new URL(remoteHost));
        c.setAllowUserInteraction(false);
        c.setDefaultHeaders(nvp);
        c.setTimeout(timeoutSec);
        try {
            c.removeModule(Class.forName("HTTPClient.CookieModule"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.con = c;
        log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u306e\u30bb\u30c3\u30c8\u30a2\u30c3\u30d7\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
    }

    public String getRemoteHost() throws IllegalObjectStateException {
        if (this.con == null) {
            throw new IllegalObjectStateException();
        }
        return this.con.getURL().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u304c\u63a5\u7d9a\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
            this.sendOnConnectEvent(new RSSWSAgentEvent(this));
            boolean rc = this.robot.AtTheBeginningOfAgentCallback(this);
            if (!rc) {
                this.robot.AtTheEndOfAgentCallback(this);
                return;
            }
            log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u304crun()\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
            log.info((Object)("URL: " + this.con.getURL().toString()));
            RSSHttpResponse res = null;
            try {
                res = RSSHttpURLConnectionFactory.getResponse(this.con, "8859_1");
                int responseCode = res.getResponseCode();
                if (!this.robot.getSpiderConfig().isEnabledContentType(res.getHeader("Content-Type"))) {
                    this.content = null;
                    continue;
                }
                if (responseCode == 200) {
                    log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u304c\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u8aad\u307f\u8fbc\u307f\u3092\u59cb\u3081\u307e\u3057\u305f");
                    this.content = res.getText();
                    log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u304c\u63a5\u7d9a\u3092\u9589\u3058\u3066\u3044\u307e\u3059");
                    continue;
                }
                if (responseCode == 301 || responseCode == 302) {
                    String forwardedTo = res.getHeader("Location");
                    if (forwardedTo == null) continue;
                    log.trace((Object)("\u8ee2\u9001\u5148:" + forwardedTo));
                    continue;
                }
                this.content = null;
            }
            catch (Exception e) {
                String errmsg = "failed";
                if (res != null) {
                    errmsg = errmsg + "(" + res.getResponseCode() + ")";
                }
                errmsg = errmsg + " : " + this.con.getURL().toString();
                log.info((Object)errmsg);
                this.content = null;
            }
            finally {
                log.trace((Object)"\u30b9\u30ec\u30c3\u30c9\u304conClose()\u30a4\u30d9\u30f3\u30c8\u3092\u767a\u884c\u3057\u3066\u3044\u307e\u3059");
                try {
                    WebContents webContents = this.robot.getContentsAnalyzer().analyze(res, this.content);
                    if (this.content == null && !webContents.isRobotsTxtFlg()) continue;
                    this.sendOnCloseEvent(new RSSWSAgentEvent(this, webContents));
                }
                catch (Exception e) {
                    log.error((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u51e6\u7406\u4e2d\u306b\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u305f\u306e\u3067\u7121\u8996\u3057\u307e\u3059\uff1a", (Throwable)e);
                }
            }
        }
    }

    public void shutdown() {
        log.info((Object)"\u505c\u6b62\u4fe1\u53f7\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\uff0e\u30b9\u30ec\u30c3\u30c9\u3092\u505c\u6b62\u3057\u307e\u3059\uff0e");
        this.running = false;
        this.interrupt();
    }

    public void addRSSWSAgentListener(RSSWSAgentListener listener) throws TooManyListenersException {
        if (this.eventListener != null) {
            throw new TooManyListenersException();
        }
        this.eventListener = listener;
    }

    public void removeRSSWSAgentListener() {
        this.eventListener = null;
    }

    public void sendOnConnectEvent(RSSWSAgentEvent e) {
        this.eventListener.onConnect(e);
    }

    public void sendOnCloseEvent(RSSWSAgentEvent e) {
        this.eventListener.onClose(e);
    }
}

